/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.codeInspection.ui.ListTable;
import com.intellij.codeInspection.ui.ListWrappingTableModel;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.SuppressForTestsScopeFix;
import com.siyeh.ig.ui.ExternalizableStringSet;
import com.siyeh.ig.ui.UiUtils;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class BadExceptionCaughtInspection
extends BaseInspection {
    public String exceptionsString = "";
    public final ExternalizableStringSet exceptions = new ExternalizableStringSet("java.lang.NullPointerException", "java.lang.IllegalMonitorStateException", "java.lang.ArrayIndexOutOfBoundsException", "java.lang.IndexOutOfBoundsException", "java.util.ConcurrentModificationException");

    public BadExceptionCaughtInspection() {
        if (!this.exceptionsString.isEmpty()) {
            this.exceptions.clear();
            List strings = StringUtil.split((String)this.exceptionsString, (String)",");
            this.exceptions.addAll(strings);
            this.exceptionsString = "";
        }
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiElement context = (PsiElement)infos[0];
        return SuppressForTestsScopeFix.build(this, context);
    }

    public JComponent createOptionsPanel() {
        ListTable table = new ListTable(new ListWrappingTableModel((List)((Object)this.exceptions), InspectionGadgetsBundle.message("exception.class.column.name", new Object[0])));
        return UiUtils.createAddRemoveTreeClassChooserPanel(table, InspectionGadgetsBundle.message("choose.exception.class", new Object[0]), "java.lang.Throwable");
    }

    @NotNull
    public String getID() {
        return "ProhibitedExceptionCaught";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("bad.exception.caught.problem.descriptor", new Object[0]);
        if (string == null) {
            BadExceptionCaughtInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BadExceptionCaughtVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/BadExceptionCaughtInspection", "buildErrorString"));
    }

    private class BadExceptionCaughtVisitor
    extends BaseInspectionVisitor {
        private BadExceptionCaughtVisitor() {
        }

        public void visitCatchSection(PsiCatchSection section) {
            super.visitCatchSection(section);
            PsiParameter parameter2 = section.getParameter();
            if (parameter2 == null) {
                return;
            }
            PsiTypeElement typeElement = parameter2.getTypeElement();
            if (typeElement == null) {
                return;
            }
            PsiTypeElement[] childTypeElements = (PsiTypeElement[])PsiTreeUtil.getChildrenOfType((PsiElement)typeElement, PsiTypeElement.class);
            if (childTypeElements != null) {
                for (PsiTypeElement childTypeElement : childTypeElements) {
                    this.checkTypeElement(childTypeElement);
                }
            } else {
                this.checkTypeElement(typeElement);
            }
        }

        private void checkTypeElement(PsiTypeElement typeElement) {
            PsiType type2 = typeElement.getType();
            if (BadExceptionCaughtInspection.this.exceptions.contains(type2.getCanonicalText())) {
                this.registerError((PsiElement)typeElement, typeElement);
            }
        }
    }
}

