/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public class InstanceofCatchParameterInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("instanceof.catch.parameter.problem.descriptor", new Object[0]);
        if (string == null) {
            InstanceofCatchParameterInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InstanceofCatchParameterVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/InstanceofCatchParameterInspection", "buildErrorString"));
    }

    private static class InstanceofCatchParameterVisitor
    extends BaseInspectionVisitor {
        private InstanceofCatchParameterVisitor() {
        }

        public void visitInstanceOfExpression(@NotNull PsiInstanceOfExpression exp) {
            if (exp == null) {
                InstanceofCatchParameterVisitor.$$$reportNull$$$0(0);
            }
            super.visitInstanceOfExpression(exp);
            if (!ControlFlowUtils.isInCatchBlock((PsiElement)exp)) {
                return;
            }
            PsiTypeElement typeElement = exp.getCheckType();
            if (typeElement == null || !InheritanceUtil.isInheritor((PsiType)typeElement.getType(), (String)"java.lang.Throwable")) {
                return;
            }
            PsiExpression operand2 = ParenthesesUtils.stripParentheses(exp.getOperand());
            if (!(operand2 instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression ref = (PsiReferenceExpression)operand2;
            PsiElement referent = ref.resolve();
            if (!(referent instanceof PsiParameter)) {
                return;
            }
            PsiParameter parameter2 = (PsiParameter)referent;
            if (!(parameter2.getDeclarationScope() instanceof PsiCatchSection)) {
                return;
            }
            this.registerError((PsiElement)operand2, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exp", "com/siyeh/ig/errorhandling/InstanceofCatchParameterInspection$InstanceofCatchParameterVisitor", "visitInstanceOfExpression"));
        }
    }
}

