/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.finalization;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.NotNull;

public class FinalizeNotProtectedInspection
extends BaseInspection {
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("finalize.not.declared.protected.problem.descriptor", new Object[0]);
        if (string == null) {
            FinalizeNotProtectedInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new FinalizeDeclaredProtectedVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ProtectedFinalizeFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/finalization/FinalizeNotProtectedInspection", "buildErrorString"));
    }

    private static class FinalizeDeclaredProtectedVisitor
    extends BaseInspectionVisitor {
        private FinalizeDeclaredProtectedVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                FinalizeDeclaredProtectedVisitor.$$$reportNull$$$0(0);
            }
            if (!MethodUtils.isFinalize(method)) {
                return;
            }
            if (method.hasModifierProperty("protected")) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null || aClass.isInterface()) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/finalization/FinalizeNotProtectedInspection$FinalizeDeclaredProtectedVisitor", "visitMethod"));
        }
    }

    private static class ProtectedFinalizeFix
    extends InspectionGadgetsFix {
        private ProtectedFinalizeFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("change.modifier.quickfix", "protected");
            if (string == null) {
                ProtectedFinalizeFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement methodName = descriptor.getPsiElement();
            PsiMethod method = (PsiMethod)methodName.getParent();
            assert (method != null);
            PsiModifierList modifiers = method.getModifierList();
            modifiers.setModifierProperty("public", false);
            modifiers.setModifierProperty("private", false);
            modifiers.setModifierProperty("protected", true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/finalization/FinalizeNotProtectedInspection$ProtectedFinalizeFix", "getFamilyName"));
        }
    }
}

