/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.inheritance.AbstractMethodOverridesAbstractMethodInspection;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TrackingEquivalenceChecker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedundantMethodOverrideInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("redundant.method.override.problem.descriptor", new Object[0]);
        if (string == null) {
            RedundantMethodOverrideInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RedundantMethodOverrideFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new RedundantMethodOverrideVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/RedundantMethodOverrideInspection", "buildErrorString"));
    }

    private static class RedundantMethodOverrideVisitor
    extends BaseInspectionVisitor {
        private RedundantMethodOverrideVisitor() {
        }

        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            if (method.isConstructor()) {
                return;
            }
            PsiCodeBlock body2 = method.getBody();
            if (body2 == null || method.getNameIdentifier() == null) {
                return;
            }
            PsiMethod[] methods = method.findSuperMethods();
            if (methods.length == 0) {
                return;
            }
            PsiMethod superMethod = methods[0];
            if (superMethod.hasModifierProperty("default") && methods.length > 1) {
                return;
            }
            if (!(AbstractMethodOverridesAbstractMethodInspection.methodsHaveSameAnnotationsAndModifiers(method, superMethod) && AbstractMethodOverridesAbstractMethodInspection.methodsHaveSameReturnTypes(method, superMethod) && AbstractMethodOverridesAbstractMethodInspection.haveSameExceptionSignatures(method, superMethod) && method.isVarArgs() == superMethod.isVarArgs())) {
                return;
            }
            PsiCodeBlock superBody = superMethod.getBody();
            TrackingEquivalenceChecker checker = new TrackingEquivalenceChecker();
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            PsiParameter[] superParameters = superMethod.getParameterList().getParameters();
            for (int i = 0; i < parameters2.length; ++i) {
                PsiParameter parameter2 = parameters2[i];
                PsiParameter superParameter = superParameters[i];
                checker.markDeclarationsAsEquivalent((PsiElement)parameter2, (PsiElement)superParameter);
            }
            checker.markDeclarationsAsEquivalent((PsiElement)method, (PsiElement)superMethod);
            if (checker.codeBlocksAreEquivalent(body2, superBody) || this.isSuperCallWithSameArguments(body2, method, superMethod)) {
                this.registerMethodError(method, new Object[0]);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean isSuperCallWithSameArguments(PsiCodeBlock body2, PsiMethod method, PsiMethod superMethod) {
            PsiExpression expression2;
            PsiStatement[] statements = body2.getStatements();
            if (statements.length != 1) {
                return false;
            }
            PsiStatement statement = statements[0];
            if (PsiType.VOID.equals((Object)method.getReturnType())) {
                if (!(statement instanceof PsiExpressionStatement)) return false;
                PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
                expression2 = expressionStatement.getExpression();
            } else {
                if (!(statement instanceof PsiReturnStatement)) return false;
                PsiReturnStatement returnStatement = (PsiReturnStatement)statement;
                expression2 = ParenthesesUtils.stripParentheses(returnStatement.getReturnValue());
            }
            if (!(expression2 instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
            if (!MethodCallUtils.isSuperMethodCall(methodCallExpression, method)) {
                return false;
            }
            if (!superMethod.hasModifierProperty("protected")) return RedundantMethodOverrideVisitor.areSameArguments(methodCallExpression, method);
            PsiJavaFile file = (PsiJavaFile)method.getContainingFile();
            PsiPackage aPackage = JavaPsiFacade.getInstance((Project)method.getProject()).findPackage(file.getPackageName());
            if (aPackage == null) {
                return false;
            }
            PackageScope scope = new PackageScope(aPackage, false, false);
            if (this.isOnTheFly()) {
                PsiSearchHelper searchHelper = PsiSearchHelper.getInstance((Project)method.getProject());
                PsiSearchHelper.SearchCostResult cost = searchHelper.isCheapEnoughToSearch(method.getName(), (GlobalSearchScope)scope, null, null);
                if (cost == PsiSearchHelper.SearchCostResult.ZERO_OCCURRENCES) {
                    return true;
                }
                if (cost == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
                    return false;
                }
            }
            Query search = ReferencesSearch.search((PsiElement)method, (SearchScope)scope);
            PsiClass containingClass = method.getContainingClass();
            for (PsiReference reference : search) {
                if (PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)reference.getElement(), (boolean)true)) continue;
                return false;
            }
            return RedundantMethodOverrideVisitor.areSameArguments(methodCallExpression, method);
        }

        private static boolean areSameArguments(PsiMethodCallExpression methodCallExpression, PsiMethod method) {
            PsiParameter[] parameters2;
            PsiExpression[] arguments = methodCallExpression.getArgumentList().getExpressions();
            if (arguments.length != (parameters2 = method.getParameterList().getParameters()).length) {
                return false;
            }
            for (int i = 0; i < arguments.length; ++i) {
                PsiExpression argument = arguments[i];
                PsiExpression exp = PsiUtil.deparenthesizeExpression((PsiExpression)argument);
                if (!(exp instanceof PsiReferenceExpression)) {
                    return false;
                }
                PsiElement resolved = ((PsiReferenceExpression)exp).resolve();
                if (method.getManager().areElementsEquivalent((PsiElement)parameters2[i], resolved)) continue;
                return false;
            }
            return true;
        }
    }

    private static class RedundantMethodOverrideFix
    extends InspectionGadgetsFix {
        private RedundantMethodOverrideFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("redundant.method.override.quickfix", new Object[0]);
            if (string == null) {
                RedundantMethodOverrideFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement methodNameIdentifier = descriptor.getPsiElement();
            PsiElement method = methodNameIdentifier.getParent();
            assert (method != null);
            RedundantMethodOverrideFix.deleteElement(method);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/RedundantMethodOverrideInspection$RedundantMethodOverrideFix", "getFamilyName"));
        }
    }
}

