/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeParameterExtendsFinalClassInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Integer problemType = (Integer)infos[1];
        PsiClass aClass = (PsiClass)infos[0];
        String name2 = aClass.getName();
        if (problemType == 1) {
            String string = InspectionGadgetsBundle.message(aClass.isEnum() ? "type.parameter.extends.enum.type.parameter.problem.descriptor" : "type.parameter.extends.final.class.type.parameter.problem.descriptor", name2);
            if (string == null) {
                TypeParameterExtendsFinalClassInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message(aClass.isEnum() ? "type.parameter.extends.enum.wildcard.problem.descriptor" : "type.parameter.extends.final.class.wildcard.problem.descriptor", name2);
        if (string == null) {
            TypeParameterExtendsFinalClassInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new TypeParameterExtendsFinalClassFix();
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return PsiUtil.isLanguageLevel5OrHigher((PsiElement)file);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TypeParameterExtendsFinalClassVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/TypeParameterExtendsFinalClassInspection", "buildErrorString"));
    }

    private static class TypeParameterExtendsFinalClassVisitor
    extends BaseInspectionVisitor {
        private TypeParameterExtendsFinalClassVisitor() {
        }

        public void visitTypeParameter(PsiTypeParameter classParameter) {
            super.visitTypeParameter(classParameter);
            PsiClassType[] extendsListTypes = classParameter.getExtendsListTypes();
            if (extendsListTypes.length < 1) {
                return;
            }
            PsiClassType extendsType = extendsListTypes[0];
            PsiClass aClass = extendsType.resolve();
            if (aClass == null) {
                return;
            }
            if (!aClass.hasModifierProperty("final") && !aClass.isEnum()) {
                return;
            }
            PsiIdentifier nameIdentifier = classParameter.getNameIdentifier();
            if (nameIdentifier != null) {
                this.registerError((PsiElement)nameIdentifier, aClass, 1);
            }
        }

        public void visitTypeElement(PsiTypeElement typeElement) {
            super.visitTypeElement(typeElement);
            PsiType type2 = typeElement.getType();
            if (!(type2 instanceof PsiWildcardType)) {
                return;
            }
            PsiWildcardType wildcardType = (PsiWildcardType)type2;
            PsiType extendsBound = wildcardType.getExtendsBound();
            if (!(extendsBound instanceof PsiClassType)) {
                return;
            }
            PsiClassType classType = (PsiClassType)extendsBound;
            for (PsiType typeParameter : classType.getParameters()) {
                if (!(typeParameter instanceof PsiWildcardType)) continue;
                return;
            }
            PsiClass aClass = classType.resolve();
            if (aClass == null) {
                return;
            }
            if (!aClass.hasModifierProperty("final") && !aClass.isEnum()) {
                return;
            }
            if (aClass.hasTypeParameters() && !PsiUtil.isLanguageLevel8OrHigher((PsiElement)typeElement)) {
                PsiType[] parameters2 = classType.getParameters();
                if (parameters2.length == 0) {
                    return;
                }
                for (PsiType parameter2 : parameters2) {
                    if (!(parameter2 instanceof PsiWildcardType)) continue;
                    return;
                }
            }
            if (TypeParameterExtendsFinalClassVisitor.isWildcardRequired(typeElement)) {
                return;
            }
            this.registerError(typeElement.getFirstChild(), aClass, 2);
        }

        private static boolean isWildcardRequired(PsiTypeElement typeElement) {
            PsiElement ancestor = PsiTreeUtil.skipParentsOfType((PsiElement)typeElement, (Class[])new Class[]{PsiTypeElement.class, PsiJavaCodeReferenceElement.class, PsiReferenceParameterList.class});
            if (ancestor instanceof PsiParameter) {
                PsiParameter parameter2 = (PsiParameter)ancestor;
                PsiElement scope = parameter2.getDeclarationScope();
                if (scope instanceof PsiMethod) {
                    PsiMethod method = (PsiMethod)scope;
                    if (MethodUtils.hasSuper(method)) {
                        return true;
                    }
                } else if (scope instanceof PsiForeachStatement) {
                    PsiForeachStatement foreachStatement = (PsiForeachStatement)scope;
                    PsiExpression iteratedValue2 = foreachStatement.getIteratedValue();
                    if (iteratedValue2 == null) {
                        return true;
                    }
                    PsiParameter iterationParameter = foreachStatement.getIterationParameter();
                    PsiTypeElement foreachTypeElement = iterationParameter.getTypeElement();
                    assert (foreachTypeElement != null);
                    return TypeParameterExtendsFinalClassVisitor.isWildcardRequired(typeElement, foreachTypeElement, JavaGenericsUtil.getCollectionItemType((PsiExpression)iteratedValue2));
                }
            } else if (ancestor instanceof PsiLocalVariable) {
                PsiLocalVariable localVariable = (PsiLocalVariable)ancestor;
                PsiExpression initializer = localVariable.getInitializer();
                return initializer != null && TypeParameterExtendsFinalClassVisitor.isWildcardRequired(typeElement, localVariable.getTypeElement(), initializer.getType());
            }
            return false;
        }

        private static boolean isWildcardRequired(PsiTypeElement innerTypeElement, PsiTypeElement completeTypeElement, PsiType rhsType) {
            PsiType lhsType = completeTypeElement.getType();
            if (lhsType.equals(rhsType) || rhsType == null || !TypeConversionUtil.isAssignable((PsiType)lhsType, (PsiType)rhsType)) {
                return true;
            }
            Object marker = new Object();
            PsiTreeUtil.mark((PsiElement)innerTypeElement, (Object)marker);
            PsiTypeElement copy = (PsiTypeElement)completeTypeElement.copy();
            PsiElement markedElement = PsiTreeUtil.releaseMark((PsiElement)copy, (Object)marker);
            assert (markedElement != null);
            markedElement.replace(markedElement.getLastChild());
            return !TypeConversionUtil.isAssignable((PsiType)copy.getType(), (PsiType)rhsType);
        }
    }

    private static class TypeParameterExtendsFinalClassFix
    extends InspectionGadgetsFix {
        private TypeParameterExtendsFinalClassFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("type.parameter.extends.final.class.quickfix", new Object[0]);
            if (string == null) {
                TypeParameterExtendsFinalClassFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(@NotNull Project project, ProblemDescriptor descriptor) {
            PsiElement element;
            PsiElement parent;
            if (project == null) {
                TypeParameterExtendsFinalClassFix.$$$reportNull$$$0(1);
            }
            if ((parent = (element = descriptor.getPsiElement()).getParent()) instanceof PsiTypeParameter) {
                PsiTypeParameter typeParameter = (PsiTypeParameter)parent;
                TypeParameterExtendsFinalClassFix.replaceTypeParameterUsagesWithType(typeParameter);
                new CommentTracker().deleteAndRestoreComments((PsiElement)typeParameter);
            } else if (parent instanceof PsiTypeElement) {
                PsiTypeElement typeElement = (PsiTypeElement)parent;
                PsiElement lastChild = typeElement.getLastChild();
                if (lastChild == null) {
                    return;
                }
                new CommentTracker().replaceAndRestoreComments((PsiElement)typeElement, lastChild);
            }
        }

        private static void replaceTypeParameterUsagesWithType(PsiTypeParameter typeParameter) {
            PsiClassType[] types = typeParameter.getExtendsList().getReferencedTypes();
            if (types.length < 1) {
                return;
            }
            Project project = typeParameter.getProject();
            PsiJavaCodeReferenceElement classReference2 = JavaPsiFacade.getElementFactory((Project)project).createReferenceElementByType(types[0]);
            Query query = ReferencesSearch.search((PsiElement)typeParameter, (SearchScope)typeParameter.getUseScope());
            for (PsiReference reference : query) {
                PsiElement referenceElement = reference.getElement();
                referenceElement.replace((PsiElement)classReference2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/inheritance/TypeParameterExtendsFinalClassInspection$TypeParameterExtendsFinalClassFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/inheritance/TypeParameterExtendsFinalClassInspection$TypeParameterExtendsFinalClassFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "doFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

