/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.initialization;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.util.SpecialAnnotationsUtil;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.util.ui.CheckBox;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.AddToIgnoreIfAnnotatedByListQuickFix;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.UninitializedReadCollector;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.intellij.lang.annotations.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class InstanceVariableUninitializedUseInspection
extends BaseInspection {
    protected final List<String> annotationNames = new ArrayList<String>();
    public boolean m_ignorePrimitives = false;
    @NonNls
    public String annotationNamesString = "";

    public InstanceVariableUninitializedUseInspection() {
        InstanceVariableUninitializedUseInspection.parseString(this.annotationNamesString, this.annotationNames);
    }

    public JComponent createOptionsPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        JPanel annotationsPanel = SpecialAnnotationsUtil.createSpecialAnnotationsListControl(this.annotationNames, InspectionGadgetsBundle.message("ignore.if.annotated.by", new Object[0]));
        CheckBox checkBox = new CheckBox(InspectionGadgetsBundle.message("primitive.fields.ignore.option", new Object[0]), (InspectionProfileEntry)this, "m_ignorePrimitives");
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        panel2.add((Component)annotationsPanel, constraints);
        constraints.gridy = 1;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        panel2.add((Component)checkBox, constraints);
        return panel2;
    }

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        return "InstanceVariableUsedBeforeInitialized";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("instance.variable.used.before.initialized.problem.descriptor", new Object[0]);
        if (string == null) {
            InstanceVariableUninitializedUseInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            InstanceVariableUninitializedUseInspection.$$$reportNull$$$0(1);
        }
        super.readSettings(element);
        InstanceVariableUninitializedUseInspection.parseString(this.annotationNamesString, this.annotationNames);
    }

    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            InstanceVariableUninitializedUseInspection.$$$reportNull$$$0(2);
        }
        this.annotationNamesString = InstanceVariableUninitializedUseInspection.formatString(this.annotationNames);
        super.writeSettings(element);
    }

    @Override
    protected InspectionGadgetsFix @NotNull [] buildFixes(Object ... infos) {
        PsiField field = (PsiField)infos[0];
        InspectionGadgetsFix[] inspectionGadgetsFixArray = AddToIgnoreIfAnnotatedByListQuickFix.build((PsiModifierListOwner)field, this.annotationNames);
        if (inspectionGadgetsFixArray == null) {
            InstanceVariableUninitializedUseInspection.$$$reportNull$$$0(3);
        }
        return inspectionGadgetsFixArray;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InstanceVariableInitializationVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/initialization/InstanceVariableUninitializedUseInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/initialization/InstanceVariableUninitializedUseInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class InstanceVariableInitializationVisitor
    extends BaseInspectionVisitor {
        private InstanceVariableInitializationVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            PsiType fieldType;
            if (field == null) {
                InstanceVariableInitializationVisitor.$$$reportNull$$$0(0);
            }
            if (field.hasModifierProperty("static") || field.hasModifierProperty("final")) {
                return;
            }
            if (field.getInitializer() != null) {
                return;
            }
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)field, InstanceVariableUninitializedUseInspection.this.annotationNames);
            if (annotation != null) {
                return;
            }
            if (InstanceVariableUninitializedUseInspection.this.m_ignorePrimitives && ClassUtils.isPrimitive(fieldType = field.getType())) {
                return;
            }
            PsiClass aClass = field.getContainingClass();
            if (aClass == null) {
                return;
            }
            for (ImplicitUsageProvider provider : ImplicitUsageProvider.EP_NAME.getExtensionList()) {
                if (!provider.isImplicitWrite((PsiElement)field)) continue;
                return;
            }
            UninitializedReadCollector uninitializedReadsCollector = new UninitializedReadCollector();
            if (!this.isInitializedInInitializer(field, uninitializedReadsCollector)) {
                PsiMethod[] constructors;
                for (PsiMethod psiMethod : constructors = aClass.getConstructors()) {
                    PsiCodeBlock body2 = psiMethod.getBody();
                    uninitializedReadsCollector.blockAssignsVariable(body2, (PsiVariable)field);
                }
            }
            PsiExpression[] badReads = uninitializedReadsCollector.getUninitializedReads();
            for (PsiMethod psiMethod : badReads) {
                this.registerError((PsiElement)psiMethod, field);
            }
        }

        private boolean isInitializedInInitializer(@NotNull PsiField field, UninitializedReadCollector uninitializedReadsCollector) {
            PsiClassInitializer[] initializers;
            PsiClass aClass;
            if (field == null) {
                InstanceVariableInitializationVisitor.$$$reportNull$$$0(1);
            }
            if ((aClass = field.getContainingClass()) == null) {
                return false;
            }
            for (PsiClassInitializer initializer : initializers = aClass.getInitializers()) {
                PsiCodeBlock body2;
                if (initializer.hasModifierProperty("static") || !uninitializedReadsCollector.blockAssignsVariable(body2 = initializer.getBody(), (PsiVariable)field)) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "field";
            objectArray2[1] = "com/siyeh/ig/initialization/InstanceVariableUninitializedUseInspection$InstanceVariableInitializationVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitField";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isInitializedInInitializer";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

