/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.internationalization;

import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.internationalization.NonNlsUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class DateToStringInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "CallToDateToString";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("call.to.date.tostring.problem.descriptor", new Object[0]);
        if (string == null) {
            DateToStringInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new DateToStringVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/internationalization/DateToStringInspection", "buildErrorString"));
    }

    private static class DateToStringVisitor
    extends BaseInspectionVisitor {
        private DateToStringVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            if (expression2 == null) {
                DateToStringVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression2);
            String methodName = MethodCallUtils.getMethodName(expression2);
            if (!"toString".equals(methodName)) {
                return;
            }
            PsiType targetType = MethodCallUtils.getTargetType(expression2);
            if (!TypeUtils.typeEquals("java.util.Date", targetType)) {
                return;
            }
            PsiExpressionList argumentList = expression2.getArgumentList();
            if (!argumentList.isEmpty()) {
                return;
            }
            if (NonNlsUtils.isNonNlsAnnotatedUse((PsiExpression)expression2)) {
                return;
            }
            this.registerMethodCallError(expression2, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/internationalization/DateToStringInspection$DateToStringVisitor", "visitMethodCallExpression"));
        }
    }
}

