/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.maturity;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodCallUtils;
import org.jetbrains.annotations.NotNull;

public class ThreadDumpStackInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "CallToThreadDumpStack";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("dumpstack.call.problem.descriptor", new Object[0]);
        if (string == null) {
            ThreadDumpStackInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ThreadDumpStackVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/maturity/ThreadDumpStackInspection", "buildErrorString"));
    }

    private static class ThreadDumpStackVisitor
    extends BaseInspectionVisitor {
        private ThreadDumpStackVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            if (expression2 == null) {
                ThreadDumpStackVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression2);
            String methodName = MethodCallUtils.getMethodName(expression2);
            if (!"dumpStack".equals(methodName)) {
                return;
            }
            PsiExpressionList argumentList = expression2.getArgumentList();
            if (!argumentList.isEmpty()) {
                return;
            }
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            PsiElement element = methodExpression.resolve();
            if (!(element instanceof PsiMethod)) {
                return;
            }
            PsiMethod method = (PsiMethod)element;
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            String qualifiedName = aClass.getQualifiedName();
            if (!"java.lang.Thread".equals(qualifiedName)) {
                return;
            }
            this.registerMethodCallError(expression2, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/maturity/ThreadDumpStackInspection$ThreadDumpStackVisitor", "visitMethodCallExpression"));
        }
    }
}

