/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import com.siyeh.ig.psiutils.VariableNameGenerator;
import javax.swing.JComponent;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForCanBeForeachInspection
extends BaseInspection {
    public boolean REPORT_INDEXED_LOOP = true;
    public boolean ignoreUntypedCollections;

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ForCanBeForeachFix();
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel2 = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel2.addCheckbox(InspectionGadgetsBundle.message("for.can.be.foreach.option", new Object[0]), "REPORT_INDEXED_LOOP");
        panel2.addCheckbox(InspectionGadgetsBundle.message("for.can.be.foreach.option2", new Object[0]), "ignoreUntypedCollections");
        return panel2;
    }

    static boolean isIndexedListLoopStatement(PsiForStatement forStatement, boolean ignoreUntypedCollections) {
        PsiElement secondDeclaredElement;
        PsiStatement initialization = forStatement.getInitialization();
        if (!(initialization instanceof PsiDeclarationStatement)) {
            return false;
        }
        PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)initialization;
        PsiElement[] declaredElements = declaration2.getDeclaredElements();
        if (declaredElements.length == 1) {
            secondDeclaredElement = null;
        } else if (declaredElements.length == 2) {
            secondDeclaredElement = declaredElements[1];
        } else {
            return false;
        }
        PsiElement declaredElement = declaredElements[0];
        if (!(declaredElement instanceof PsiVariable)) {
            return false;
        }
        PsiVariable indexVariable = (PsiVariable)declaredElement;
        PsiExpression initialValue = indexVariable.getInitializer();
        Object constant = ExpressionUtils.computeConstantExpression(initialValue);
        if (!(constant instanceof Number)) {
            return false;
        }
        Number number = (Number)constant;
        if (number.intValue() != 0) {
            return false;
        }
        PsiExpression condition2 = forStatement.getCondition();
        Holder collectionHolder = ForCanBeForeachInspection.getCollectionFromSizeComparison(condition2, indexVariable, secondDeclaredElement);
        if (collectionHolder == null) {
            return false;
        }
        PsiStatement update2 = forStatement.getUpdate();
        if (!VariableAccessUtils.variableIsIncremented(indexVariable, update2)) {
            return false;
        }
        PsiStatement body2 = forStatement.getBody();
        if (!ForCanBeForeachInspection.isIndexVariableOnlyUsedAsListIndex(collectionHolder, indexVariable, body2)) {
            return false;
        }
        if (collectionHolder != Holder.DUMMY) {
            PsiVariable collection = collectionHolder.getVariable();
            PsiClassType collectionType = (PsiClassType)collection.getType();
            PsiType[] parameters2 = collectionType.getParameters();
            if (ignoreUntypedCollections && parameters2.length == 0) {
                return false;
            }
            return !VariableAccessUtils.variableIsAssigned(collection, (PsiElement)body2);
        }
        return true;
    }

    static boolean isArrayLoopStatement(PsiForStatement forStatement) {
        PsiElement secondDeclaredElement;
        PsiStatement initialization = forStatement.getInitialization();
        if (!(initialization instanceof PsiDeclarationStatement)) {
            return false;
        }
        PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)initialization;
        PsiElement[] declaredElements = declaration2.getDeclaredElements();
        if (declaredElements.length == 1) {
            secondDeclaredElement = null;
        } else if (declaredElements.length == 2) {
            secondDeclaredElement = declaredElements[1];
        } else {
            return false;
        }
        PsiElement declaredElement = declaredElements[0];
        if (!(declaredElement instanceof PsiVariable)) {
            return false;
        }
        PsiVariable indexVariable = (PsiVariable)declaredElement;
        PsiExpression initialValue = indexVariable.getInitializer();
        Object constant = ExpressionUtils.computeConstantExpression(initialValue);
        if (!(constant instanceof Integer)) {
            return false;
        }
        Integer integer = (Integer)constant;
        if (integer != 0) {
            return false;
        }
        PsiStatement update2 = forStatement.getUpdate();
        if (!VariableAccessUtils.variableIsIncremented(indexVariable, update2)) {
            return false;
        }
        PsiExpression condition2 = forStatement.getCondition();
        PsiReferenceExpression arrayReference = ForCanBeForeachInspection.getVariableReferenceFromCondition(condition2, indexVariable, secondDeclaredElement);
        if (arrayReference == null) {
            return false;
        }
        if (!(arrayReference.getType() instanceof PsiArrayType)) {
            return false;
        }
        PsiElement element = arrayReference.resolve();
        if (!(element instanceof PsiVariable)) {
            return false;
        }
        PsiVariable arrayVariable = (PsiVariable)element;
        PsiStatement body2 = forStatement.getBody();
        return body2 == null || ForCanBeForeachInspection.isIndexVariableOnlyUsedAsIndex(arrayVariable, indexVariable, body2) && !VariableAccessUtils.variableIsAssigned(arrayVariable, (PsiElement)body2) && !VariableAccessUtils.arrayContentsAreAssigned(arrayVariable, (PsiElement)body2);
    }

    private static boolean isIndexVariableOnlyUsedAsIndex(@NotNull PsiVariable arrayVariable, @NotNull PsiVariable indexVariable, @Nullable PsiStatement body2) {
        if (arrayVariable == null) {
            ForCanBeForeachInspection.$$$reportNull$$$0(0);
        }
        if (indexVariable == null) {
            ForCanBeForeachInspection.$$$reportNull$$$0(1);
        }
        if (body2 == null) {
            return true;
        }
        VariableOnlyUsedAsIndexVisitor visitor2 = new VariableOnlyUsedAsIndexVisitor(arrayVariable, indexVariable);
        body2.accept((PsiElementVisitor)visitor2);
        return visitor2.isIndexVariableUsedOnlyAsIndex();
    }

    private static boolean isIndexVariableOnlyUsedAsListIndex(Holder collectionHolder, PsiVariable indexVariable, PsiStatement body2) {
        if (body2 == null) {
            return true;
        }
        VariableOnlyUsedAsListIndexVisitor visitor2 = new VariableOnlyUsedAsListIndexVisitor(collectionHolder, indexVariable);
        body2.accept((PsiElementVisitor)visitor2);
        return visitor2.isIndexVariableUsedOnlyAsIndex();
    }

    static boolean isCollectionLoopStatement(PsiForStatement forStatement, boolean ignoreUntypedCollections) {
        PsiStatement initialization = forStatement.getInitialization();
        PsiVariable variable = ForCanBeForeachInspection.getIterableVariable(initialization, ignoreUntypedCollections);
        if (variable == null) {
            return false;
        }
        PsiExpression condition2 = forStatement.getCondition();
        if (!ForCanBeForeachInspection.isHasNext(condition2, variable)) {
            return false;
        }
        PsiStatement update2 = forStatement.getUpdate();
        if (update2 != null && !(update2 instanceof PsiEmptyStatement)) {
            return false;
        }
        PsiStatement body2 = forStatement.getBody();
        if (body2 == null) {
            return false;
        }
        return ForCanBeForeachInspection.hasSimpleNextCall(variable, (PsiElement)body2);
    }

    static PsiVariable getIterableVariable(PsiStatement statement, boolean ignoreUntypedCollections) {
        if (!(statement instanceof PsiDeclarationStatement)) {
            return null;
        }
        PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)statement;
        PsiElement[] declaredElements = declaration2.getDeclaredElements();
        if (declaredElements.length != 1) {
            return null;
        }
        PsiElement declaredElement = declaredElements[0];
        if (!(declaredElement instanceof PsiVariable)) {
            return null;
        }
        PsiVariable variable = (PsiVariable)declaredElement;
        if (!TypeUtils.variableHasTypeOrSubtype(variable, "java.util.Iterator", "java.util.ListIterator")) {
            return null;
        }
        PsiExpression initialValue = ParenthesesUtils.stripParentheses(variable.getInitializer());
        if (!(initialValue instanceof PsiMethodCallExpression)) {
            return null;
        }
        PsiMethodCallExpression initialCall = (PsiMethodCallExpression)initialValue;
        if (!initialCall.getArgumentList().isEmpty()) {
            return null;
        }
        PsiReferenceExpression initialMethodExpression = initialCall.getMethodExpression();
        String initialCallName = initialMethodExpression.getReferenceName();
        if (!"iterator".equals(initialCallName) && !"listIterator".equals(initialCallName)) {
            return null;
        }
        PsiExpression qualifier = ExpressionUtils.getEffectiveQualifier(initialMethodExpression);
        if (qualifier == null || qualifier instanceof PsiSuperExpression) {
            return null;
        }
        PsiType qualifierType = qualifier.getType();
        if (!(qualifierType instanceof PsiClassType)) {
            return null;
        }
        PsiClassType classType = (PsiClassType)qualifierType;
        PsiClass qualifierClass = classType.resolve();
        if (ignoreUntypedCollections) {
            PsiClassType type2 = (PsiClassType)variable.getType();
            PsiType[] parameters2 = type2.getParameters();
            PsiType[] parameters1 = classType.getParameters();
            if (parameters2.length == 0 && parameters1.length == 0) {
                return null;
            }
        }
        if (!InheritanceUtil.isInheritor((PsiClass)qualifierClass, (String)"java.lang.Iterable")) {
            return null;
        }
        return variable;
    }

    static boolean hasSimpleNextCall(PsiVariable iterator, PsiElement context) {
        if (context == null) {
            return false;
        }
        IteratorNextVisitor visitor2 = new IteratorNextVisitor(iterator);
        context.accept((PsiElementVisitor)visitor2);
        return visitor2.hasSimpleNextCall();
    }

    static boolean isHasNext(PsiExpression condition2, PsiVariable iterator) {
        if (!((condition2 = ParenthesesUtils.stripParentheses(condition2)) instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)condition2;
        if (!call.getArgumentList().isEmpty()) {
            return false;
        }
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        String methodName = methodExpression.getReferenceName();
        if (!"hasNext".equals(methodName)) {
            return false;
        }
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        return ExpressionUtils.isReferenceTo(qualifier, iterator);
    }

    @Nullable
    private static PsiReferenceExpression getVariableReferenceFromCondition(PsiExpression condition2, PsiVariable variable, PsiElement secondDeclaredElement) {
        PsiExpression qualifierExpression2;
        PsiReferenceExpression referenceExpression;
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)ObjectUtils.tryCast((Object)ParenthesesUtils.stripParentheses(condition2), PsiBinaryExpression.class);
        if (binaryExpression == null) {
            return null;
        }
        IElementType tokenType = binaryExpression.getOperationTokenType();
        PsiExpression lhs = ParenthesesUtils.stripParentheses(binaryExpression.getLOperand());
        PsiExpression rhs = ParenthesesUtils.stripParentheses(binaryExpression.getROperand());
        if (lhs == null || rhs == null) {
            return null;
        }
        if (tokenType.equals(JavaTokenType.LT)) {
            if (!ExpressionUtils.isReferenceTo(lhs, variable) || !(rhs instanceof PsiReferenceExpression)) {
                return null;
            }
            referenceExpression = (PsiReferenceExpression)rhs;
        } else if (tokenType.equals(JavaTokenType.GT)) {
            if (!ExpressionUtils.isReferenceTo(rhs, variable) || !(lhs instanceof PsiReferenceExpression)) {
                return null;
            }
            referenceExpression = (PsiReferenceExpression)lhs;
        } else {
            return null;
        }
        if (ExpressionUtils.getArrayFromLengthExpression((PsiExpression)referenceExpression) == null) {
            PsiElement target = referenceExpression.resolve();
            if (secondDeclaredElement != null && !secondDeclaredElement.equals(target)) {
                return null;
            }
            if (target instanceof PsiVariable) {
                PsiVariable maxVariable = (PsiVariable)target;
                PsiCodeBlock context = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)maxVariable, PsiCodeBlock.class);
                if (context == null || VariableAccessUtils.variableIsAssigned(maxVariable, (PsiElement)context)) {
                    return null;
                }
                PsiExpression expression2 = ParenthesesUtils.stripParentheses(maxVariable.getInitializer());
                if (!(expression2 instanceof PsiReferenceExpression)) {
                    return null;
                }
                referenceExpression = (PsiReferenceExpression)expression2;
                if (ExpressionUtils.getArrayFromLengthExpression((PsiExpression)referenceExpression) == null) {
                    return null;
                }
            }
        } else if (secondDeclaredElement != null) {
            return null;
        }
        if ((qualifierExpression2 = ParenthesesUtils.stripParentheses(referenceExpression.getQualifierExpression())) instanceof PsiReferenceExpression) {
            return (PsiReferenceExpression)qualifierExpression2;
        }
        if (qualifierExpression2 instanceof PsiThisExpression || qualifierExpression2 instanceof PsiSuperExpression || qualifierExpression2 == null) {
            return referenceExpression;
        }
        return null;
    }

    @Nullable
    private static Holder getCollectionFromSizeComparison(PsiExpression condition2, PsiVariable variable, PsiElement secondDeclaredElement) {
        if (!((condition2 = ParenthesesUtils.stripParentheses(condition2)) instanceof PsiBinaryExpression)) {
            return null;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)condition2;
        IElementType tokenType = binaryExpression.getOperationTokenType();
        PsiExpression rhs = binaryExpression.getROperand();
        PsiExpression lhs = binaryExpression.getLOperand();
        if (tokenType.equals(JavaTokenType.LT)) {
            if (!ExpressionUtils.isReferenceTo(lhs, variable)) {
                return null;
            }
            return ForCanBeForeachInspection.getCollectionFromListMethodCall(rhs, "size", secondDeclaredElement);
        }
        if (tokenType.equals(JavaTokenType.GT)) {
            if (!ExpressionUtils.isReferenceTo(rhs, variable)) {
                return null;
            }
            return ForCanBeForeachInspection.getCollectionFromListMethodCall(lhs, "size", secondDeclaredElement);
        }
        return null;
    }

    static boolean expressionIsListGetLookup(PsiExpression expression2) {
        if (!((expression2 = ParenthesesUtils.stripParentheses(expression2)) instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression reference = (PsiMethodCallExpression)expression2;
        PsiReferenceExpression methodExpression = reference.getMethodExpression();
        PsiElement resolved = methodExpression.resolve();
        if (!(resolved instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method = (PsiMethod)resolved;
        if (!"get".equals(method.getName())) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        return InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.util.List");
    }

    @Nullable
    private static Holder getCollectionFromListMethodCall(PsiExpression expression2, String methodName, PsiElement secondDeclaredElement) {
        if ((expression2 = ParenthesesUtils.stripParentheses(expression2)) instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression2;
            PsiElement target = referenceExpression.resolve();
            if (secondDeclaredElement != null && !secondDeclaredElement.equals(target)) {
                return null;
            }
            if (!(target instanceof PsiVariable)) {
                return null;
            }
            PsiVariable variable = (PsiVariable)target;
            PsiCodeBlock context = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
            if (context == null) {
                return null;
            }
            if (VariableAccessUtils.variableIsAssigned(variable, (PsiElement)context)) {
                return null;
            }
            expression2 = ParenthesesUtils.stripParentheses(variable.getInitializer());
        } else if (secondDeclaredElement != null) {
            return null;
        }
        if (!(expression2 instanceof PsiMethodCallExpression)) {
            return null;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        String referenceName = methodExpression.getReferenceName();
        if (!methodName.equals(referenceName)) {
            return null;
        }
        PsiMethod method = methodCallExpression.resolveMethod();
        if (method == null) {
            return null;
        }
        PsiClass containingClass = method.getContainingClass();
        if (!InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"java.util.List")) {
            return null;
        }
        PsiExpression qualifierExpression2 = ParenthesesUtils.stripParentheses(methodExpression.getQualifierExpression());
        if (qualifierExpression2 == null || qualifierExpression2 instanceof PsiThisExpression || qualifierExpression2 instanceof PsiSuperExpression) {
            return Holder.DUMMY;
        }
        if (!(qualifierExpression2 instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifierExpression2;
        PsiElement target = referenceExpression.resolve();
        if (!(target instanceof PsiVariable)) {
            return null;
        }
        PsiVariable variable = (PsiVariable)target;
        return new Holder(variable);
    }

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        return "ForLoopReplaceableByForEach";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("for.can.be.foreach.problem.descriptor", new Object[0]);
        if (string == null) {
            ForCanBeForeachInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return PsiUtil.isLanguageLevel5OrHigher((PsiElement)file);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ForCanBeForeachVisitor();
    }

    @Nullable
    static PsiType getContentType(PsiType type2, String containerClassName) {
        PsiType parameterType = PsiUtil.substituteTypeParameter((PsiType)type2, (String)containerClassName, (int)0, (boolean)true);
        return GenericsUtil.getVariableTypeByExpressionType((PsiType)parameterType);
    }

    static void replaceIteratorNext(PsiElement element, String contentVariableName, PsiVariable iterator, PsiType contentType, PsiElement childToSkip, CommentTracker commentTracker, StringBuilder out) {
        if (ForCanBeForeachInspection.isIteratorNext(element, iterator, contentType)) {
            out.append(contentVariableName);
        } else {
            PsiElement[] children = element.getChildren();
            if (children.length == 0) {
                if (PsiUtil.isJavaToken((PsiElement)element, (IElementType)JavaTokenType.INSTANCEOF_KEYWORD) && out.charAt(out.length() - 1) != ' ') {
                    out.append(' ');
                }
                out.append(commentTracker.text(element));
            } else {
                boolean skippingWhiteSpace = false;
                for (PsiElement child : children) {
                    if (ForCanBeForeachInspection.shouldSkip(iterator, contentType, child) || child.equals(childToSkip)) {
                        skippingWhiteSpace = true;
                        continue;
                    }
                    if (child instanceof PsiWhiteSpace && skippingWhiteSpace) continue;
                    skippingWhiteSpace = false;
                    ForCanBeForeachInspection.replaceIteratorNext(child, contentVariableName, iterator, contentType, childToSkip, commentTracker, out);
                }
            }
        }
    }

    static boolean shouldSkip(PsiVariable iterator, PsiType contentType, PsiElement child) {
        if (!(child instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiExpressionStatement expressionStatement = (PsiExpressionStatement)child;
        PsiExpression expression2 = expressionStatement.getExpression();
        return ForCanBeForeachInspection.isIteratorNext((PsiElement)expression2, iterator, contentType);
    }

    static boolean isIteratorNextDeclaration(PsiStatement statement, PsiVariable iterator, PsiType contentType) {
        if (!(statement instanceof PsiDeclarationStatement)) {
            return false;
        }
        PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)statement;
        PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
        if (declaredElements.length != 1) {
            return false;
        }
        PsiElement declaredElement = declaredElements[0];
        if (!(declaredElement instanceof PsiVariable)) {
            return false;
        }
        PsiVariable variable = (PsiVariable)declaredElement;
        PsiExpression initializer = variable.getInitializer();
        return ForCanBeForeachInspection.isIteratorNext((PsiElement)initializer, iterator, contentType);
    }

    static boolean isIteratorNext(PsiElement element, PsiVariable iterator, @NotNull PsiType contentType) {
        if (contentType == null) {
            ForCanBeForeachInspection.$$$reportNull$$$0(3);
        }
        if (element == null) {
            return false;
        }
        if (element instanceof PsiParenthesizedExpression) {
            return ForCanBeForeachInspection.isIteratorNext((PsiElement)((PsiParenthesizedExpression)element).getExpression(), iterator, contentType);
        }
        if (element instanceof PsiTypeCastExpression) {
            PsiTypeCastExpression castExpression = (PsiTypeCastExpression)element;
            PsiType type2 = castExpression.getType();
            if (!contentType.equals(type2)) {
                return false;
            }
            PsiExpression operand2 = castExpression.getOperand();
            return ForCanBeForeachInspection.isIteratorNext((PsiElement)operand2, iterator, contentType);
        }
        if (!(element instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression callExpression = (PsiMethodCallExpression)element;
        if (!callExpression.getArgumentList().isEmpty()) {
            return false;
        }
        PsiReferenceExpression reference = callExpression.getMethodExpression();
        String referenceName = reference.getReferenceName();
        if (!"next".equals(referenceName)) {
            return false;
        }
        PsiExpression expression2 = reference.getQualifierExpression();
        return ExpressionUtils.isReferenceTo(expression2, iterator);
    }

    static String createNewVariableName(@NotNull PsiElement scope, PsiType type2, @Nullable String containerName) {
        if (scope == null) {
            ForCanBeForeachInspection.$$$reportNull$$$0(4);
        }
        return new VariableNameGenerator(scope, VariableKind.PARAMETER).byCollectionName(containerName).byType(type2).byName("value", "item", "element").generate(true);
    }

    @Nullable
    static PsiStatement getFirstStatement(PsiStatement body2) {
        if (!(body2 instanceof PsiBlockStatement)) {
            return body2;
        }
        PsiBlockStatement block = (PsiBlockStatement)body2;
        PsiCodeBlock codeBlock = block.getCodeBlock();
        return ControlFlowUtils.getFirstStatementInBlock(codeBlock);
    }

    @NotNull
    private static String getVariableReferenceText(PsiReferenceExpression reference, PsiVariable variable, PsiElement context) {
        PsiExpression effectiveQualifier;
        String text2 = reference.getText();
        PsiResolveHelper resolveHelper = PsiResolveHelper.SERVICE.getInstance((Project)context.getProject());
        PsiExpression qualifier = reference.getQualifierExpression();
        while (qualifier != null) {
            if (!(qualifier instanceof PsiReferenceExpression)) {
                String string = text2;
                if (string == null) {
                    ForCanBeForeachInspection.$$$reportNull$$$0(5);
                }
                return string;
            }
            qualifier = ((PsiReferenceExpression)qualifier).getQualifierExpression();
        }
        PsiVariable target = resolveHelper.resolveReferencedVariable(text2, context);
        if (variable != target && (effectiveQualifier = ExpressionUtils.getEffectiveQualifier(reference)) != null) {
            String string = effectiveQualifier.getText() + "." + text2;
            if (string == null) {
                ForCanBeForeachInspection.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = text2;
        if (string == null) {
            ForCanBeForeachInspection.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayVariable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexVariable";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/migration/ForCanBeForeachInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/migration/ForCanBeForeachInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableReferenceText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isIndexVariableOnlyUsedAsIndex";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isIteratorNext";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createNewVariableName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ForCanBeForeachFix
    extends InspectionGadgetsFix {
        private ForCanBeForeachFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("foreach.replace.quickfix", new Object[0]);
            if (string == null) {
                ForCanBeForeachFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement forElement = descriptor.getPsiElement();
            PsiElement parent = forElement.getParent();
            if (!(parent instanceof PsiForStatement)) {
                return;
            }
            PsiForStatement forStatement = (PsiForStatement)parent;
            if (ForCanBeForeachInspection.isArrayLoopStatement(forStatement)) {
                this.replaceArrayLoopWithForeach(forStatement);
            } else if (ForCanBeForeachInspection.isCollectionLoopStatement(forStatement, ForCanBeForeachInspection.this.ignoreUntypedCollections)) {
                this.replaceCollectionLoopWithForeach(forStatement);
            } else if (ForCanBeForeachInspection.isIndexedListLoopStatement(forStatement, ForCanBeForeachInspection.this.ignoreUntypedCollections)) {
                this.replaceIndexedListLoopWithForeach(forStatement);
            }
        }

        private void replaceIndexedListLoopWithForeach(@NotNull PsiForStatement forStatement) {
            String finalString;
            PsiDeclarationStatement statementToSkip;
            String contentVariableName;
            PsiVariable listVariable;
            PsiReferenceExpression referenceExpression;
            PsiElement target;
            PsiVariable indexVariable;
            if (forStatement == null) {
                ForCanBeForeachFix.$$$reportNull$$$0(1);
            }
            if ((indexVariable = this.getIndexVariable(forStatement)) == null) {
                return;
            }
            PsiExpression collectionSize = this.getMaximum(forStatement);
            if (collectionSize instanceof PsiReferenceExpression && (target = (referenceExpression = (PsiReferenceExpression)collectionSize).resolve()) instanceof PsiVariable) {
                PsiVariable variable = (PsiVariable)target;
                collectionSize = ParenthesesUtils.stripParentheses(variable.getInitializer());
            }
            if (!(collectionSize instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)ParenthesesUtils.stripParentheses(collectionSize);
            if (methodCallExpression == null) {
                return;
            }
            PsiReferenceExpression listLengthExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifier = ParenthesesUtils.stripParentheses(ExpressionUtils.getEffectiveQualifier(listLengthExpression));
            if (qualifier == null) {
                return;
            }
            PsiReferenceExpression listReference = qualifier instanceof PsiReferenceExpression ? (PsiReferenceExpression)qualifier : null;
            PsiType type2 = qualifier.getType();
            if (type2 == null) {
                return;
            }
            PsiType parameterType = ForCanBeForeachInspection.getContentType(type2, "java.util.Collection");
            if (parameterType == null) {
                parameterType = TypeUtils.getObjectType((PsiElement)forStatement);
            }
            if (listReference == null) {
                listVariable = null;
            } else {
                PsiElement target2 = listReference.resolve();
                if (!(target2 instanceof PsiVariable)) {
                    return;
                }
                listVariable = (PsiVariable)target2;
            }
            PsiStatement body2 = forStatement.getBody();
            PsiStatement firstStatement = ForCanBeForeachInspection.getFirstStatement(body2);
            boolean isDeclaration = this.isListElementDeclaration(firstStatement, listVariable, indexVariable);
            if (isDeclaration) {
                PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)firstStatement;
                PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
                PsiElement declaredElement = declaredElements[0];
                if (!(declaredElement instanceof PsiVariable)) {
                    return;
                }
                PsiVariable variable = (PsiVariable)declaredElement;
                contentVariableName = variable.getName();
                parameterType = variable.getType();
                statementToSkip = declarationStatement;
                finalString = variable.hasModifierProperty("final") ? "final " : "";
            } else {
                String collectionName = listReference == null ? null : listReference.getReferenceName();
                contentVariableName = ForCanBeForeachInspection.createNewVariableName((PsiElement)forStatement, parameterType, collectionName);
                finalString = "";
                statementToSkip = null;
            }
            CommentTracker ct = new CommentTracker();
            StringBuilder newStatement = new StringBuilder("for(");
            newStatement.append(finalString).append(parameterType.getCanonicalText()).append(' ').append(contentVariableName).append(": ");
            String listName = listReference == null ? ct.text((PsiElement)qualifier) : ForCanBeForeachInspection.getVariableReferenceText(listReference, listVariable, (PsiElement)forStatement);
            newStatement.append(listName).append(')');
            if (body2 != null) {
                this.replaceCollectionGetAccess((PsiElement)body2, contentVariableName, listVariable, indexVariable, (PsiElement)statementToSkip, ct, newStatement);
            }
            ct.replaceAndRestoreComments((PsiElement)forStatement, newStatement.toString());
        }

        private PsiExpression getMaximum(PsiForStatement statement) {
            PsiExpression condition2 = ParenthesesUtils.stripParentheses(statement.getCondition());
            if (!(condition2 instanceof PsiBinaryExpression)) {
                return null;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)condition2;
            PsiExpression lhs = ParenthesesUtils.stripParentheses(binaryExpression.getLOperand());
            if (lhs == null) {
                return null;
            }
            PsiExpression rhs = ParenthesesUtils.stripParentheses(binaryExpression.getROperand());
            if (rhs == null) {
                return null;
            }
            IElementType tokenType = binaryExpression.getOperationTokenType();
            if (JavaTokenType.LT.equals(tokenType)) {
                return rhs;
            }
            if (JavaTokenType.GT.equals(tokenType)) {
                return lhs;
            }
            return null;
        }

        @Nullable
        private PsiVariable getIndexVariable(@NotNull PsiForStatement forStatement) {
            PsiStatement initialization;
            if (forStatement == null) {
                ForCanBeForeachFix.$$$reportNull$$$0(2);
            }
            if (!((initialization = forStatement.getInitialization()) instanceof PsiDeclarationStatement)) {
                return null;
            }
            PsiElement declaration2 = ((PsiDeclarationStatement)initialization).getDeclaredElements()[0];
            if (!(declaration2 instanceof PsiVariable)) {
                return null;
            }
            return (PsiVariable)declaration2;
        }

        private void replaceCollectionLoopWithForeach(@NotNull PsiForStatement forStatement) {
            String finalString;
            PsiDeclarationStatement statementToSkip;
            String contentVariableName;
            if (forStatement == null) {
                ForCanBeForeachFix.$$$reportNull$$$0(3);
            }
            PsiStatement body2 = forStatement.getBody();
            PsiStatement firstStatement = ForCanBeForeachInspection.getFirstStatement(body2);
            PsiStatement initialization = forStatement.getInitialization();
            if (!(initialization instanceof PsiDeclarationStatement)) {
                return;
            }
            PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)initialization;
            PsiElement declaredIterator = declaration2.getDeclaredElements()[0];
            if (!(declaredIterator instanceof PsiVariable)) {
                return;
            }
            PsiVariable iterator = (PsiVariable)declaredIterator;
            PsiMethodCallExpression initializer = (PsiMethodCallExpression)ParenthesesUtils.stripParentheses(iterator.getInitializer());
            if (initializer == null) {
                return;
            }
            PsiReferenceExpression methodExpression = initializer.getMethodExpression();
            PsiExpression collection = ParenthesesUtils.stripParentheses(ExpressionUtils.getEffectiveQualifier(methodExpression));
            if (collection == null) {
                return;
            }
            PsiType collectionType = collection.getType();
            if (collectionType == null) {
                return;
            }
            PsiType contentType = ForCanBeForeachInspection.getContentType(collectionType, "java.lang.Iterable");
            if (contentType == null) {
                return;
            }
            PsiType iteratorContentType = ForCanBeForeachInspection.getContentType(iterator.getType(), "java.util.Iterator");
            if (TypeUtils.isJavaLangObject(iteratorContentType)) {
                iteratorContentType = ForCanBeForeachInspection.getContentType(initializer.getType(), "java.util.Iterator");
            }
            if (iteratorContentType == null) {
                return;
            }
            boolean isDeclaration = ForCanBeForeachInspection.isIteratorNextDeclaration(firstStatement, iterator, contentType);
            if (isDeclaration) {
                PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)firstStatement;
                PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
                PsiElement declaredElement = declaredElements[0];
                if (!(declaredElement instanceof PsiVariable)) {
                    return;
                }
                PsiVariable variable = (PsiVariable)declaredElement;
                iteratorContentType = variable.getType();
                contentVariableName = variable.getName();
                statementToSkip = declarationStatement;
                finalString = variable.hasModifierProperty("final") ? "final " : "";
            } else {
                if (collection instanceof PsiReferenceExpression) {
                    PsiReferenceExpression referenceExpression = (PsiReferenceExpression)collection;
                    String collectionName = referenceExpression.getReferenceName();
                    contentVariableName = ForCanBeForeachInspection.createNewVariableName((PsiElement)forStatement, contentType, collectionName);
                } else {
                    contentVariableName = ForCanBeForeachInspection.createNewVariableName((PsiElement)forStatement, contentType, null);
                }
                finalString = JavaCodeStyleSettings.getInstance((PsiFile)forStatement.getContainingFile()).GENERATE_FINAL_LOCALS ? "final " : "";
                statementToSkip = null;
            }
            String contentTypeString = iteratorContentType.getCanonicalText();
            CommentTracker ct = new CommentTracker();
            StringBuilder newStatement = new StringBuilder();
            newStatement.append("for(");
            newStatement.append(finalString);
            newStatement.append(contentTypeString);
            newStatement.append(' ');
            newStatement.append(contentVariableName);
            newStatement.append(": ");
            if (!TypeConversionUtil.isAssignable((PsiType)iteratorContentType, (PsiType)contentType)) {
                newStatement.append('(').append("java.lang.Iterable<").append(contentTypeString).append('>').append(')');
            }
            newStatement.append(ct.text((PsiElement)collection));
            newStatement.append(')');
            ForCanBeForeachInspection.replaceIteratorNext((PsiElement)body2, contentVariableName, iterator, contentType, (PsiElement)statementToSkip, ct, newStatement);
            ct.replaceAndRestoreComments((PsiElement)forStatement, newStatement.toString());
        }

        private void replaceArrayLoopWithForeach(@NotNull PsiForStatement forStatement) {
            PsiDeclarationStatement statementToSkip;
            String finalString;
            String contentVariableName;
            PsiType type2;
            PsiExpression maximum;
            if (forStatement == null) {
                ForCanBeForeachFix.$$$reportNull$$$0(4);
            }
            if (!((maximum = this.getMaximum(forStatement)) instanceof PsiReferenceExpression)) {
                return;
            }
            PsiVariable indexVariable = this.getIndexVariable(forStatement);
            if (indexVariable == null) {
                return;
            }
            PsiReferenceExpression arrayLengthExpression = (PsiReferenceExpression)maximum;
            PsiReferenceExpression arrayReference = (PsiReferenceExpression)ParenthesesUtils.stripParentheses(arrayLengthExpression.getQualifierExpression());
            if (arrayReference == null) {
                PsiElement target = arrayLengthExpression.resolve();
                if (!(target instanceof PsiVariable)) {
                    return;
                }
                PsiVariable variable = (PsiVariable)target;
                PsiExpression initializer = ParenthesesUtils.stripParentheses(variable.getInitializer());
                if (!(initializer instanceof PsiReferenceExpression)) {
                    return;
                }
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)initializer;
                arrayReference = (PsiReferenceExpression)ParenthesesUtils.stripParentheses(referenceExpression.getQualifierExpression());
                if (arrayReference == null) {
                    return;
                }
            }
            if (!((type2 = arrayReference.getType()) instanceof PsiArrayType)) {
                return;
            }
            PsiArrayType arrayType = (PsiArrayType)type2;
            PsiType componentType = arrayType.getComponentType();
            PsiElement target = arrayReference.resolve();
            if (!(target instanceof PsiVariable)) {
                return;
            }
            PsiVariable arrayVariable = (PsiVariable)target;
            PsiStatement body2 = forStatement.getBody();
            PsiStatement firstStatement = ForCanBeForeachInspection.getFirstStatement(body2);
            boolean isDeclaration = this.isArrayElementDeclaration(firstStatement, arrayVariable, indexVariable);
            if (isDeclaration) {
                PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)firstStatement;
                PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
                PsiElement declaredElement = declaredElements[0];
                if (!(declaredElement instanceof PsiVariable)) {
                    return;
                }
                PsiVariable variable = (PsiVariable)declaredElement;
                componentType = variable.getType();
                if (VariableAccessUtils.variableIsAssigned(variable, (PsiElement)forStatement)) {
                    String collectionName = arrayReference.getReferenceName();
                    contentVariableName = ForCanBeForeachInspection.createNewVariableName((PsiElement)forStatement, componentType, collectionName);
                    finalString = JavaCodeStyleSettings.getInstance((PsiFile)forStatement.getContainingFile()).GENERATE_FINAL_LOCALS ? "final " : "";
                    statementToSkip = null;
                } else {
                    contentVariableName = variable.getName();
                    statementToSkip = declarationStatement;
                    finalString = variable.hasModifierProperty("final") ? "final " : "";
                }
            } else {
                String collectionName = arrayReference.getReferenceName();
                contentVariableName = ForCanBeForeachInspection.createNewVariableName((PsiElement)forStatement, componentType, collectionName);
                finalString = JavaCodeStyleSettings.getInstance((PsiFile)forStatement.getContainingFile()).GENERATE_FINAL_LOCALS ? "final " : "";
                statementToSkip = null;
            }
            CommentTracker ct = new CommentTracker();
            StringBuilder newStatement = new StringBuilder();
            newStatement.append("for(");
            newStatement.append(finalString);
            newStatement.append(componentType.getCanonicalText());
            newStatement.append(' ');
            newStatement.append(contentVariableName);
            newStatement.append(": ");
            String arrayName = ForCanBeForeachInspection.getVariableReferenceText(arrayReference, arrayVariable, (PsiElement)forStatement);
            newStatement.append(arrayName);
            newStatement.append(')');
            if (body2 != null) {
                this.replaceArrayAccess((PsiElement)body2, contentVariableName, arrayVariable, indexVariable, (PsiElement)statementToSkip, ct, newStatement);
            }
            ct.replaceAndRestoreComments((PsiElement)forStatement, newStatement.toString());
        }

        private void replaceArrayAccess(PsiElement element, String contentVariableName, PsiVariable arrayVariable, PsiVariable indexVariable, PsiElement childToSkip, CommentTracker commentTracker, StringBuilder out) {
            if (element instanceof PsiExpression && this.isArrayLookup((PsiExpression)element, indexVariable, arrayVariable)) {
                out.append(contentVariableName);
            } else {
                PsiElement[] children = element.getChildren();
                if (children.length == 0) {
                    if (PsiUtil.isJavaToken((PsiElement)element, (IElementType)JavaTokenType.INSTANCEOF_KEYWORD) && out.charAt(out.length() - 1) != ' ') {
                        out.append(' ');
                    }
                    out.append(commentTracker.text(element));
                } else {
                    boolean skippingWhiteSpace = false;
                    for (PsiElement child : children) {
                        if (child.equals(childToSkip)) {
                            skippingWhiteSpace = true;
                            continue;
                        }
                        if (child instanceof PsiWhiteSpace && skippingWhiteSpace) continue;
                        skippingWhiteSpace = false;
                        this.replaceArrayAccess(child, contentVariableName, arrayVariable, indexVariable, childToSkip, commentTracker, out);
                    }
                }
            }
        }

        private void replaceCollectionGetAccess(PsiElement element, String contentVariableName, PsiVariable listVariable, PsiVariable indexVariable, PsiElement childToSkip, CommentTracker commentTracker, StringBuilder out) {
            if (this.isListGetLookup(element, indexVariable, listVariable)) {
                out.append(contentVariableName);
            } else {
                PsiElement[] children = element.getChildren();
                if (children.length == 0) {
                    if (PsiUtil.isJavaToken((PsiElement)element, (IElementType)JavaTokenType.INSTANCEOF_KEYWORD) && out.charAt(out.length() - 1) != ' ') {
                        out.append(' ');
                    }
                    out.append(commentTracker.text(element));
                } else {
                    boolean skippingWhiteSpace = false;
                    for (PsiElement child : children) {
                        if (child.equals(childToSkip)) {
                            skippingWhiteSpace = true;
                            continue;
                        }
                        if (child instanceof PsiWhiteSpace && skippingWhiteSpace) continue;
                        skippingWhiteSpace = false;
                        this.replaceCollectionGetAccess(child, contentVariableName, listVariable, indexVariable, childToSkip, commentTracker, out);
                    }
                }
            }
        }

        private boolean isListGetLookup(PsiElement element, PsiVariable indexVariable, PsiVariable listVariable) {
            if (!(element instanceof PsiExpression)) {
                return false;
            }
            PsiExpression expression2 = (PsiExpression)element;
            if (!ForCanBeForeachInspection.expressionIsListGetLookup(expression2)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)ParenthesesUtils.stripParentheses(expression2);
            if (methodCallExpression == null) {
                return false;
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifierExpression2 = ParenthesesUtils.stripParentheses(methodExpression.getQualifierExpression());
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] expressions2 = argumentList.getExpressions();
            if (expressions2.length != 1) {
                return false;
            }
            if (!ExpressionUtils.isReferenceTo(expressions2[0], indexVariable)) {
                return false;
            }
            if (qualifierExpression2 == null || qualifierExpression2 instanceof PsiThisExpression || qualifierExpression2 instanceof PsiSuperExpression) {
                return listVariable == null;
            }
            if (!(qualifierExpression2 instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifierExpression2;
            PsiExpression qualifier = ParenthesesUtils.stripParentheses(referenceExpression.getQualifierExpression());
            if (qualifier != null && !(qualifier instanceof PsiThisExpression) && !(qualifier instanceof PsiSuperExpression)) {
                return false;
            }
            PsiElement target = referenceExpression.resolve();
            return listVariable.equals(target);
        }

        private boolean isArrayElementDeclaration(PsiStatement statement, PsiVariable arrayVariable, PsiVariable indexVariable) {
            if (!(statement instanceof PsiDeclarationStatement)) {
                return false;
            }
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)statement;
            PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
            if (declaredElements.length != 1) {
                return false;
            }
            PsiElement declaredElement = declaredElements[0];
            if (!(declaredElement instanceof PsiVariable)) {
                return false;
            }
            PsiVariable variable = (PsiVariable)declaredElement;
            PsiExpression initializer = variable.getInitializer();
            return this.isArrayLookup(initializer, indexVariable, arrayVariable);
        }

        private boolean isListElementDeclaration(PsiStatement statement, PsiVariable listVariable, PsiVariable indexVariable) {
            if (!(statement instanceof PsiDeclarationStatement)) {
                return false;
            }
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)statement;
            PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
            if (declaredElements.length != 1) {
                return false;
            }
            PsiElement declaredElement = declaredElements[0];
            if (!(declaredElement instanceof PsiVariable)) {
                return false;
            }
            PsiVariable variable = (PsiVariable)declaredElement;
            PsiExpression initializer = variable.getInitializer();
            return this.isListGetLookup((PsiElement)initializer, indexVariable, listVariable);
        }

        private boolean isArrayLookup(PsiExpression expression2, PsiVariable indexVariable, PsiVariable arrayVariable) {
            if (!((expression2 = ParenthesesUtils.stripParentheses(expression2)) instanceof PsiArrayAccessExpression)) {
                return false;
            }
            PsiArrayAccessExpression arrayAccess = (PsiArrayAccessExpression)expression2;
            PsiExpression indexExpression = arrayAccess.getIndexExpression();
            if (!ExpressionUtils.isReferenceTo(indexExpression, indexVariable)) {
                return false;
            }
            PsiExpression arrayExpression = ParenthesesUtils.stripParentheses(arrayAccess.getArrayExpression());
            if (!(arrayExpression instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)arrayExpression;
            PsiExpression qualifier = ParenthesesUtils.stripParentheses(referenceExpression.getQualifierExpression());
            if (qualifier != null && !(qualifier instanceof PsiThisExpression) && !(qualifier instanceof PsiSuperExpression)) {
                return false;
            }
            PsiElement target = referenceExpression.resolve();
            return arrayVariable.equals(target);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/migration/ForCanBeForeachInspection$ForCanBeForeachFix";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "forStatement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/migration/ForCanBeForeachInspection$ForCanBeForeachFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceIndexedListLoopWithForeach";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getIndexVariable";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceCollectionLoopWithForeach";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceArrayLoopWithForeach";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class ForCanBeForeachVisitor
    extends BaseInspectionVisitor {
        private ForCanBeForeachVisitor() {
        }

        public void visitForStatement(@NotNull PsiForStatement forStatement) {
            if (forStatement == null) {
                ForCanBeForeachVisitor.$$$reportNull$$$0(0);
            }
            super.visitForStatement(forStatement);
            if (ForCanBeForeachInspection.isArrayLoopStatement(forStatement) || ForCanBeForeachInspection.isCollectionLoopStatement(forStatement, ForCanBeForeachInspection.this.ignoreUntypedCollections) || ForCanBeForeachInspection.this.REPORT_INDEXED_LOOP && ForCanBeForeachInspection.isIndexedListLoopStatement(forStatement, ForCanBeForeachInspection.this.ignoreUntypedCollections)) {
                this.registerStatementError((PsiStatement)forStatement, new Object[0]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forStatement", "com/siyeh/ig/migration/ForCanBeForeachInspection$ForCanBeForeachVisitor", "visitForStatement"));
        }
    }

    private static class Holder {
        public static final Holder DUMMY = new Holder();
        private final PsiVariable variable;

        Holder(@NotNull PsiVariable variable) {
            if (variable == null) {
                Holder.$$$reportNull$$$0(0);
            }
            this.variable = variable;
        }

        private Holder() {
            this.variable = null;
        }

        public PsiVariable getVariable() {
            return this.variable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/migration/ForCanBeForeachInspection$Holder", "<init>"));
        }
    }

    private static class VariableOnlyUsedAsListIndexVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean indexVariableUsedOnlyAsIndex;
        private boolean listGetCalled;
        private final PsiVariable indexVariable;
        private final Holder collection;

        private VariableOnlyUsedAsListIndexVisitor(@NotNull Holder collection, @NotNull PsiVariable indexVariable) {
            if (collection == null) {
                VariableOnlyUsedAsListIndexVisitor.$$$reportNull$$$0(0);
            }
            if (indexVariable == null) {
                VariableOnlyUsedAsListIndexVisitor.$$$reportNull$$$0(1);
            }
            this.indexVariableUsedOnlyAsIndex = true;
            this.collection = collection;
            this.indexVariable = indexVariable;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                VariableOnlyUsedAsListIndexVisitor.$$$reportNull$$$0(2);
            }
            if (this.indexVariableUsedOnlyAsIndex) {
                super.visitElement(element);
            }
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression reference) {
            if (reference == null) {
                VariableOnlyUsedAsListIndexVisitor.$$$reportNull$$$0(3);
            }
            if (!this.indexVariableUsedOnlyAsIndex) {
                return;
            }
            super.visitReferenceExpression(reference);
            PsiElement element = reference.resolve();
            if (this.indexVariable.equals(element)) {
                if (!this.isListIndexExpression(reference)) {
                    this.indexVariableUsedOnlyAsIndex = false;
                } else {
                    this.listGetCalled = true;
                }
            } else if (this.collection == Holder.DUMMY) {
                if (this.isListNonGetMethodCall(reference)) {
                    this.indexVariableUsedOnlyAsIndex = false;
                }
            } else if (this.collection.getVariable().equals(element) && !this.isListReferenceInIndexExpression(reference)) {
                this.indexVariableUsedOnlyAsIndex = false;
            }
        }

        private boolean isIndexVariableUsedOnlyAsIndex() {
            return this.indexVariableUsedOnlyAsIndex && this.listGetCalled;
        }

        private boolean isListNonGetMethodCall(PsiReferenceExpression reference) {
            PsiClass containingClass;
            PsiElement parent = reference.getParent();
            if (!(parent instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)parent;
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)methodCallExpression, PsiClass.class);
            if (!InheritanceUtil.isInheritorOrSelf((PsiClass)parentClass, (PsiClass)(containingClass = method.getContainingClass()), (boolean)true)) {
                return false;
            }
            return !this.isListGetExpression(methodCallExpression);
        }

        private boolean isListIndexExpression(PsiReferenceExpression reference) {
            PsiElement referenceParent = ParenthesesUtils.getParentSkipParentheses((PsiElement)reference);
            if (!(referenceParent instanceof PsiExpressionList)) {
                return false;
            }
            PsiExpressionList expressionList = (PsiExpressionList)referenceParent;
            PsiElement parent = expressionList.getParent();
            if (!(parent instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)parent;
            return this.isListGetExpression(methodCallExpression);
        }

        private boolean isListReferenceInIndexExpression(PsiReferenceExpression reference) {
            PsiElement parent = ParenthesesUtils.getParentSkipParentheses((PsiElement)reference);
            if (!(parent instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            PsiElement greatGrandParent = methodCallExpression.getParent();
            if (greatGrandParent instanceof PsiExpressionStatement) {
                return false;
            }
            return this.isListGetExpression(methodCallExpression);
        }

        private boolean isListGetExpression(PsiMethodCallExpression methodCallExpression) {
            if (methodCallExpression == null) {
                return false;
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifierExpression2 = ParenthesesUtils.stripParentheses(methodExpression.getQualifierExpression());
            if (!(qualifierExpression2 instanceof PsiReferenceExpression)) {
                if (this.collection == Holder.DUMMY && (qualifierExpression2 == null || qualifierExpression2 instanceof PsiThisExpression || qualifierExpression2 instanceof PsiSuperExpression)) {
                    return ForCanBeForeachInspection.expressionIsListGetLookup((PsiExpression)methodCallExpression);
                }
                return false;
            }
            PsiReferenceExpression reference = (PsiReferenceExpression)qualifierExpression2;
            PsiExpression qualifier = ParenthesesUtils.stripParentheses(reference.getQualifierExpression());
            if (qualifier != null && !(qualifier instanceof PsiThisExpression) && !(qualifier instanceof PsiSuperExpression)) {
                return false;
            }
            PsiElement target = reference.resolve();
            if (this.collection == Holder.DUMMY || !this.collection.getVariable().equals(target)) {
                return false;
            }
            return ForCanBeForeachInspection.expressionIsListGetLookup((PsiExpression)methodCallExpression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "collection";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indexVariable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/migration/ForCanBeForeachInspection$VariableOnlyUsedAsListIndexVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class VariableOnlyUsedAsIndexVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean indexVariableUsedOnlyAsIndex = true;
        private boolean arrayAccessed = false;
        private final PsiVariable arrayVariable;
        private final PsiVariable indexVariable;

        private VariableOnlyUsedAsIndexVisitor(PsiVariable arrayVariable, PsiVariable indexVariable) {
            this.arrayVariable = arrayVariable;
            this.indexVariable = indexVariable;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                VariableOnlyUsedAsIndexVisitor.$$$reportNull$$$0(0);
            }
            if (this.indexVariableUsedOnlyAsIndex) {
                super.visitElement(element);
            }
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression reference) {
            PsiAssignmentExpression assignment;
            PsiExpression lhs;
            if (reference == null) {
                VariableOnlyUsedAsIndexVisitor.$$$reportNull$$$0(1);
            }
            if (!this.indexVariableUsedOnlyAsIndex) {
                return;
            }
            super.visitReferenceExpression(reference);
            PsiElement element = reference.resolve();
            if (!this.indexVariable.equals(element)) {
                return;
            }
            PsiElement parent = ParenthesesUtils.getParentSkipParentheses((PsiElement)reference);
            if (!(parent instanceof PsiArrayAccessExpression)) {
                this.indexVariableUsedOnlyAsIndex = false;
                return;
            }
            PsiArrayAccessExpression arrayAccessExpression = (PsiArrayAccessExpression)parent;
            PsiExpression arrayExpression = ParenthesesUtils.stripParentheses(arrayAccessExpression.getArrayExpression());
            if (!(arrayExpression instanceof PsiReferenceExpression)) {
                this.indexVariableUsedOnlyAsIndex = false;
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)arrayExpression;
            PsiExpression qualifier = referenceExpression.getQualifierExpression();
            if (qualifier != null && !(qualifier instanceof PsiThisExpression) && !(qualifier instanceof PsiSuperExpression)) {
                this.indexVariableUsedOnlyAsIndex = false;
                return;
            }
            PsiElement target = referenceExpression.resolve();
            if (!this.arrayVariable.equals(target)) {
                this.indexVariableUsedOnlyAsIndex = false;
                return;
            }
            this.arrayAccessed = true;
            PsiElement arrayExpressionContext = ParenthesesUtils.getParentSkipParentheses((PsiElement)arrayAccessExpression);
            if (arrayExpressionContext instanceof PsiAssignmentExpression && (lhs = (assignment = (PsiAssignmentExpression)arrayExpressionContext).getLExpression()).equals(arrayAccessExpression)) {
                this.indexVariableUsedOnlyAsIndex = false;
            }
        }

        private boolean isIndexVariableUsedOnlyAsIndex() {
            return this.indexVariableUsedOnlyAsIndex && this.arrayAccessed;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/migration/ForCanBeForeachInspection$VariableOnlyUsedAsIndexVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class IteratorNextVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private int numCallsToIteratorNext = 0;
        private boolean iteratorUsed = false;
        private final PsiVariable iterator;

        private IteratorNextVisitor(PsiVariable iterator) {
            this.iterator = iterator;
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            PsiExpression qualifier;
            PsiReferenceExpression methodExpression;
            String methodName;
            if (expression2 == null) {
                IteratorNextVisitor.$$$reportNull$$$0(0);
            }
            if (this.iteratorUsed || this.numCallsToIteratorNext > 1) {
                return;
            }
            if (expression2.getArgumentList().isEmpty() && "next".equals(methodName = (methodExpression = expression2.getMethodExpression()).getReferenceName()) && ExpressionUtils.isReferenceTo(qualifier = methodExpression.getQualifierExpression(), this.iterator)) {
                ++this.numCallsToIteratorNext;
                return;
            }
            super.visitMethodCallExpression(expression2);
        }

        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            if (this.iteratorUsed || this.numCallsToIteratorNext > 1) {
                return;
            }
            super.visitReferenceExpression(expression2);
            if (ExpressionUtils.isReferenceTo((PsiExpression)expression2, this.iterator)) {
                this.iteratorUsed = true;
                this.stopWalking();
            }
        }

        boolean hasSimpleNextCall() {
            return this.numCallsToIteratorNext == 1 && !this.iteratorUsed;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/migration/ForCanBeForeachInspection$IteratorNextVisitor", "visitMethodCallExpression"));
        }
    }
}

