/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.ListTable;
import com.intellij.codeInspection.ui.ListWrappingTableModel;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.util.ui.CheckBox;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import com.siyeh.ig.psiutils.LibraryUtil;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.ui.UiUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class BooleanMethodNameMustStartWithQuestionInspection
extends BaseInspection {
    public static final String DEFAULT_QUESTION_WORDS = "add,are,can,check,contains,could,endsWith,equals,has,is,matches,must,put,remove,shall,should,startsWith,was,were,will,would";
    public boolean ignoreBooleanMethods = false;
    public boolean ignoreInAnnotationInterface = true;
    public boolean onlyWarnOnBaseMethods = true;
    @NonNls
    public String questionString = "add,are,can,check,contains,could,endsWith,equals,has,is,matches,must,put,remove,shall,should,startsWith,was,were,will,would";
    List<String> questionList = new ArrayList<String>(32);

    public BooleanMethodNameMustStartWithQuestionInspection() {
        BooleanMethodNameMustStartWithQuestionInspection.parseString(this.questionString, this.questionList);
    }

    public JComponent createOptionsPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        ListTable table = new ListTable(new ListWrappingTableModel(this.questionList, InspectionGadgetsBundle.message("boolean.method.name.must.start.with.question.table.column.name", new Object[0])));
        JPanel tablePanel = UiUtils.createAddRemovePanel(table);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        panel2.add((Component)tablePanel, constraints);
        CheckBox checkBox1 = new CheckBox(InspectionGadgetsBundle.message("ignore.methods.with.boolean.return.type.option", new Object[0]), (InspectionProfileEntry)this, "ignoreBooleanMethods");
        constraints.gridy = 1;
        constraints.weighty = 0.0;
        panel2.add((Component)checkBox1, constraints);
        CheckBox checkBox2 = new CheckBox(InspectionGadgetsBundle.message("ignore.boolean.methods.in.an.interface.option", new Object[0]), (InspectionProfileEntry)this, "ignoreInAnnotationInterface");
        constraints.gridy = 2;
        panel2.add((Component)checkBox2, constraints);
        CheckBox checkBox3 = new CheckBox(InspectionGadgetsBundle.message("ignore.methods.overriding.super.method", new Object[0]), (InspectionProfileEntry)this, "onlyWarnOnBaseMethods");
        constraints.gridy = 3;
        panel2.add((Component)checkBox3, constraints);
        return panel2;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RenameFix();
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("boolean.method.name.must.start.with.question.problem.descriptor", new Object[0]);
        if (string == null) {
            BooleanMethodNameMustStartWithQuestionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            BooleanMethodNameMustStartWithQuestionInspection.$$$reportNull$$$0(1);
        }
        super.readSettings(element);
        BooleanMethodNameMustStartWithQuestionInspection.parseString(this.questionString, this.questionList);
    }

    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            BooleanMethodNameMustStartWithQuestionInspection.$$$reportNull$$$0(2);
        }
        this.questionString = BooleanMethodNameMustStartWithQuestionInspection.formatString(this.questionList);
        super.writeSettings(element);
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BooleanMethodNameMustStartWithQuestionVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/naming/BooleanMethodNameMustStartWithQuestionInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/naming/BooleanMethodNameMustStartWithQuestionInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class BooleanMethodNameMustStartWithQuestionVisitor
    extends BaseInspectionVisitor {
        private BooleanMethodNameMustStartWithQuestionVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            PsiClass containingClass;
            PsiType returnType;
            if (method == null) {
                BooleanMethodNameMustStartWithQuestionVisitor.$$$reportNull$$$0(0);
            }
            if ((returnType = method.getReturnType()) == null) {
                return;
            }
            if (!(returnType.equals(PsiType.BOOLEAN) || !BooleanMethodNameMustStartWithQuestionInspection.this.ignoreBooleanMethods && returnType.equalsToText("java.lang.Boolean"))) {
                return;
            }
            if (BooleanMethodNameMustStartWithQuestionInspection.this.ignoreInAnnotationInterface && (containingClass = method.getContainingClass()) != null && containingClass.isAnnotationType()) {
                return;
            }
            String name2 = method.getName();
            for (String question : BooleanMethodNameMustStartWithQuestionInspection.this.questionList) {
                if (!name2.startsWith(question)) continue;
                return;
            }
            if (BooleanMethodNameMustStartWithQuestionInspection.this.onlyWarnOnBaseMethods ? MethodUtils.hasSuper(method) : LibraryUtil.isOverrideOfLibraryMethod(method)) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/naming/BooleanMethodNameMustStartWithQuestionInspection$BooleanMethodNameMustStartWithQuestionVisitor", "visitMethod"));
        }
    }
}

