/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.ConventionOptionsPanel;
import com.intellij.openapi.util.InvalidDataException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class ConventionInspection
extends BaseInspection {
    public static final JComponent[] EMPTY_JCOMPONENT_ARRAY = new JComponent[0];
    public String m_regex = this.getDefaultRegex();
    public int m_minLength = this.getDefaultMinLength();
    public int m_maxLength = this.getDefaultMaxLength();
    protected Pattern m_regexPattern = Pattern.compile(this.m_regex);

    @Override
    @NotNull
    protected final String buildErrorString(Object ... infos) {
        String name2 = (String)infos[0];
        int length = name2.length();
        if (length < this.getMinLength()) {
            String string = InspectionGadgetsBundle.message("naming.convention.problem.descriptor.short", this.getElementDescription(), length, this.getMinLength());
            if (string == null) {
                ConventionInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        if (this.getMaxLength() > 0 && length > this.getMaxLength()) {
            String string = InspectionGadgetsBundle.message("naming.convention.problem.descriptor.long", this.getElementDescription(), length, this.getMaxLength());
            if (string == null) {
                ConventionInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("naming.convention.problem.descriptor.regex.mismatch", this.getElementDescription(), this.getRegex());
        if (string == null) {
            ConventionInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    protected abstract String getElementDescription();

    @NonNls
    protected abstract String getDefaultRegex();

    protected abstract int getDefaultMinLength();

    protected abstract int getDefaultMaxLength();

    protected String getRegex() {
        return this.m_regex;
    }

    protected int getMinLength() {
        return this.m_minLength;
    }

    protected int getMaxLength() {
        return this.m_maxLength;
    }

    protected boolean isValid(String name2) {
        int length = name2.length();
        if (length < this.m_minLength) {
            return false;
        }
        if (this.m_maxLength > 0 && length > this.m_maxLength) {
            return false;
        }
        if ("serialVersionUID".equals(name2)) {
            return true;
        }
        Matcher matcher = this.m_regexPattern.matcher(name2);
        return matcher.matches();
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            ConventionInspection.$$$reportNull$$$0(3);
        }
        super.readSettings(element);
        this.m_regexPattern = Pattern.compile(this.m_regex);
    }

    public JComponent @NotNull [] createExtraOptions() {
        if (EMPTY_JCOMPONENT_ARRAY == null) {
            ConventionInspection.$$$reportNull$$$0(4);
        }
        return EMPTY_JCOMPONENT_ARRAY;
    }

    public final JComponent createOptionsPanel() {
        return new ConventionOptionsPanel((InspectionProfileEntry)this, "m_minLength", "m_maxLength", "m_regex", "m_regexPattern", this.createExtraOptions());
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RenameFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/naming/ConventionInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/naming/ConventionInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createExtraOptions";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

