/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.naming.ConventionInspection;
import org.jetbrains.annotations.NotNull;

public class ParameterNamingConventionInspection
extends ConventionInspection {
    private static final int DEFAULT_MIN_LENGTH = 1;
    private static final int DEFAULT_MAX_LENGTH = 20;

    @NotNull
    public String getID() {
        return "MethodParameterNamingConvention";
    }

    @Override
    protected String getElementDescription() {
        return InspectionGadgetsBundle.message("parameter.naming.convention.element.description", new Object[0]);
    }

    @Override
    protected String getDefaultRegex() {
        return "[a-z][A-Za-z\\d]*";
    }

    @Override
    protected int getDefaultMinLength() {
        return 1;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 20;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NamingConventionsVisitor();
    }

    private class NamingConventionsVisitor
    extends BaseInspectionVisitor {
        private NamingConventionsVisitor() {
        }

        public void visitParameter(@NotNull PsiParameter variable) {
            PsiElement scope;
            if (variable == null) {
                NamingConventionsVisitor.$$$reportNull$$$0(0);
            }
            if ((scope = variable.getDeclarationScope()) instanceof PsiCatchSection || scope instanceof PsiForeachStatement || scope instanceof PsiLambdaExpression) {
                return;
            }
            String name2 = variable.getName();
            if (ParameterNamingConventionInspection.this.isValid(name2)) {
                return;
            }
            this.registerVariableError((PsiVariable)variable, name2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/naming/ParameterNamingConventionInspection$NamingConventionsVisitor", "visitParameter"));
        }
    }
}

