/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.InlineGetterSetterCallFix;
import com.siyeh.ig.psiutils.ClassUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CallToSimpleSetterInClassInspection
extends BaseInspection {
    public boolean ignoreSetterCallsOnOtherObjects = false;
    public boolean onlyReportPrivateSetter = false;

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("call.to.simple.setter.in.class.ignore.option", new Object[0]), "ignoreSetterCallsOnOtherObjects");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("call.to.private.setter.in.class.option", new Object[0]), "onlyReportPrivateSetter");
        return optionsPanel;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new InlineGetterSetterCallFix(false);
    }

    @NotNull
    public String getID() {
        return "CallToSimpleSetterFromWithinClass";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("call.to.simple.setter.in.class.problem.descriptor", new Object[0]);
        if (string == null) {
            CallToSimpleSetterInClassInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CallToSimpleSetterInClassVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/CallToSimpleSetterInClassInspection", "buildErrorString"));
    }

    private class CallToSimpleSetterInClassVisitor
    extends BaseInspectionVisitor {
        private CallToSimpleSetterInClassVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            if (call == null) {
                CallToSimpleSetterInClassVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(call);
            PsiClass containingClass = ClassUtils.getContainingClass((PsiElement)call);
            if (containingClass == null) {
                return;
            }
            PsiMethod method = call.resolveMethod();
            if (method == null) {
                return;
            }
            if (!containingClass.equals(method.getContainingClass())) {
                return;
            }
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier != null && !(qualifier instanceof PsiThisExpression)) {
                if (CallToSimpleSetterInClassInspection.this.ignoreSetterCallsOnOtherObjects) {
                    return;
                }
                PsiClass qualifierClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)qualifier.getType());
                if (!containingClass.equals(qualifierClass)) {
                    return;
                }
            }
            if (!PropertyUtil.isSimpleSetter(method)) {
                return;
            }
            if (CallToSimpleSetterInClassInspection.this.onlyReportPrivateSetter && !method.hasModifierProperty("private")) {
                return;
            }
            Query query = OverridingMethodsSearch.search((PsiMethod)method);
            PsiMethod overridingMethod = (PsiMethod)query.findFirst();
            if (overridingMethod != null) {
                return;
            }
            this.registerMethodCallError(call, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/siyeh/ig/performance/CallToSimpleSetterInClassInspection$CallToSimpleSetterInClassVisitor", "visitMethodCallExpression"));
        }
    }
}

