/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.redundancy;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.tree.java.PsiLiteralExpressionImpl;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryStringEscapeInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean reportChars = false;

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.string.escape.problem.descriptor", new Object[0]);
        if (string == null) {
            UnnecessaryStringEscapeInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("inspection.unnecessary.string.escape.report.char.literals.option", new Object[0]), (InspectionProfileEntry)this, "reportChars");
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryStringEscapeFix();
    }

    static int findUnnecessarilyEscapedChars(String text2, int start) {
        boolean slash = false;
        int doubleQuotes = 0;
        int max = text2.length() - 3;
        for (int i = start; i < max; ++i) {
            char ch = text2.charAt(i);
            if (ch == '\\') {
                slash = !slash;
                continue;
            }
            if (slash) {
                if (ch == 'n' || ch == '\'') {
                    return i - 1;
                }
                if (ch == '\"' && doubleQuotes < 2) {
                    if (i == max - 1) {
                        return -1;
                    }
                    if (i == max - 2) {
                        return i - 1;
                    }
                    if (i < max - 2 && text2.charAt(i + 1) == '\"') {
                        if (doubleQuotes != 1 && text2.charAt(i + 2) != '\"') {
                            return i - 1;
                        }
                    } else {
                        return i - 1;
                    }
                }
                doubleQuotes = 0;
            } else {
                doubleQuotes = ch == '\"' ? ++doubleQuotes : 0;
            }
            slash = false;
        }
        return -1;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new RedundantStringEscapeVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/redundancy/UnnecessaryStringEscapeInspection", "buildErrorString"));
    }

    private class RedundantStringEscapeVisitor
    extends BaseInspectionVisitor {
        private RedundantStringEscapeVisitor() {
        }

        public void visitLiteralExpression(PsiLiteralExpression expression2) {
            super.visitLiteralExpression(expression2);
            PsiType type2 = expression2.getType();
            if (type2 == null) {
                return;
            }
            if (type2.equalsToText("java.lang.String")) {
                if (((PsiLiteralExpressionImpl)expression2).getLiteralElementType() == JavaTokenType.TEXT_BLOCK_LITERAL) {
                    String text2 = expression2.getText();
                    int start = UnnecessaryStringEscapeInspection.findUnnecessarilyEscapedChars(text2, 4);
                    while (start >= 0) {
                        this.registerErrorAtOffset((PsiElement)expression2, start, 2, new Object[0]);
                        start = UnnecessaryStringEscapeInspection.findUnnecessarilyEscapedChars(text2, start + 2);
                    }
                } else {
                    String text3 = expression2.getText();
                    boolean slash = false;
                    int max = text3.length() - 1;
                    for (int i = 1; i < max; ++i) {
                        char c = text3.charAt(i);
                        if (slash) {
                            slash = false;
                            if (c != '\'') continue;
                            this.registerErrorAtOffset((PsiElement)expression2, i - 1, 2, new Object[0]);
                            continue;
                        }
                        if (c != '\\') continue;
                        slash = true;
                    }
                }
            } else if (UnnecessaryStringEscapeInspection.this.reportChars && PsiType.CHAR.equals((Object)type2) && "'\\\"'".equals(expression2.getText())) {
                this.registerErrorAtOffset((PsiElement)expression2, 1, 2, new Object[0]);
            }
        }
    }

    private static class UnnecessaryStringEscapeFix
    extends InspectionGadgetsFix {
        private UnnecessaryStringEscapeFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unnecessary.string.escape.quickfix", new Object[0]);
            if (string == null) {
                UnnecessaryStringEscapeFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiLiteralExpression)) {
                return;
            }
            PsiLiteralExpression literalExpression = (PsiLiteralExpression)element;
            PsiType type2 = literalExpression.getType();
            if (type2 == null) {
                return;
            }
            String text2 = literalExpression.getText();
            if (type2.equalsToText("java.lang.String")) {
                StringBuilder newExpression = new StringBuilder();
                PsiLiteralExpressionImpl literal = (PsiLiteralExpressionImpl)literalExpression;
                if (literal.getLiteralElementType() == JavaTokenType.TEXT_BLOCK_LITERAL) {
                    int offset = 0;
                    int start = UnnecessaryStringEscapeInspection.findUnnecessarilyEscapedChars(text2, 4);
                    while (start >= 0) {
                        newExpression.append(text2, offset, start);
                        offset = start + 2;
                        String escape = text2.substring(start, offset);
                        if ("\\n".equals(escape)) {
                            int indent = literal.getTextBlockIndent();
                            newExpression.append('\n').append(StringUtil.repeatSymbol((char)' ', (int)indent));
                        } else {
                            newExpression.append(escape.charAt(1));
                        }
                        start = UnnecessaryStringEscapeInspection.findUnnecessarilyEscapedChars(text2, offset);
                    }
                    newExpression.append(text2.substring(offset));
                } else {
                    int index = text2.indexOf("\\'");
                    int offset = 0;
                    while (index > 0) {
                        newExpression.append(text2, offset, index);
                        offset = index + 1;
                        index = text2.indexOf("\\'", offset);
                    }
                    newExpression.append(text2.substring(offset));
                }
                PsiReplacementUtil.replaceExpression((PsiExpression)literalExpression, newExpression.toString());
            } else if (PsiType.CHAR.equals((Object)type2) && text2.equals("'\\\"'")) {
                PsiReplacementUtil.replaceExpression((PsiExpression)literalExpression, "'\"'");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/redundancy/UnnecessaryStringEscapeInspection$UnnecessaryStringEscapeFix", "getFamilyName"));
        }
    }
}

