/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiYieldStatement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.style.ConditionalModel;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IfConditionalModel
extends ConditionalModel {
    @NotNull
    private final PsiStatement myThenBranch;
    @NotNull
    private final PsiStatement myElseBranch;

    private IfConditionalModel(@NotNull PsiExpression condition2, @NotNull PsiExpression thenExpression2, @NotNull PsiExpression elseExpression2, @NotNull PsiStatement thenBranch, @NotNull PsiStatement elseBranch, @NotNull PsiType type2) {
        if (condition2 == null) {
            IfConditionalModel.$$$reportNull$$$0(0);
        }
        if (thenExpression2 == null) {
            IfConditionalModel.$$$reportNull$$$0(1);
        }
        if (elseExpression2 == null) {
            IfConditionalModel.$$$reportNull$$$0(2);
        }
        if (thenBranch == null) {
            IfConditionalModel.$$$reportNull$$$0(3);
        }
        if (elseBranch == null) {
            IfConditionalModel.$$$reportNull$$$0(4);
        }
        if (type2 == null) {
            IfConditionalModel.$$$reportNull$$$0(5);
        }
        super(condition2, thenExpression2, elseExpression2, type2);
        this.myThenBranch = thenBranch;
        this.myElseBranch = elseBranch;
    }

    @NotNull
    public PsiStatement getThenBranch() {
        PsiStatement psiStatement = this.myThenBranch;
        if (psiStatement == null) {
            IfConditionalModel.$$$reportNull$$$0(6);
        }
        return psiStatement;
    }

    @NotNull
    public PsiStatement getElseBranch() {
        PsiStatement psiStatement = this.myElseBranch;
        if (psiStatement == null) {
            IfConditionalModel.$$$reportNull$$$0(7);
        }
        return psiStatement;
    }

    @Nullable
    public static IfConditionalModel from(@NotNull PsiIfStatement ifStatement, boolean allowOuterControlFlow) {
        IfConditionalModel model;
        if (ifStatement == null) {
            IfConditionalModel.$$$reportNull$$$0(8);
        }
        if ((model = IfConditionalModel.extractFromAssignment(ifStatement)) != null) {
            return model;
        }
        model = IfConditionalModel.extractFromImplicitAssignment(ifStatement);
        if (model != null) {
            return model;
        }
        model = IfConditionalModel.extractFromImplicitReturn(ifStatement, allowOuterControlFlow);
        if (model != null) {
            return model;
        }
        model = IfConditionalModel.extractFromReturn(ifStatement);
        if (model != null) {
            return model;
        }
        model = IfConditionalModel.extractFromYield(ifStatement);
        if (model != null) {
            return model;
        }
        model = IfConditionalModel.extractFromImplicitYield(ifStatement);
        if (model != null) {
            return model;
        }
        return IfConditionalModel.extractFromMethodCall(ifStatement);
    }

    @Nullable
    private static IfConditionalModel extractFromImplicitAssignment(@NotNull PsiIfStatement ifStatement) {
        if (ifStatement == null) {
            IfConditionalModel.$$$reportNull$$$0(9);
        }
        if (ifStatement.getElseBranch() != null) {
            return null;
        }
        PsiStatement prevStatement = (PsiStatement)ObjectUtils.tryCast((Object)PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)ifStatement), PsiStatement.class);
        return IfConditionalModel.extractFromAssignment(ifStatement.getCondition(), ifStatement.getThenBranch(), prevStatement, false);
    }

    @Nullable
    private static IfConditionalModel extractFromAssignment(@NotNull PsiIfStatement ifStatement) {
        if (ifStatement == null) {
            IfConditionalModel.$$$reportNull$$$0(10);
        }
        return IfConditionalModel.extractFromAssignment(ifStatement.getCondition(), ifStatement.getThenBranch(), ifStatement.getElseBranch(), true);
    }

    @Nullable
    private static IfConditionalModel extractFromAssignment(@Nullable PsiExpression condition2, @Nullable PsiStatement thenStatement, @Nullable PsiStatement elseStatement, boolean explicit) {
        if ((condition2 = ParenthesesUtils.stripParentheses(condition2)) == null) {
            return null;
        }
        PsiExpressionStatement thenBranch = (PsiExpressionStatement)ObjectUtils.tryCast((Object)ControlFlowUtils.stripBraces(thenStatement), PsiExpressionStatement.class);
        PsiExpressionStatement elseBranch = (PsiExpressionStatement)ObjectUtils.tryCast((Object)ControlFlowUtils.stripBraces(elseStatement), PsiExpressionStatement.class);
        if (thenBranch == null || elseBranch == null) {
            return null;
        }
        PsiAssignmentExpression thenExpression2 = (PsiAssignmentExpression)ObjectUtils.tryCast((Object)thenBranch.getExpression(), PsiAssignmentExpression.class);
        PsiAssignmentExpression elseExpression2 = (PsiAssignmentExpression)ObjectUtils.tryCast((Object)elseBranch.getExpression(), PsiAssignmentExpression.class);
        if (thenExpression2 == null || elseExpression2 == null) {
            return null;
        }
        PsiExpression thenRhs = thenExpression2.getRExpression();
        PsiExpression elseRhs = elseExpression2.getRExpression();
        if (thenRhs == null || elseRhs == null) {
            return null;
        }
        IElementType thenTokenType = thenExpression2.getOperationTokenType();
        IElementType elseTokenType = elseExpression2.getOperationTokenType();
        if (!explicit && !thenTokenType.equals(JavaTokenType.EQ)) {
            return null;
        }
        boolean operationIsOpposite = IfConditionalModel.areOppositeAssignmentTokens(thenTokenType, elseTokenType);
        if (!operationIsOpposite && EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(thenRhs, elseRhs)) {
            return null;
        }
        if (!thenTokenType.equals(elseTokenType) && !operationIsOpposite) {
            return null;
        }
        PsiExpression thenLhs = thenExpression2.getLExpression();
        PsiExpression elseLhs = elseExpression2.getLExpression();
        if (!EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(thenLhs, elseLhs)) {
            return null;
        }
        PsiType type2 = thenLhs.getType();
        if (type2 == null) {
            return null;
        }
        PsiExpression resultElseRhs = IfConditionalModel.getResultElseRhs(elseRhs, operationIsOpposite);
        if (!explicit && !ExpressionUtils.isSafelyRecomputableExpression(elseRhs)) {
            return null;
        }
        return new IfConditionalModel(condition2, thenRhs, resultElseRhs, (PsiStatement)thenBranch, (PsiStatement)elseBranch, type2);
    }

    private static PsiExpression getResultElseRhs(@NotNull PsiExpression elseRhs, boolean operationIsOpposite) {
        PsiExpression operand2;
        if (elseRhs == null) {
            IfConditionalModel.$$$reportNull$$$0(11);
        }
        if (!operationIsOpposite) {
            return elseRhs;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)elseRhs.getProject());
        if (elseRhs instanceof PsiPrefixExpression && ((PsiPrefixExpression)elseRhs).getOperationTokenType().equals(JavaTokenType.MINUS) && (operand2 = ((PsiPrefixExpression)elseRhs).getOperand()) != null) {
            return operand2;
        }
        String elseRhsText = "-" + ParenthesesUtils.getText(elseRhs, 6);
        return factory.createExpressionFromText(elseRhsText, (PsiElement)elseRhs);
    }

    static boolean areOppositeAssignmentTokens(IElementType thenTokenType, IElementType elseTokenType) {
        return thenTokenType.equals(JavaTokenType.PLUSEQ) && elseTokenType.equals(JavaTokenType.MINUSEQ) || thenTokenType.equals(JavaTokenType.MINUSEQ) && elseTokenType.equals(JavaTokenType.PLUSEQ);
    }

    @Nullable
    private static IfConditionalModel extractFromReturn(@NotNull PsiIfStatement ifStatement) {
        PsiExpression condition2;
        if (ifStatement == null) {
            IfConditionalModel.$$$reportNull$$$0(12);
        }
        if ((condition2 = ParenthesesUtils.stripParentheses(ifStatement.getCondition())) == null) {
            return null;
        }
        PsiReturnStatement thenBranch = (PsiReturnStatement)ObjectUtils.tryCast((Object)ControlFlowUtils.stripBraces(ifStatement.getThenBranch()), PsiReturnStatement.class);
        PsiReturnStatement elseBranch = (PsiReturnStatement)ObjectUtils.tryCast((Object)ControlFlowUtils.stripBraces(ifStatement.getElseBranch()), PsiReturnStatement.class);
        return IfConditionalModel.extractFromReturn(condition2, thenBranch, elseBranch);
    }

    @Nullable
    private static IfConditionalModel extractFromImplicitReturn(@NotNull PsiIfStatement ifStatement, boolean allowReturnInOuterBranch) {
        PsiReturnStatement nextReturnStatement;
        PsiExpression condition2;
        if (ifStatement == null) {
            IfConditionalModel.$$$reportNull$$$0(13);
        }
        if ((condition2 = ParenthesesUtils.stripParentheses(ifStatement.getCondition())) == null) {
            return null;
        }
        if (ifStatement.getElseBranch() != null) {
            return null;
        }
        PsiReturnStatement thenBranch = (PsiReturnStatement)ObjectUtils.tryCast((Object)ControlFlowUtils.stripBraces(ifStatement.getThenBranch()), PsiReturnStatement.class);
        PsiReturnStatement psiReturnStatement = nextReturnStatement = allowReturnInOuterBranch ? ControlFlowUtils.getNextReturnStatement((PsiStatement)ifStatement) : (PsiReturnStatement)ObjectUtils.tryCast((Object)PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)ifStatement), PsiReturnStatement.class);
        if (nextReturnStatement == null) {
            return null;
        }
        return IfConditionalModel.extractFromReturn(condition2, thenBranch, nextReturnStatement);
    }

    @Nullable
    private static IfConditionalModel extractFromImplicitYield(@NotNull PsiIfStatement ifStatement) {
        PsiExpression condition2;
        if (ifStatement == null) {
            IfConditionalModel.$$$reportNull$$$0(14);
        }
        if ((condition2 = ParenthesesUtils.stripParentheses(ifStatement.getCondition())) == null) {
            return null;
        }
        if (ifStatement.getElseBranch() != null) {
            return null;
        }
        PsiYieldStatement thenBranch = (PsiYieldStatement)ObjectUtils.tryCast((Object)ControlFlowUtils.stripBraces(ifStatement.getThenBranch()), PsiYieldStatement.class);
        PsiYieldStatement nextReturnStatement = (PsiYieldStatement)ObjectUtils.tryCast((Object)PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)ifStatement), PsiYieldStatement.class);
        return IfConditionalModel.extractFromYield(condition2, thenBranch, nextReturnStatement);
    }

    @Nullable
    private static IfConditionalModel extractFromYield(@NotNull PsiIfStatement ifStatement) {
        PsiExpression condition2;
        if (ifStatement == null) {
            IfConditionalModel.$$$reportNull$$$0(15);
        }
        if ((condition2 = ParenthesesUtils.stripParentheses(ifStatement.getCondition())) == null) {
            return null;
        }
        PsiYieldStatement thenBranch = (PsiYieldStatement)ObjectUtils.tryCast((Object)ControlFlowUtils.stripBraces(ifStatement.getThenBranch()), PsiYieldStatement.class);
        PsiYieldStatement elseBranch = (PsiYieldStatement)ObjectUtils.tryCast((Object)ControlFlowUtils.stripBraces(ifStatement.getElseBranch()), PsiYieldStatement.class);
        return IfConditionalModel.extractFromYield(condition2, thenBranch, elseBranch);
    }

    @Contract(value="_, null, _ -> null; _, !null, null -> null")
    private static IfConditionalModel extractFromYield(PsiExpression condition2, PsiYieldStatement thenBranch, PsiYieldStatement elseBranch) {
        if (thenBranch == null || elseBranch == null) {
            return null;
        }
        PsiExpression thenBreak = thenBranch.getExpression();
        if (thenBreak == null) {
            return null;
        }
        PsiExpression elseBreak = elseBranch.getExpression();
        if (elseBreak == null) {
            return null;
        }
        PsiType type2 = IfConditionalModel.getType(condition2, thenBreak, elseBreak);
        if (type2 == null) {
            return null;
        }
        return new IfConditionalModel(condition2, thenBreak, elseBreak, (PsiStatement)thenBranch, (PsiStatement)elseBranch, type2);
    }

    @Contract(value="_, null, _ -> null; _, !null, null -> null")
    @Nullable
    private static IfConditionalModel extractFromReturn(PsiExpression condition2, PsiReturnStatement thenBranch, PsiReturnStatement elseBranch) {
        if (thenBranch == null || elseBranch == null) {
            return null;
        }
        PsiExpression thenReturn = thenBranch.getReturnValue();
        if (thenReturn == null) {
            return null;
        }
        PsiExpression elseReturn = elseBranch.getReturnValue();
        if (elseReturn == null) {
            return null;
        }
        PsiType type2 = IfConditionalModel.getType(condition2, thenReturn, elseReturn);
        if (type2 == null) {
            return null;
        }
        return new IfConditionalModel(condition2, thenReturn, elseReturn, (PsiStatement)thenBranch, (PsiStatement)elseBranch, type2);
    }

    @Nullable
    private static IfConditionalModel extractFromMethodCall(@NotNull PsiIfStatement ifStatement) {
        PsiExpression[] elseArguments;
        PsiExpression condition2;
        if (ifStatement == null) {
            IfConditionalModel.$$$reportNull$$$0(16);
        }
        if ((condition2 = ParenthesesUtils.stripParentheses(ifStatement.getCondition())) == null) {
            return null;
        }
        PsiExpressionStatement thenBranch = (PsiExpressionStatement)ObjectUtils.tryCast((Object)ControlFlowUtils.stripBraces(ifStatement.getThenBranch()), PsiExpressionStatement.class);
        PsiExpressionStatement elseBranch = (PsiExpressionStatement)ObjectUtils.tryCast((Object)ControlFlowUtils.stripBraces(ifStatement.getElseBranch()), PsiExpressionStatement.class);
        if (thenBranch == null || elseBranch == null) {
            return null;
        }
        PsiMethodCallExpression thenCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)thenBranch.getExpression(), PsiMethodCallExpression.class);
        PsiMethodCallExpression elseCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)elseBranch.getExpression(), PsiMethodCallExpression.class);
        if (thenCall == null || elseCall == null) {
            return null;
        }
        PsiReferenceExpression thenMethodExpression = thenCall.getMethodExpression();
        PsiReferenceExpression elseMethodExpression = elseCall.getMethodExpression();
        if (!EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent((PsiExpression)thenMethodExpression, (PsiExpression)elseMethodExpression)) {
            return null;
        }
        PsiMethod thenMethod = thenCall.resolveMethod();
        PsiMethod elseMethod = elseCall.resolveMethod();
        if (thenMethod == null || !thenMethod.equals(elseMethod)) {
            return null;
        }
        PsiExpression[] thenArguments = thenCall.getArgumentList().getExpressions();
        if (thenArguments.length != (elseArguments = elseCall.getArgumentList().getExpressions()).length) {
            return null;
        }
        PsiParameter[] parameterList = thenMethod.getParameterList().getParameters();
        if (parameterList.length > thenArguments.length) {
            return null;
        }
        boolean vararg = MethodCallUtils.isVarArgCall((PsiCall)thenCall);
        if (vararg != MethodCallUtils.isVarArgCall((PsiCall)elseCall)) {
            return null;
        }
        if (!vararg && parameterList.length != thenArguments.length) {
            return null;
        }
        IfConditionalModel model = null;
        for (int i = 0; i < thenArguments.length; ++i) {
            PsiExpression thenArgument = thenArguments[i];
            PsiExpression elseArgument = elseArguments[i];
            if (EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(thenArgument, elseArgument)) continue;
            if (model != null) {
                return null;
            }
            int lastParameter = parameterList.length - 1;
            PsiType type2 = vararg && i >= lastParameter ? ((PsiEllipsisType)parameterList[lastParameter].getType()).getComponentType() : parameterList[i].getType();
            model = new IfConditionalModel(condition2, thenArgument, elseArgument, (PsiStatement)thenBranch, (PsiStatement)elseBranch, type2);
        }
        return model;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thenExpression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elseExpression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thenBranch";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elseBranch";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/style/IfConditionalModel";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifStatement";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elseRhs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/style/IfConditionalModel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getThenBranch";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getElseBranch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "from";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "extractFromImplicitAssignment";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "extractFromAssignment";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getResultElseRhs";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "extractFromReturn";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "extractFromImplicitReturn";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "extractFromImplicitYield";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "extractFromYield";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "extractFromMethodCall";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

