/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListIndexOfReplaceableByContainsInspection
extends BaseInspection {
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String text2;
        PsiBinaryExpression expression2 = (PsiBinaryExpression)infos[0];
        PsiExpression lhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2.getLOperand());
        CommentTracker tracker = new CommentTracker();
        if (lhs instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)lhs;
            text2 = ListIndexOfReplaceableByContainsInspection.createContainsExpressionText(callExpression, false, expression2.getOperationTokenType(), tracker);
        } else {
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2.getROperand());
            assert (callExpression != null);
            text2 = ListIndexOfReplaceableByContainsInspection.createContainsExpressionText(callExpression, true, expression2.getOperationTokenType(), tracker);
        }
        String string = InspectionGadgetsBundle.message("expression.can.be.replaced.problem.descriptor", text2);
        if (string == null) {
            ListIndexOfReplaceableByContainsInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new IndexOfReplaceableByContainsFix();
    }

    static String createContainsExpressionText(@NotNull PsiMethodCallExpression call, boolean flipped, IElementType tokenType, CommentTracker tracker) {
        PsiReferenceExpression methodExpression;
        PsiExpression qualifierExpression2;
        if (call == null) {
            ListIndexOfReplaceableByContainsInspection.$$$reportNull$$$0(1);
        }
        String qualifierText = (qualifierExpression2 = (methodExpression = call.getMethodExpression()).getQualifierExpression()) == null ? "" : tracker.text((PsiElement)qualifierExpression2);
        PsiExpressionList argumentList = call.getArgumentList();
        PsiExpression expression2 = argumentList.getExpressions()[0];
        String newExpressionText = qualifierText + ".contains(" + tracker.text((PsiElement)expression2) + ')';
        if (tokenType.equals(JavaTokenType.EQEQ)) {
            return '!' + newExpressionText;
        }
        if (!flipped && (tokenType.equals(JavaTokenType.LT) || tokenType.equals(JavaTokenType.LE))) {
            return '!' + newExpressionText;
        }
        if (flipped && (tokenType.equals(JavaTokenType.GT) || tokenType.equals(JavaTokenType.GE))) {
            return '!' + newExpressionText;
        }
        return newExpressionText;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new IndexOfReplaceableByContainsVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/style/ListIndexOfReplaceableByContainsInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/style/ListIndexOfReplaceableByContainsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createContainsExpressionText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class IndexOfReplaceableByContainsVisitor
    extends BaseInspectionVisitor {
        private IndexOfReplaceableByContainsVisitor() {
        }

        public void visitBinaryExpression(PsiBinaryExpression expression2) {
            super.visitBinaryExpression(expression2);
            PsiExpression rhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2.getROperand());
            PsiExpression lhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2.getLOperand());
            if (rhs == null || lhs == null) {
                return;
            }
            if (!ComparisonUtils.isComparison((PsiExpression)expression2)) {
                return;
            }
            if (lhs instanceof PsiMethodCallExpression) {
                if (IndexOfReplaceableByContainsVisitor.canBeReplacedByContains(lhs, rhs, false, expression2.getOperationTokenType())) {
                    this.registerError((PsiElement)expression2, expression2);
                }
            } else if (rhs instanceof PsiMethodCallExpression && IndexOfReplaceableByContainsVisitor.canBeReplacedByContains(rhs, lhs, true, expression2.getOperationTokenType())) {
                this.registerError((PsiElement)expression2, expression2);
            }
        }

        private static boolean canBeReplacedByContains(PsiExpression lhs, PsiExpression rhs, boolean flipped, IElementType tokenType) {
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)lhs;
            if (!IndexOfReplaceableByContainsVisitor.isIndexOfCall(callExpression)) {
                return false;
            }
            Object object = ExpressionUtils.computeConstantExpression(rhs);
            if (!(object instanceof Integer)) {
                return false;
            }
            Integer integer = (Integer)object;
            int constant = integer;
            if (flipped) {
                if (constant == -1 && (JavaTokenType.NE.equals(tokenType) || JavaTokenType.LT.equals(tokenType) || JavaTokenType.EQEQ.equals(tokenType) || JavaTokenType.GE.equals(tokenType))) {
                    return true;
                }
                if (constant == 0 && (JavaTokenType.LE.equals(tokenType) || JavaTokenType.GT.equals(tokenType))) {
                    return true;
                }
            } else {
                if (constant == -1 && (JavaTokenType.NE.equals(tokenType) || JavaTokenType.GT.equals(tokenType) || JavaTokenType.EQEQ.equals(tokenType) || JavaTokenType.LE.equals(tokenType))) {
                    return true;
                }
                if (constant == 0 && (JavaTokenType.GE.equals(tokenType) || JavaTokenType.LT.equals(tokenType))) {
                    return true;
                }
            }
            return false;
        }

        private static boolean isIndexOfCall(@NotNull PsiMethodCallExpression expression2) {
            PsiReferenceExpression methodExpression;
            String methodName;
            if (expression2 == null) {
                IndexOfReplaceableByContainsVisitor.$$$reportNull$$$0(0);
            }
            if (!"indexOf".equals(methodName = (methodExpression = expression2.getMethodExpression()).getReferenceName())) {
                return false;
            }
            PsiExpressionList argumentList = expression2.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return false;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return false;
            }
            PsiType qualifierType = qualifier.getType();
            if (qualifierType == null) {
                return false;
            }
            Project project = expression2.getProject();
            GlobalSearchScope projectScope = GlobalSearchScope.allScope((Project)project);
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
            PsiClass javaUtilListClass = psiFacade.findClass("java.util.List", projectScope);
            if (javaUtilListClass == null) {
                return false;
            }
            PsiElementFactory factory = psiFacade.getElementFactory();
            PsiClassType javaUtilListType = factory.createType(javaUtilListClass);
            return javaUtilListType.isAssignableFrom(qualifierType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/style/ListIndexOfReplaceableByContainsInspection$IndexOfReplaceableByContainsVisitor", "isIndexOfCall"));
        }
    }

    private static class IndexOfReplaceableByContainsFix
    extends InspectionGadgetsFix {
        private IndexOfReplaceableByContainsFix() {
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            String newExpressionText;
            PsiBinaryExpression expression2 = (PsiBinaryExpression)descriptor.getPsiElement();
            PsiExpression lhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2.getLOperand());
            PsiExpression rhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2.getROperand());
            CommentTracker tracker = new CommentTracker();
            if (lhs instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression callExpression = (PsiMethodCallExpression)lhs;
                newExpressionText = ListIndexOfReplaceableByContainsInspection.createContainsExpressionText(callExpression, false, expression2.getOperationTokenType(), tracker);
            } else {
                PsiMethodCallExpression callExpression = (PsiMethodCallExpression)rhs;
                assert (callExpression != null);
                newExpressionText = ListIndexOfReplaceableByContainsInspection.createContainsExpressionText(callExpression, true, expression2.getOperationTokenType(), tracker);
            }
            PsiReplacementUtil.replaceExpression((PsiExpression)expression2, newExpressionText, tracker);
        }

        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.x.with.y", (Object[])new Object[]{"indexOf()", "contains()"});
            if (string == null) {
                IndexOfReplaceableByContainsFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/ListIndexOfReplaceableByContainsInspection$IndexOfReplaceableByContainsFix", "getFamilyName"));
        }
    }
}

