/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.testFrameworks;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.EqualityCheck;
import com.siyeh.ig.psiutils.ImportUtils;
import com.siyeh.ig.testFrameworks.AssertHint;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class SimplifiableAssertionInspection
extends BaseInspection {
    static final CallMatcher ARRAYS_EQUALS = CallMatcher.staticCall("java.util.Arrays", "equals").parameterCount(2);

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("simplifiable.junit.assertion.problem.descriptor", infos[0]);
        if (string == null) {
            SimplifiableAssertionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new SimplifyAssertFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SimplifiableJUnitAssertionVisitor();
    }

    protected abstract boolean checkTestNG();

    static boolean isAssertThatCouldBeFail(PsiExpression position, boolean checkTrue) {
        return (checkTrue ? "true" : "false").equals(position.getText());
    }

    boolean isAssertEqualsThatCouldBeAssertLiteral(AssertHint assertHint) {
        PsiExpression secondTestArgument;
        PsiExpression firstTestArgument = assertHint.getFirstArgument();
        return SimplifiableAssertionInspection.isSimpleLiteral(firstTestArgument, secondTestArgument = assertHint.getSecondArgument()) || SimplifiableAssertionInspection.isSimpleLiteral(secondTestArgument, firstTestArgument);
    }

    static boolean isSimpleLiteral(PsiExpression expression1, PsiExpression expression2) {
        if (!(expression1 instanceof PsiLiteralExpression) || expression2 == null) {
            return false;
        }
        String text2 = expression1.getText();
        if ("null".equals(text2)) {
            return true;
        }
        if (!"true".equals(text2) && !"false".equals(text2)) {
            return false;
        }
        PsiType type2 = expression2.getType();
        return PsiType.BOOLEAN.equals((Object)type2);
    }

    static boolean isEqualityComparison(PsiExpression expression2) {
        if (expression2 instanceof PsiBinaryExpression) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression2;
            IElementType tokenType = binaryExpression.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.EQEQ)) {
                return false;
            }
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            if (rhs == null) {
                return false;
            }
            PsiType type2 = lhs.getType();
            return type2 != null && TypeConversionUtil.isPrimitiveAndNotNullOrWrapper((PsiType)type2);
        }
        return EqualityCheck.from(expression2) != null;
    }

    static boolean isArrayEqualityComparison(PsiExpression expression2) {
        return expression2 instanceof PsiMethodCallExpression && ARRAYS_EQUALS.test((PsiMethodCallExpression)expression2);
    }

    static boolean isIdentityComparison(PsiExpression expression2) {
        if (!(expression2 instanceof PsiBinaryExpression)) {
            return false;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression2;
        if (!ComparisonUtils.isEqualityComparison((PsiExpression)binaryExpression)) {
            return false;
        }
        PsiExpression rhs = binaryExpression.getROperand();
        if (rhs == null) {
            return false;
        }
        PsiExpression lhs = binaryExpression.getLOperand();
        PsiType lhsType = lhs.getType();
        if (lhsType instanceof PsiPrimitiveType) {
            return false;
        }
        PsiType rhsType = rhs.getType();
        return !(rhsType instanceof PsiPrimitiveType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/testFrameworks/SimplifiableAssertionInspection", "buildErrorString"));
    }

    private class SimplifiableJUnitAssertionVisitor
    extends BaseInspectionVisitor {
        private SimplifiableJUnitAssertionVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            if (expression2 == null) {
                SimplifiableJUnitAssertionVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression2);
            AssertHint assertHint = AssertHint.createAssertEqualsHint(expression2, SimplifiableAssertionInspection.this.checkTestNG());
            if (assertHint != null && SimplifiableAssertionInspection.this.isAssertEqualsThatCouldBeAssertLiteral(assertHint)) {
                this.registerMethodCallError(expression2, this.getReplacementMethodName(assertHint));
            } else {
                AssertHint assertTrueFalseHint = AssertHint.createAssertTrueFalseHint(expression2, SimplifiableAssertionInspection.this.checkTestNG());
                if (assertTrueFalseHint == null) {
                    return;
                }
                boolean assertTrue = assertTrueFalseHint.isAssertTrue();
                PsiExpression firstArgument = assertTrueFalseHint.getFirstArgument();
                if (ComparisonUtils.isNullComparison(firstArgument)) {
                    this.registerMethodCallError(expression2, assertTrue == this.isEqEqExpression(firstArgument) ? "assertNull()" : "assertNotNull()");
                } else if (SimplifiableAssertionInspection.isIdentityComparison(firstArgument)) {
                    this.registerMethodCallError(expression2, assertTrue == this.isEqEqExpression(firstArgument) ? "assertSame()" : "assertNotSame()");
                } else if (SimplifiableAssertionInspection.isEqualityComparison(firstArgument)) {
                    if (assertTrue) {
                        this.registerMethodCallError(expression2, "assertEquals()");
                    } else if (firstArgument instanceof PsiMethodCallExpression || this.hasPrimitiveOverload(assertTrueFalseHint)) {
                        this.registerMethodCallError(expression2, "assertNotEquals()");
                    }
                } else if (SimplifiableAssertionInspection.isAssertThatCouldBeFail(firstArgument, !assertTrue)) {
                    this.registerMethodCallError(expression2, "fail()");
                } else if (assertTrue && !SimplifiableAssertionInspection.this.checkTestNG() && SimplifiableAssertionInspection.isArrayEqualityComparison(firstArgument)) {
                    this.registerMethodCallError(expression2, "assertArrayEquals()");
                } else if (BoolUtils.isNegation(firstArgument)) {
                    this.registerMethodCallError(expression2, assertTrue ? "assertFalse()" : "assertTrue()");
                }
            }
        }

        private boolean hasPrimitiveOverload(AssertHint assertHint) {
            PsiClass containingClass = assertHint.getMethod().getContainingClass();
            if (containingClass == null) {
                return false;
            }
            PsiMethod primitiveOverload = (PsiMethod)CachedValuesManager.getCachedValue((PsiElement)containingClass, () -> {
                PsiMethod patternMethod = JavaPsiFacade.getElementFactory((Project)containingClass.getProject()).createMethodFromText("public static void assertNotEquals(long a, long b){}", (PsiElement)containingClass);
                return new CachedValueProvider.Result((Object)containingClass.findMethodBySignature(patternMethod, true), new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
            });
            return primitiveOverload != null;
        }

        @NonNls
        private String getReplacementMethodName(AssertHint assertHint) {
            PsiLiteralExpression literalExpression;
            PsiExpression firstArgument = assertHint.getFirstArgument();
            PsiExpression secondArgument = assertHint.getSecondArgument();
            if (firstArgument instanceof PsiLiteralExpression) {
                literalExpression = (PsiLiteralExpression)firstArgument;
            } else if (secondArgument instanceof PsiLiteralExpression) {
                literalExpression = (PsiLiteralExpression)secondArgument;
            } else {
                return "";
            }
            Object value2 = literalExpression.getValue();
            if (value2 == Boolean.TRUE) {
                return "assertTrue()";
            }
            if (value2 == Boolean.FALSE) {
                return "assertFalse()";
            }
            if (value2 == null) {
                return "assertNull()";
            }
            return "";
        }

        private boolean isEqEqExpression(PsiExpression argument) {
            if (!(argument instanceof PsiBinaryExpression)) {
                return false;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)argument;
            IElementType tokenType = binaryExpression.getOperationTokenType();
            return JavaTokenType.EQEQ.equals(tokenType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/testFrameworks/SimplifiableAssertionInspection$SimplifiableJUnitAssertionVisitor", "visitMethodCallExpression"));
        }
    }

    private class SimplifyAssertFix
    extends InspectionGadgetsFix {
        private SimplifyAssertFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("simplify.junit.assertion.simplify.quickfix", new Object[0]);
            if (string == null) {
                SimplifyAssertFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement methodNameIdentifier = descriptor.getPsiElement();
            PsiElement parent = methodNameIdentifier.getParent();
            if (parent == null) {
                return;
            }
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)parent.getParent();
            AssertHint assertHint = AssertHint.createAssertEqualsHint(callExpression, SimplifiableAssertionInspection.this.checkTestNG());
            if (assertHint != null && SimplifiableAssertionInspection.this.isAssertEqualsThatCouldBeAssertLiteral(assertHint)) {
                this.replaceAssertEqualsWithAssertLiteral(assertHint);
            } else {
                AssertHint assertTrueFalseHint = AssertHint.createAssertTrueFalseHint(callExpression, SimplifiableAssertionInspection.this.checkTestNG());
                if (assertTrueFalseHint == null) {
                    return;
                }
                boolean assertTrue = assertTrueFalseHint.isAssertTrue();
                PsiExpression argument = assertTrueFalseHint.getFirstArgument();
                if (ComparisonUtils.isNullComparison(argument)) {
                    this.replaceAssertWithAssertNull(assertTrueFalseHint);
                } else if (SimplifiableAssertionInspection.isIdentityComparison(argument)) {
                    this.replaceWithAssertSame(assertTrueFalseHint);
                } else if (assertTrue && SimplifiableAssertionInspection.isEqualityComparison(argument)) {
                    this.replaceWithAssertEquals(assertTrueFalseHint, "assertEquals");
                } else if (SimplifiableAssertionInspection.isAssertThatCouldBeFail(argument, !assertTrue)) {
                    this.replaceWithFail(assertTrueFalseHint);
                } else if (SimplifiableAssertionInspection.isEqualityComparison(argument)) {
                    this.replaceWithAssertEquals(assertTrueFalseHint, "assertNotEquals");
                } else if (assertTrue && !SimplifiableAssertionInspection.this.checkTestNG() && SimplifiableAssertionInspection.isArrayEqualityComparison(argument)) {
                    this.replaceWithAssertEquals(assertTrueFalseHint, "assertArrayEquals");
                } else if (BoolUtils.isNegation(argument)) {
                    this.replaceWithNegatedBooleanAssertion(assertTrueFalseHint);
                }
            }
        }

        private void addStaticImportOrQualifier(String methodName, AssertHint assertHint, StringBuilder out) {
            PsiMethodCallExpression originalMethodCall = (PsiMethodCallExpression)assertHint.getOriginalExpression();
            PsiReferenceExpression methodExpression = originalMethodCall.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                PsiMethod method = assertHint.getMethod();
                if (method == null) {
                    return;
                }
                PsiClass containingClass = method.getContainingClass();
                if (containingClass == null) {
                    return;
                }
                String className2 = containingClass.getQualifiedName();
                if (className2 == null) {
                    return;
                }
                if (!ImportUtils.addStaticImport(className2, methodName, (PsiElement)originalMethodCall)) {
                    out.append(className2).append(".");
                }
            } else {
                out.append(qualifier.getText()).append('.');
            }
        }

        private void replaceWithFail(AssertHint assertHint) {
            StringBuilder newExpression = new StringBuilder();
            this.addStaticImportOrQualifier("fail", assertHint, newExpression);
            newExpression.append("fail(");
            PsiExpression message2 = assertHint.getMessage();
            if (message2 != null) {
                newExpression.append(message2.getText());
            }
            newExpression.append(')');
            PsiReplacementUtil.replaceExpressionAndShorten(assertHint.getOriginalExpression(), newExpression.toString());
        }

        private void replaceWithAssertEquals(AssertHint assertHint, String methodName) {
            PsiExpression temp;
            PsiExpression firstArgument = assertHint.getFirstArgument();
            PsiExpression lhs = null;
            PsiExpression rhs = null;
            if (firstArgument instanceof PsiBinaryExpression) {
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)firstArgument;
                lhs = binaryExpression.getLOperand();
                rhs = binaryExpression.getROperand();
            } else {
                EqualityCheck check = EqualityCheck.from(firstArgument);
                if (check != null) {
                    lhs = check.getLeft();
                    rhs = check.getRight();
                } else if (firstArgument instanceof PsiMethodCallExpression && ARRAYS_EQUALS.test((PsiMethodCallExpression)firstArgument)) {
                    PsiExpression[] args = ((PsiMethodCallExpression)firstArgument).getArgumentList().getExpressions();
                    lhs = args[0];
                    rhs = args[1];
                }
            }
            if (!(lhs instanceof PsiLiteralExpression) && rhs instanceof PsiLiteralExpression) {
                temp = lhs;
                lhs = rhs;
                rhs = temp;
            }
            if (lhs == null || rhs == null) {
                return;
            }
            if (SimplifiableAssertionInspection.this.checkTestNG()) {
                temp = lhs;
                lhs = rhs;
                rhs = temp;
            }
            StringBuilder buf = new StringBuilder();
            PsiType lhsType = lhs.getType();
            PsiType rhsType = rhs.getType();
            if (lhsType != null && rhsType != null && PsiUtil.isLanguageLevel5OrHigher((PsiElement)lhs)) {
                PsiPrimitiveType rhsUnboxedType = PsiPrimitiveType.getUnboxedType((PsiType)rhsType);
                if (this.isPrimitiveAndBoxedWithOverloads(lhsType, rhsType) && rhsUnboxedType != null) {
                    buf.append(lhs.getText()).append(",(").append(rhsUnboxedType.getCanonicalText()).append(')').append(rhs.getText());
                } else {
                    PsiPrimitiveType unboxedType = PsiPrimitiveType.getUnboxedType((PsiType)lhsType);
                    if (this.isPrimitiveAndBoxedWithOverloads(rhsType, lhsType) && unboxedType != null) {
                        buf.append('(').append(unboxedType.getCanonicalText()).append(')').append(lhs.getText()).append(',').append(rhs.getText());
                    } else {
                        buf.append(lhs.getText()).append(',').append(rhs.getText());
                    }
                }
            } else {
                buf.append(lhs.getText()).append(',').append(rhs.getText());
            }
            PsiExpression originalExpression = assertHint.getOriginalExpression();
            if (lhsType != null && TypeConversionUtil.isFloatOrDoubleType((PsiType)lhsType.getDeepComponentType()) || rhsType != null && TypeConversionUtil.isFloatOrDoubleType((PsiType)rhsType.getDeepComponentType()) || this.isPrimitiveAndBoxedFloat(lhsType, rhsType) || this.isPrimitiveAndBoxedFloat(rhsType, lhsType)) {
                PsiMethod method;
                String noDelta = this.compoundMethodCall(methodName, assertHint, buf.toString());
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)originalExpression.getProject());
                PsiExpression expression2 = methodName.equals("assertNotEquals") ? null : factory.createExpressionFromText(noDelta, (PsiElement)originalExpression);
                PsiMethod psiMethod = method = expression2 instanceof PsiMethodCallExpression ? ((PsiMethodCallExpression)expression2).resolveMethod() : null;
                if (method == null || method.isDeprecated()) {
                    buf.append(",0.0");
                }
            }
            String newExpression = this.compoundMethodCall(methodName, assertHint, buf.toString());
            PsiReplacementUtil.replaceExpressionAndShorten(originalExpression, newExpression);
        }

        private boolean isPrimitiveAndBoxedWithOverloads(PsiType lhsType, PsiType rhsType) {
            if (lhsType instanceof PsiPrimitiveType && !PsiType.FLOAT.equals((Object)lhsType) && !PsiType.DOUBLE.equals((Object)lhsType)) {
                return rhsType instanceof PsiClassType;
            }
            return false;
        }

        private boolean isPrimitiveAndBoxedFloat(PsiType lhsType, PsiType rhsType) {
            return lhsType instanceof PsiPrimitiveType && rhsType instanceof PsiClassType && PsiType.DOUBLE.equals((Object)rhsType) && PsiType.FLOAT.equals((Object)rhsType);
        }

        private void replaceWithNegatedBooleanAssertion(AssertHint assertHint) {
            PsiPrefixExpression expression2 = (PsiPrefixExpression)assertHint.getFirstArgument();
            PsiExpression operand2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2.getOperand());
            if (operand2 == null) {
                return;
            }
            String newMethodName = assertHint.isAssertTrue() ? "assertFalse" : "assertTrue";
            String newExpression = this.compoundMethodCall(newMethodName, assertHint, operand2.getText());
            PsiReplacementUtil.replaceExpressionAndShorten(assertHint.getOriginalExpression(), newExpression);
        }

        private void replaceAssertWithAssertNull(AssertHint assertHint) {
            String methodName;
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)assertHint.getFirstArgument();
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            if (rhs == null) {
                return;
            }
            IElementType tokenType = binaryExpression.getOperationTokenType();
            if (!(lhs instanceof PsiLiteralExpression) && rhs instanceof PsiLiteralExpression) {
                rhs = lhs;
            }
            String memberName = "assertFalse".equals(methodName = assertHint.getMethod().getName()) ^ tokenType.equals(JavaTokenType.NE) ? "assertNotNull" : "assertNull";
            String newExpression = this.compoundMethodCall(memberName, assertHint, rhs.getText());
            PsiReplacementUtil.replaceExpressionAndShorten(assertHint.getOriginalExpression(), newExpression);
        }

        private String compoundMethodCall(String methodName, AssertHint assertHint, String args) {
            PsiExpression message2 = assertHint.getMessage();
            StringBuilder newExpression = new StringBuilder();
            this.addStaticImportOrQualifier(methodName, assertHint, newExpression);
            newExpression.append(methodName).append('(');
            int index = assertHint.getArgIndex();
            if (message2 != null && index != 0) {
                newExpression.append(message2.getText()).append(',');
            }
            newExpression.append(args);
            if (message2 != null && index == 0) {
                newExpression.append(',').append(message2.getText());
            }
            newExpression.append(')');
            return newExpression.toString();
        }

        private void replaceWithAssertSame(AssertHint assertHint) {
            PsiBinaryExpression firstArgument = (PsiBinaryExpression)assertHint.getFirstArgument();
            PsiExpression lhs = firstArgument.getLOperand();
            PsiExpression rhs = firstArgument.getROperand();
            IElementType tokenType = firstArgument.getOperationTokenType();
            if (!(lhs instanceof PsiLiteralExpression) && rhs instanceof PsiLiteralExpression) {
                PsiExpression temp = lhs;
                lhs = rhs;
                rhs = temp;
            }
            if (rhs == null) {
                return;
            }
            String methodName = assertHint.getMethod().getName();
            String memberName = "assertFalse".equals(methodName) ^ tokenType.equals(JavaTokenType.NE) ? "assertNotSame" : "assertSame";
            String newExpression = this.compoundMethodCall(memberName, assertHint, lhs.getText() + "," + rhs.getText());
            PsiReplacementUtil.replaceExpressionAndShorten(assertHint.getOriginalExpression(), newExpression);
        }

        private void replaceAssertEqualsWithAssertLiteral(AssertHint assertHint) {
            String compareValue;
            String literalValue;
            PsiExpression secondTestArgument;
            PsiExpression firstTestArgument = assertHint.getFirstArgument();
            if (SimplifiableAssertionInspection.isSimpleLiteral(firstTestArgument, secondTestArgument = assertHint.getSecondArgument())) {
                literalValue = firstTestArgument.getText();
                compareValue = secondTestArgument.getText();
            } else {
                literalValue = secondTestArgument.getText();
                compareValue = firstTestArgument.getText();
            }
            String uppercaseLiteralValue = Character.toUpperCase(literalValue.charAt(0)) + literalValue.substring(1);
            String methodName = "assert" + uppercaseLiteralValue;
            String newExpression = this.compoundMethodCall(methodName, assertHint, compareValue);
            PsiReplacementUtil.replaceExpressionAndShorten(assertHint.getOriginalExpression(), newExpression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/testFrameworks/SimplifiableAssertionInspection$SimplifyAssertFix", "getFamilyName"));
        }
    }
}

