/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ConcurrencyAnnotationsManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.OrderedSet;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.IgnoreClassFix;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.ui.UiUtils;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AccessToStaticFieldLockedOnInstanceInspection
extends BaseInspection {
    public OrderedSet<String> ignoredClasses = new OrderedSet();

    @Nullable
    public JComponent createOptionsPanel() {
        return UiUtils.createTreeClassChooserList(this.ignoredClasses, "Ignored Classes", "Choose class to ignore", new String[0]);
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiExpression expression2 = (PsiExpression)infos[0];
        PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)expression2.getType());
        if (aClass == null) {
            return null;
        }
        String name2 = aClass.getQualifiedName();
        return new IgnoreClassFix(name2, (Collection<? super String>)this.ignoredClasses, "Ignore static fields with type '" + name2 + "'");
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("access.to.static.field.locked.on.instance.problem.descriptor", new Object[0]);
        if (string == null) {
            AccessToStaticFieldLockedOnInstanceInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AccessToStaticFieldLockedOnInstanceVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/AccessToStaticFieldLockedOnInstanceInspection", "buildErrorString"));
    }

    private class AccessToStaticFieldLockedOnInstanceVisitor
    extends BaseInspectionVisitor {
        private AccessToStaticFieldLockedOnInstanceVisitor() {
        }

        @Override
        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression2) {
            PsiSynchronizedStatement synchronizedStatement;
            PsiClass expressionClass;
            ConcurrencyAnnotationsManager annotationsManager;
            List list;
            PsiClass aClass;
            if (expression2 == null) {
                AccessToStaticFieldLockedOnInstanceVisitor.$$$reportNull$$$0(0);
            }
            super.visitReferenceExpression(expression2);
            PsiElement target = expression2.resolve();
            if (!(target instanceof PsiField)) {
                return;
            }
            PsiField lockedField = (PsiField)target;
            if (!lockedField.hasModifierProperty("static") || ExpressionUtils.isConstant(lockedField)) {
                return;
            }
            if (lockedField.hasModifierProperty("final") && AnnotationUtil.findAnnotation((PsiModifierListOwner)(aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)lockedField.getType())), (Collection)(list = (annotationsManager = ConcurrencyAnnotationsManager.getInstance((Project)expression2.getProject())).getThreadSafeList())) != null) {
                return;
            }
            PsiClass containingClass = lockedField.getContainingClass();
            if (!PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)expression2, (boolean)false)) {
                return;
            }
            if (!AccessToStaticFieldLockedOnInstanceInspection.this.ignoredClasses.isEmpty() && AccessToStaticFieldLockedOnInstanceInspection.this.ignoredClasses.contains((Object)TypeUtils.resolvedClassName(lockedField.getType()))) {
                return;
            }
            boolean isLockedOnInstance = false;
            boolean isLockedOnClass = false;
            PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMethod.class);
            if (containingMethod != null && containingMethod.hasModifierProperty("synchronized")) {
                if (containingMethod.hasModifierProperty("static")) {
                    isLockedOnClass = true;
                } else {
                    isLockedOnInstance = true;
                }
            }
            if ((expressionClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiClass.class)) == null) {
                return;
            }
            PsiReferenceExpression elementToCheck = expression2;
            while ((synchronizedStatement = (PsiSynchronizedStatement)PsiTreeUtil.getParentOfType((PsiElement)elementToCheck, PsiSynchronizedStatement.class)) != null && PsiTreeUtil.isAncestor((PsiElement)expressionClass, (PsiElement)synchronizedStatement, (boolean)true)) {
                PsiExpression lockExpression2 = synchronizedStatement.getLockExpression();
                if (lockExpression2 instanceof PsiReferenceExpression) {
                    PsiReferenceExpression reference = (PsiReferenceExpression)lockExpression2;
                    PsiElement lockTarget = reference.resolve();
                    if (lockTarget instanceof PsiField) {
                        PsiField lockField = (PsiField)lockTarget;
                        if (lockField.hasModifierProperty("static")) {
                            isLockedOnClass = true;
                        } else {
                            isLockedOnInstance = true;
                        }
                    }
                } else if (lockExpression2 instanceof PsiThisExpression) {
                    isLockedOnInstance = true;
                } else if (lockExpression2 instanceof PsiClassObjectAccessExpression) {
                    isLockedOnClass = true;
                }
                elementToCheck = synchronizedStatement;
            }
            if (!isLockedOnInstance || isLockedOnClass) {
                return;
            }
            this.registerError((PsiElement)expression2, expression2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/threading/AccessToStaticFieldLockedOnInstanceInspection$AccessToStaticFieldLockedOnInstanceVisitor", "visitReferenceExpression"));
        }
    }
}

