/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.MakeFieldFinalFix;
import com.siyeh.ig.threading.ContainsSynchronizationVisitor;
import com.siyeh.ig.threading.VariableAccessVisitor;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FieldAccessedSynchronizedAndUnsynchronizedInspection
extends BaseInspection {
    public boolean countGettersAndSetters = false;

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("field.accessed.synchronized.and.unsynchronized.problem.descriptor", new Object[0]);
        if (string == null) {
            FieldAccessedSynchronizedAndUnsynchronizedInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("field.accessed.synchronized.and.unsynchronized.option", new Object[0]), (InspectionProfileEntry)this, "countGettersAndSetters");
    }

    public boolean runForWholeFile() {
        return true;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return MakeFieldFinalFix.buildFix((PsiField)infos[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new FieldAccessedSynchronizedAndUnsynchronizedVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/FieldAccessedSynchronizedAndUnsynchronizedInspection", "buildErrorString"));
    }

    private class FieldAccessedSynchronizedAndUnsynchronizedVisitor
    extends BaseInspectionVisitor {
        private FieldAccessedSynchronizedAndUnsynchronizedVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                FieldAccessedSynchronizedAndUnsynchronizedVisitor.$$$reportNull$$$0(0);
            }
            if (!this.containsSynchronization((PsiElement)aClass)) {
                return;
            }
            VariableAccessVisitor visitor2 = new VariableAccessVisitor(aClass, FieldAccessedSynchronizedAndUnsynchronizedInspection.this.countGettersAndSetters);
            aClass.accept((PsiElementVisitor)visitor2);
            Set<PsiField> fields = visitor2.getInappropriatelyAccessedFields();
            for (PsiField field : fields) {
                PsiClass containingClass;
                if (field.hasModifierProperty("final") || field.hasModifierProperty("volatile") || !aClass.equals(containingClass = field.getContainingClass())) continue;
                this.registerFieldError(field, field);
            }
        }

        private boolean containsSynchronization(PsiElement context) {
            ContainsSynchronizationVisitor visitor2 = new ContainsSynchronizationVisitor();
            context.accept((PsiElementVisitor)visitor2);
            return visitor2.containsSynchronization();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/threading/FieldAccessedSynchronizedAndUnsynchronizedInspection$FieldAccessedSynchronizedAndUnsynchronizedVisitor", "visitClass"));
        }
    }
}

