/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.threading.AbstractReplaceWithAnotherMethodCallFix;
import org.jetbrains.annotations.NotNull;

public class ThreadRunInspection
extends BaseInspection {
    private static final CallMatcher THREAD_RUN = CallMatcher.instanceCall("java.lang.Thread", "run").parameterCount(0);

    @NotNull
    public String getID() {
        return "CallToThreadRun";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("thread.run.problem.descriptor", new Object[0]);
        if (string == null) {
            ThreadRunInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ThreadRunFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ThreadRunVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/ThreadRunInspection", "buildErrorString"));
    }

    private static class ThreadRunVisitor
    extends BaseInspectionVisitor {
        private ThreadRunVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            if (call == null) {
                ThreadRunVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(call);
            if (!THREAD_RUN.test(call)) {
                return;
            }
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)call, PsiMethod.class);
            if (THREAD_RUN.methodMatches(method)) {
                return;
            }
            this.registerMethodCallError(call, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/siyeh/ig/threading/ThreadRunInspection$ThreadRunVisitor", "visitMethodCallExpression"));
        }
    }

    private static class ThreadRunFix
    extends AbstractReplaceWithAnotherMethodCallFix {
        private ThreadRunFix() {
        }

        @Override
        protected String getMethodName() {
            return "start";
        }
    }
}

