/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class WaitOrAwaitWithoutTimeoutInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("wait.or.await.without.timeout.problem.descriptor", new Object[0]);
        if (string == null) {
            WaitOrAwaitWithoutTimeoutInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new WaitWithoutTimeoutVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/WaitOrAwaitWithoutTimeoutInspection", "buildErrorString"));
    }

    private static class WaitWithoutTimeoutVisitor
    extends BaseInspectionVisitor {
        private WaitWithoutTimeoutVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            if (expression2 == null) {
                WaitWithoutTimeoutVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"wait".equals(methodName) && !"await".equals(methodName)) {
                return;
            }
            PsiExpressionList argList = expression2.getArgumentList();
            PsiExpression[] args = argList.getExpressions();
            int numParams = args.length;
            if (numParams != 0) {
                return;
            }
            if ("await".equals(methodName)) {
                PsiMethod method = expression2.resolveMethod();
                if (method == null) {
                    return;
                }
                PsiClass containingClass = method.getContainingClass();
                if (containingClass == null) {
                    return;
                }
                String className2 = containingClass.getName();
                if (!"java.util.concurrent.locks.Condition".equals(className2)) {
                    return;
                }
            }
            this.registerMethodCallError(expression2, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/threading/WaitOrAwaitWithoutTimeoutInspection$WaitWithoutTimeoutVisitor", "visitMethodCallExpression"));
        }
    }
}

