/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.constant;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiWhiteSpace;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.constant.ConstantSubexpressionPredicate;
import org.jetbrains.annotations.NotNull;

public class ConstantSubexpressionIntention
extends MutablyNamedIntention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new ConstantSubexpressionPredicate();
    }

    @Override
    protected String getTextForElement(PsiElement element) {
        PsiJavaToken token;
        if (element instanceof PsiJavaToken) {
            token = (PsiJavaToken)element;
        } else {
            PsiElement prevSibling = element.getPrevSibling();
            if (prevSibling instanceof PsiJavaToken) {
                token = (PsiJavaToken)prevSibling;
            } else {
                throw new AssertionError();
            }
        }
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)element.getParent();
        PsiPolyadicExpression subexpression = ConstantSubexpressionPredicate.getSubexpression(polyadicExpression, token);
        String text2 = ConstantSubexpressionIntention.getPresentableText((PsiElement)subexpression);
        return IntentionPowerPackBundle.message("constant.expression.intention.name", text2);
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        PsiJavaToken token;
        if (element == null) {
            ConstantSubexpressionIntention.$$$reportNull$$$0(0);
        }
        if (element instanceof PsiJavaToken) {
            token = (PsiJavaToken)element;
        } else {
            PsiElement prevSibling = element.getPrevSibling();
            if (prevSibling instanceof PsiJavaToken) {
                token = (PsiJavaToken)prevSibling;
            } else {
                throw new AssertionError();
            }
        }
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)element.getParent();
        PsiPolyadicExpression subexpression = ConstantSubexpressionPredicate.getSubexpression(polyadicExpression, token);
        if (subexpression == null) {
            return;
        }
        Object value2 = ExpressionUtils.computeConstantExpression((PsiExpression)subexpression);
        StringBuilder newExpressionText = new StringBuilder();
        PsiExpression[] operands2 = polyadicExpression.getOperands();
        PsiExpression prevOperand = null;
        PsiJavaToken prevToken = null;
        CommentTracker commentTracker = new CommentTracker();
        for (PsiExpression operand2 : operands2) {
            PsiJavaToken currentToken = polyadicExpression.getTokenBeforeOperand(operand2);
            if (prevToken != null) {
                newExpressionText.append(prevToken.getText());
            }
            if (token == currentToken) {
                if (newExpressionText.length() > 0) {
                    newExpressionText.append(' ');
                }
                if (value2 instanceof Long) {
                    newExpressionText.append(value2).append('L');
                } else if (value2 instanceof Double) {
                    double v = (Double)value2;
                    if (Double.isNaN(v)) {
                        newExpressionText.append("java.lang.Double.NaN");
                    } else if (Double.isInfinite(v)) {
                        if (v > 0.0) {
                            newExpressionText.append("java.lang.Double.POSITIVE_INFINITY");
                        } else {
                            newExpressionText.append("java.lang.Double.NEGATIVE_INFINITY");
                        }
                    } else {
                        newExpressionText.append(v);
                    }
                } else if (value2 instanceof Float) {
                    float v = ((Float)value2).floatValue();
                    if (Float.isNaN(v)) {
                        newExpressionText.append("java.lang.Float.NaN");
                    } else if (Float.isInfinite(v)) {
                        if (v > 0.0f) {
                            newExpressionText.append("java.lang.Float.POSITIVE_INFINITY");
                        } else {
                            newExpressionText.append("java.lang.Float.NEGATIVE_INFINITY");
                        }
                    } else {
                        newExpressionText.append(v).append('f');
                    }
                } else {
                    newExpressionText.append(value2);
                }
                prevOperand = null;
                prevToken = null;
                continue;
            }
            if (prevOperand != null) {
                newExpressionText.append(commentTracker.text((PsiElement)prevOperand));
            }
            prevOperand = operand2;
            prevToken = currentToken;
        }
        if (prevToken != null) {
            newExpressionText.append(prevToken.getText());
        }
        if (prevOperand != null) {
            newExpressionText.append(commentTracker.text((PsiElement)prevOperand));
        }
        PsiReplacementUtil.replaceExpression((PsiExpression)polyadicExpression, newExpressionText.toString(), commentTracker);
    }

    private static String getPresentableText(PsiElement element) {
        return ConstantSubexpressionIntention.getPresentableText(element, new StringBuilder()).toString();
    }

    private static StringBuilder getPresentableText(PsiElement element, StringBuilder builder) {
        if (element == null) {
            return builder;
        }
        if (element instanceof PsiWhiteSpace) {
            return builder.append(' ');
        }
        PsiElement[] children = element.getChildren();
        if (children.length != 0) {
            for (PsiElement child : children) {
                ConstantSubexpressionIntention.getPresentableText(child, builder);
            }
        } else {
            builder.append(element.getText());
        }
        return builder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/constant/ConstantSubexpressionIntention", "processIntention"));
    }
}

