/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.exceptions;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.exceptions.ObscureThrownExceptionsPredicate;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObscureThrownExceptionsIntention
extends MutablyNamedIntention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new ObscureThrownExceptionsPredicate();
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) {
        if (element == null) {
            ObscureThrownExceptionsIntention.$$$reportNull$$$0(0);
        }
        if (!(element instanceof PsiReferenceList)) {
            return;
        }
        PsiReferenceList referenceList = (PsiReferenceList)element;
        PsiClassType[] types = referenceList.getReferencedTypes();
        PsiClass commonSuperClass = ObscureThrownExceptionsIntention.findCommonSuperClass(types);
        if (commonSuperClass == null) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)element.getProject());
        PsiJavaCodeReferenceElement referenceElement = factory.createClassReferenceElement(commonSuperClass);
        PsiReferenceList newReferenceList = factory.createReferenceList(new PsiJavaCodeReferenceElement[]{referenceElement});
        new CommentTracker().replaceAndRestoreComments((PsiElement)referenceList, (PsiElement)newReferenceList);
    }

    @Nullable
    public static PsiClass findCommonSuperClass(PsiClassType ... types) {
        PsiClass aClass1;
        if (types.length == 0) {
            return null;
        }
        PsiClass firstClass = types[0].resolve();
        if (firstClass == null || types.length == 1) {
            return firstClass;
        }
        HashSet<PsiClass> sourceSet = new HashSet<PsiClass>();
        for (PsiClass aClass = firstClass; aClass != null; aClass = aClass.getSuperClass()) {
            sourceSet.add(aClass);
        }
        if (sourceSet.isEmpty()) {
            return null;
        }
        HashSet<PsiClass> targetSet = new HashSet<PsiClass>();
        int max = types.length - 1;
        for (int i = 1; i < max; ++i) {
            PsiClassType classType = types[i];
            for (PsiClass aClass12 = classType.resolve(); aClass12 != null; aClass12 = aClass12.getSuperClass()) {
                if (!sourceSet.contains(aClass12)) continue;
                targetSet.add(aClass12);
            }
            sourceSet = targetSet;
            targetSet = new HashSet();
        }
        for (aClass1 = types[max].resolve(); aClass1 != null && !sourceSet.contains(aClass1); aClass1 = aClass1.getSuperClass()) {
        }
        return aClass1;
    }

    @Override
    protected String getTextForElement(PsiElement element) {
        PsiReferenceList referenceList = (PsiReferenceList)element;
        PsiClassType[] types = referenceList.getReferencedTypes();
        PsiClass commonSuperClass = ObscureThrownExceptionsIntention.findCommonSuperClass(types);
        if (commonSuperClass == null || !InheritanceUtil.isInheritor((PsiClass)commonSuperClass, (String)"java.lang.Throwable")) {
            return null;
        }
        return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"throws " + commonSuperClass.getName()});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/exceptions/ObscureThrownExceptionsIntention", "processIntention"));
    }
}

