/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.expression;

import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.tree.IElementType;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.expression.ExpressionPredicate;
import org.jetbrains.annotations.NotNull;

public class FlipExpressionIntention
extends MutablyNamedIntention {
    @Override
    public String getTextForElement(PsiElement element) {
        PsiExpression[] operands2;
        PsiPolyadicExpression expression2 = (PsiPolyadicExpression)element.getParent();
        PsiJavaToken sign = expression2.getTokenBeforeOperand((operands2 = expression2.getOperands())[1]);
        String operatorText = sign == null ? "" : sign.getText();
        IElementType tokenType = expression2.getOperationTokenType();
        boolean commutative = ParenthesesUtils.isCommutativeOperator(tokenType);
        if (commutative && !ExpressionUtils.isStringConcatenation((PsiElement)expression2)) {
            return IntentionPowerPackBundle.message("flip.smth.intention.name", operatorText);
        }
        return IntentionPowerPackBundle.message("flip.smth.intention.name1", operatorText);
    }

    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        return new ExpressionPredicate();
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        PsiJavaToken token;
        PsiElement parent;
        if (element == null) {
            FlipExpressionIntention.$$$reportNull$$$0(0);
        }
        if (!((parent = (token = (PsiJavaToken)element).getParent()) instanceof PsiPolyadicExpression)) {
            return;
        }
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)parent;
        PsiExpression[] operands2 = polyadicExpression.getOperands();
        StringBuilder newExpression = new StringBuilder();
        CommentTracker commentTracker = new CommentTracker();
        String prevOperand = null;
        String tokenText = token.getText() + ' ';
        for (PsiExpression operand2 : operands2) {
            PsiJavaToken token1 = polyadicExpression.getTokenBeforeOperand(operand2);
            if (token == token1) {
                newExpression.append(commentTracker.text((PsiElement)operand2)).append(tokenText);
                continue;
            }
            if (prevOperand != null) {
                newExpression.append(prevOperand).append(tokenText);
            }
            prevOperand = commentTracker.text((PsiElement)operand2);
        }
        newExpression.append(prevOperand);
        PsiReplacementUtil.replaceExpression((PsiExpression)polyadicExpression, newExpression.toString(), commentTracker);
    }

    @Override
    protected void processIntention(Editor editor, @NotNull PsiElement element) {
        if (element == null) {
            FlipExpressionIntention.$$$reportNull$$$0(1);
        }
        CaretModel caretModel = editor.getCaretModel();
        int offset = caretModel.getOffset();
        super.processIntention(editor, element);
        caretModel.moveToOffset(offset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/expression/FlipExpressionIntention", "processIntention"));
    }
}

