/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.expression.eliminate;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ipp.expression.eliminate.EliminableExpression;
import com.siyeh.ipp.expression.eliminate.EliminateUtils;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DistributiveExpression
extends EliminableExpression {
    private static final Map<IElementType, IElementType[]> OUTER_OPERATORS = new HashMap<IElementType, IElementType[]>();

    @Contract(pure=true)
    DistributiveExpression(@Nullable PsiPolyadicExpression expression2, @NotNull PsiExpression operand2) {
        if (operand2 == null) {
            DistributiveExpression.$$$reportNull$$$0(0);
        }
        super(expression2, operand2);
    }

    @Override
    boolean eliminate(@Nullable PsiJavaToken tokenBefore, @NotNull StringBuilder sb) {
        PsiPolyadicExpression innerExpr;
        if (sb == null) {
            DistributiveExpression.$$$reportNull$$$0(1);
        }
        if ((innerExpr = (PsiPolyadicExpression)PsiTreeUtil.findChildOfType((PsiElement)this.myOperand, PsiPolyadicExpression.class)) == null) {
            return false;
        }
        ExpressionFormat fmt = ExpressionFormat.create(this.myExpression, this.myOperand);
        boolean isNegated = EliminateUtils.isNegated((PsiExpression)(this.myExpression == null ? this.myOperand : this.myExpression), false, new PsiExpression[0]);
        return this.eliminateExpression(innerExpr, fmt, tokenBefore == null ? null : tokenBefore.getTokenType(), isNegated, sb);
    }

    private boolean eliminateExpression(@NotNull PsiPolyadicExpression expression2, @NotNull ExpressionFormat fmt, @Nullable IElementType tokenBefore, boolean isNegated, @NotNull StringBuilder sb) {
        if (expression2 == null) {
            DistributiveExpression.$$$reportNull$$$0(2);
        }
        if (fmt == null) {
            DistributiveExpression.$$$reportNull$$$0(3);
        }
        if (sb == null) {
            DistributiveExpression.$$$reportNull$$$0(4);
        }
        for (PsiExpression operand2 : expression2.getOperands()) {
            IElementType tokenType = EliminateUtils.getOperandTokenType(expression2, operand2, tokenBefore);
            if (EliminateUtils.processPrefixed(operand2, isNegated, (op, isOpNegated) -> this.eliminateOperand((PsiExpression)op, fmt, tokenType, (boolean)isOpNegated, sb)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private boolean eliminateOperand(@NotNull PsiExpression operand2, @NotNull ExpressionFormat fmt, @Nullable IElementType tokenType, boolean isNegated, @NotNull StringBuilder sb) {
        PsiPolyadicExpression polyadic;
        if (operand2 == null) {
            DistributiveExpression.$$$reportNull$$$0(5);
        }
        if (fmt == null) {
            DistributiveExpression.$$$reportNull$$$0(6);
        }
        if (sb == null) {
            DistributiveExpression.$$$reportNull$$$0(7);
        }
        if ((polyadic = (PsiPolyadicExpression)ObjectUtils.tryCast((Object)operand2, PsiPolyadicExpression.class)) != null && EliminateUtils.isAdditive(polyadic.getOperationTokenType())) {
            return this.eliminateExpression(polyadic, fmt, tokenType, isNegated, sb);
        }
        StringBuilder operandText = new StringBuilder();
        if (polyadic != null) {
            IElementType outerTokenType;
            isNegated = EliminateUtils.isNegated((PsiExpression)polyadic, isNegated, new PsiExpression[0]);
            PsiJavaToken outerToken = this.myExpression == null ? null : this.myExpression.getTokenBeforeOperand(this.myOperand);
            IElementType iElementType = outerTokenType = outerToken == null ? null : outerToken.getTokenType();
            if (!DistributiveExpression.getMultiplicativeOperandText(polyadic, outerTokenType, operandText)) {
                return false;
            }
        } else {
            operandText.append(operand2.getText());
        }
        if (!EliminateUtils.addPrefix(tokenType, isNegated, sb)) {
            return false;
        }
        sb.append(fmt.format(operandText.toString()));
        return true;
    }

    private static boolean getMultiplicativeOperandText(@NotNull PsiPolyadicExpression operand2, @Nullable IElementType tokenBefore, @NotNull StringBuilder sb) {
        if (operand2 == null) {
            DistributiveExpression.$$$reportNull$$$0(8);
        }
        if (sb == null) {
            DistributiveExpression.$$$reportNull$$$0(9);
        }
        PsiExpression[] operands2 = operand2.getOperands();
        for (int i = 0; i < operands2.length; ++i) {
            PsiExpression innerOperand = operands2[i];
            IElementType tokenType = EliminateUtils.getOperandTokenType(operand2, innerOperand, tokenBefore);
            if (i != 0 && !EliminateUtils.addPrefix(tokenType, false, sb)) {
                return false;
            }
            PsiPolyadicExpression polyadic = (PsiPolyadicExpression)ObjectUtils.tryCast((Object)innerOperand, PsiPolyadicExpression.class);
            if (polyadic != null) {
                if (DistributiveExpression.getMultiplicativeOperandText(polyadic, tokenType, sb)) continue;
                return false;
            }
            EliminateUtils.processPrefixed(innerOperand, false, (op, isOpNegated) -> sb.append(op.getText()));
        }
        return true;
    }

    @Nullable
    static DistributiveExpression create(@NotNull PsiParenthesizedExpression parenthesized) {
        DistributiveExpression expression2;
        if (parenthesized == null) {
            DistributiveExpression.$$$reportNull$$$0(10);
        }
        if ((expression2 = EliminateUtils.createExpression(parenthesized, DistributiveExpression::new, OUTER_OPERATORS)) == null) {
            return null;
        }
        PsiPolyadicExpression polyadicExpression = expression2.getExpression();
        if (polyadicExpression == null || !JavaTokenType.DIV.equals(polyadicExpression.getOperationTokenType())) {
            return expression2;
        }
        PsiExpression operand2 = expression2.getOperand();
        if (polyadicExpression.getTokenBeforeOperand(operand2) != null) {
            return null;
        }
        if (TypeConversionUtil.isIntegralNumberType((PsiType)polyadicExpression.getType())) {
            return null;
        }
        return expression2;
    }

    static {
        OUTER_OPERATORS.put(JavaTokenType.PLUS, new IElementType[]{JavaTokenType.ASTERISK, JavaTokenType.DIV});
        OUTER_OPERATORS.put(JavaTokenType.MINUS, new IElementType[]{JavaTokenType.ASTERISK, JavaTokenType.DIV});
        OUTER_OPERATORS.put(JavaTokenType.OROR, new IElementType[]{JavaTokenType.ANDAND});
        OUTER_OPERATORS.put(JavaTokenType.OR, new IElementType[]{JavaTokenType.AND});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operand";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fmt";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parenthesized";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ipp/expression/eliminate/DistributiveExpression";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "eliminate";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "eliminateExpression";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "eliminateOperand";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getMultiplicativeOperandText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ExpressionFormat {
        private static final ExpressionFormat EMPTY = new ExpressionFormat("", "");
        private final String myBeforeText;
        private final String myAfterText;

        @Contract(pure=true)
        private ExpressionFormat(String beforeText, String afterText) {
            this.myBeforeText = beforeText;
            this.myAfterText = afterText;
        }

        @NotNull
        @Contract(pure=true)
        private String format(String operandText) {
            String string = this.myBeforeText + operandText + this.myAfterText;
            if (string == null) {
                ExpressionFormat.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static ExpressionFormat create(@Nullable PsiPolyadicExpression expression2, @Nullable PsiExpression myOperand) {
            if (expression2 == null) {
                return EMPTY;
            }
            StringBuilder beforeText = new StringBuilder();
            int operandIdx = ExpressionFormat.constructExpressionText(beforeText, expression2, 0, myOperand);
            StringBuilder afterText = new StringBuilder();
            ExpressionFormat.constructExpressionText(afterText, expression2, operandIdx + 1, null);
            return new ExpressionFormat(beforeText.toString(), afterText.toString());
        }

        private static int constructExpressionText(@NotNull StringBuilder sb, @NotNull PsiPolyadicExpression expression2, int operandIdx, @Nullable PsiExpression stopAt) {
            if (sb == null) {
                ExpressionFormat.$$$reportNull$$$0(1);
            }
            if (expression2 == null) {
                ExpressionFormat.$$$reportNull$$$0(2);
            }
            PsiExpression[] operands2 = expression2.getOperands();
            while (operandIdx < operands2.length) {
                PsiExpression operand2 = operands2[operandIdx];
                PsiJavaToken beforeOperand = expression2.getTokenBeforeOperand(operand2);
                if (beforeOperand != null) {
                    sb.append(beforeOperand.getText());
                }
                if (operand2 == stopAt) break;
                PsiPolyadicExpression polyadic = (PsiPolyadicExpression)ObjectUtils.tryCast((Object)operand2, PsiPolyadicExpression.class);
                if (polyadic != null) {
                    ExpressionFormat.constructExpressionText(sb, polyadic, 0, null);
                } else {
                    EliminateUtils.processPrefixed(operand2, false, (op, isOpNegated) -> sb.append(op.getText()));
                }
                ++operandIdx;
            }
            return operandIdx;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ipp/expression/eliminate/DistributiveExpression$ExpressionFormat";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "format";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ipp/expression/eliminate/DistributiveExpression$ExpressionFormat";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "constructExpressionText";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

