/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.functional;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.extractMethod.ControlFlowWrapper;
import com.intellij.refactoring.extractMethod.ExtractMethodProcessor;
import com.intellij.refactoring.extractMethod.PrepareFailedException;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.inplace.MemberInplaceRenamer;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.duplicates.Match;
import com.intellij.refactoring.util.duplicates.MethodDuplicatesHandler;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.UniqueNameGenerator;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ExtractToMethodReferenceIntention
extends BaseElementAtCaretIntentionAction {
    private static final Logger LOG = Logger.getInstance(ExtractToMethodReferenceIntention.class);

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            ExtractToMethodReferenceIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = IntentionPowerPackBundle.message("extract.to.method.reference.intention.name", new Object[0]);
        if (string == null) {
            ExtractToMethodReferenceIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        PsiLambdaExpression lambdaExpression;
        if (project == null) {
            ExtractToMethodReferenceIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            ExtractToMethodReferenceIntention.$$$reportNull$$$0(3);
        }
        if ((lambdaExpression = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLambdaExpression.class, (boolean)false)) != null) {
            PsiElement body2 = lambdaExpression.getBody();
            if (body2 == null) {
                return false;
            }
            PsiType functionalInterfaceType = lambdaExpression.getFunctionalInterfaceType();
            if (functionalInterfaceType == null || LambdaUtil.getFunctionalInterfaceReturnType((PsiType)functionalInterfaceType) == null) {
                return false;
            }
            if (LambdaUtil.createLambdaParameterListWithFormalTypes((PsiType)functionalInterfaceType, (PsiLambdaExpression)lambdaExpression, (boolean)false) == null) {
                return false;
            }
            PsiExpression asMethodReference = LambdaCanBeMethodReferenceInspection.canBeMethodReferenceProblem(body2, (PsiVariable[])lambdaExpression.getParameterList().getParameters(), functionalInterfaceType, null);
            if (asMethodReference != null) {
                return false;
            }
            try {
                PsiStatement[] psiStatementArray;
                if (body2 instanceof PsiCodeBlock) {
                    psiStatementArray = ((PsiCodeBlock)body2).getStatements();
                } else {
                    PsiElement[] psiElementArray = new PsiElement[1];
                    psiStatementArray = psiElementArray;
                    psiElementArray[0] = body2;
                }
                PsiStatement[] toExtract = psiStatementArray;
                ControlFlowWrapper wrapper = new ControlFlowWrapper(project, body2, (PsiElement[])toExtract);
                wrapper.prepareExitStatements((PsiElement[])toExtract, body2);
                PsiVariable[] outputVariables = wrapper.getOutputVariables();
                List<PsiVariable> inputVariables = wrapper.getInputVariables(body2, (PsiElement[])toExtract, outputVariables);
                return inputVariables.stream().allMatch(variable -> variable instanceof PsiParameter && ((PsiParameter)variable).getDeclarationScope() == lambdaExpression);
            }
            catch (ControlFlowWrapper.ExitStatementsNotSameException | PrepareFailedException exception) {
                // empty catch block
            }
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        PsiLambdaExpression lambdaExpression;
        if (project == null) {
            ExtractToMethodReferenceIntention.$$$reportNull$$$0(4);
        }
        if (element == null) {
            ExtractToMethodReferenceIntention.$$$reportNull$$$0(5);
        }
        if ((lambdaExpression = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLambdaExpression.class, (boolean)false)) != null) {
            HashSet usedFields;
            PsiCodeBlock body2 = RefactoringUtil.expandExpressionLambdaToCodeBlock(lambdaExpression);
            PsiClass targetClass = ClassUtils.getContainingClass((PsiElement)lambdaExpression);
            if (targetClass == null) {
                return;
            }
            PsiStatement[] elements = body2.getStatements();
            boolean canBeStatic = ExtractMethodProcessor.canBeStatic(targetClass, (PsiElement)lambdaExpression, (PsiElement[])elements, usedFields = new HashSet()) && usedFields.isEmpty();
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)targetClass.getProject());
            PsiType functionalInterfaceType = lambdaExpression.getFunctionalInterfaceType();
            String parameters2 = LambdaUtil.createLambdaParameterListWithFormalTypes((PsiType)functionalInterfaceType, (PsiLambdaExpression)lambdaExpression, (boolean)false) + "{}";
            String targetMethodName = ExtractToMethodReferenceIntention.getUniqueMethodName(targetClass, elementFactory, functionalInterfaceType, parameters2);
            PsiType returnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)lambdaExpression);
            LOG.assertTrue(returnType != null);
            PsiMethod container = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)lambdaExpression, PsiMethod.class);
            PsiTypeParameterList typeParamsList = container != null ? RefactoringUtil.createTypeParameterListWithUsedTypeParameters(container.getTypeParameterList(), (PsiElement[])elements) : null;
            PsiMethod emptyMethod = elementFactory.createMethodFromText("private " + (canBeStatic ? "static " : "") + (typeParamsList != null ? typeParamsList.getText() + " " : "") + returnType.getCanonicalText() + " " + targetMethodName + parameters2, (PsiElement)targetClass);
            PsiCodeBlock targetMethodBody = emptyMethod.getBody();
            LOG.assertTrue(targetMethodBody != null);
            targetMethodBody.replace((PsiElement)body2);
            PsiMethod method = (PsiMethod)CodeStyleManager.getInstance((Project)project).reformat(JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(targetClass.add((PsiElement)emptyMethod)));
            PsiMethodReferenceExpression methodReference = (PsiMethodReferenceExpression)elementFactory.createExpressionFromText((canBeStatic ? targetClass.getName() : "this") + "::" + targetMethodName, (PsiElement)lambdaExpression);
            CommentTracker tracker = new CommentTracker();
            tracker.markUnchanged(lambdaExpression.getBody());
            methodReference = (PsiMethodReferenceExpression)tracker.replace((PsiElement)lambdaExpression, (PsiElement)methodReference);
            tracker.insertCommentsBefore((PsiElement)methodReference);
            ExtractToMethodReferenceIntention.startInplaceRename(editor, method, methodReference);
        }
    }

    private static void startInplaceRename(final Editor editor, final PsiMethod method, PsiMethodReferenceExpression methodReference) {
        PsiIdentifier nameIdentifier = method.getNameIdentifier();
        if (nameIdentifier == null) {
            return;
        }
        nameIdentifier = (PsiIdentifier)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)nameIdentifier);
        editor.getCaretModel().moveToOffset(((PsiElement)ObjectUtils.notNull((Object)methodReference.getReferenceNameElement(), (Object)nameIdentifier)).getTextOffset());
        RenamePsiElementProcessor processor = RenamePsiElementProcessor.forElement((PsiElement)method);
        if (!processor.isInplaceRenameSupported()) {
            return;
        }
        final ArrayList<String> suggestedNames = new ArrayList<String>();
        suggestedNames.add(method.getName());
        processor.substituteElementToRename((PsiElement)method, editor, (Pass)new Pass<PsiElement>(){

            public void pass(PsiElement substitutedElement) {
                final SmartPsiElementPointer pointer = SmartPointerManager.createPointer((PsiElement)method);
                MemberInplaceRenamer renamer = new MemberInplaceRenamer((PsiNamedElement)method, substitutedElement, editor){

                    protected boolean performRefactoring() {
                        if (super.performRefactoring()) {
                            ApplicationManager.getApplication().invokeLater(() -> {
                                PsiMethod restored = (PsiMethod)pointer.getElement();
                                if (restored != null) {
                                    ExtractToMethodReferenceIntention.processMethodsDuplicates(restored);
                                }
                            });
                            return true;
                        }
                        return false;
                    }
                };
                LinkedHashSet nameSuggestions = new LinkedHashSet(suggestedNames);
                renamer.performInplaceRefactoring(nameSuggestions);
            }
        });
    }

    private static void processMethodsDuplicates(PsiMethod method) {
        Project project = method.getProject();
        Runnable runnable = () -> {
            if (!method.isValid()) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass != null) {
                List<Match> duplicates = MethodDuplicatesHandler.hasDuplicates((PsiElement)containingClass, (PsiMember)method);
                Iterator<Match> iterator = duplicates.iterator();
                while (iterator.hasNext()) {
                    Match match = iterator.next();
                    PsiElement matchStart = match.getMatchStart();
                    if (!PsiTreeUtil.isAncestor((PsiElement)method, (PsiElement)matchStart, (boolean)false)) continue;
                    iterator.remove();
                    break;
                }
                if (!duplicates.isEmpty()) {
                    MethodDuplicatesHandler.replaceDuplicate(project, Collections.singletonMap(method, duplicates), Collections.singleton(method));
                }
            }
        };
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ApplicationManager.getApplication().runReadAction(runnable), MethodDuplicatesHandler.getRefactoringName(), true, project);
    }

    private static String getUniqueMethodName(PsiClass targetClass, PsiElementFactory elementFactory, PsiType functionalInterfaceType, String parameters2) {
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)functionalInterfaceType);
        String initialMethodName = interfaceMethod != null ? interfaceMethod.getName() : "name";
        return UniqueNameGenerator.generateUniqueName((String)initialMethodName, methodName -> {
            String methodText = "private void " + methodName + parameters2;
            PsiMethod patternMethod = elementFactory.createMethodFromText(methodText, (PsiElement)targetClass);
            return targetClass.findMethodBySignature(patternMethod, true) == null;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ipp/functional/ExtractToMethodReferenceIntention";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ipp/functional/ExtractToMethodReferenceIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

