/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.psiutils;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.util.PsiLiteralUtil;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;

public class ErrorUtil {
    private ErrorUtil() {
    }

    public static boolean containsError(PsiElement element) {
        return PsiUtilCore.hasErrorElementChild((PsiElement)element);
    }

    public static boolean containsDeepError(PsiElement element) {
        ErrorElementVisitor visitor2 = new ErrorElementVisitor();
        element.accept((PsiElementVisitor)visitor2);
        return visitor2.containsErrorElement();
    }

    private static class ErrorElementVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean containsErrorElement = false;

        private ErrorElementVisitor() {
        }

        public void visitErrorElement(@NotNull PsiErrorElement element) {
            if (element == null) {
                ErrorElementVisitor.$$$reportNull$$$0(0);
            }
            this.containsErrorElement = true;
            this.stopWalking();
        }

        public void visitLiteralExpression(PsiLiteralExpression literal) {
            if (PsiLiteralUtil.isUnsafeLiteral((PsiLiteralExpression)literal)) {
                this.containsErrorElement = true;
                this.stopWalking();
            }
        }

        public boolean containsErrorElement() {
            return this.containsErrorElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/psiutils/ErrorUtil$ErrorElementVisitor", "visitErrorElement"));
        }
    }
}

