/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.trivialif;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiStatement;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.trivialif.MergeIfAndPredicate;
import org.jetbrains.annotations.NotNull;

public class MergeIfAndIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        return new MergeIfAndPredicate();
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        PsiJavaToken token;
        PsiIfStatement parentStatement;
        if (element == null) {
            MergeIfAndIntention.$$$reportNull$$$0(0);
        }
        if ((parentStatement = (PsiIfStatement)(token = (PsiJavaToken)element).getParent()) == null) {
            return;
        }
        PsiStatement parentThenBranch = parentStatement.getThenBranch();
        PsiIfStatement childStatement = (PsiIfStatement)ControlFlowUtils.stripBraces(parentThenBranch);
        if (childStatement == null) {
            return;
        }
        PsiExpression childCondition = childStatement.getCondition();
        if (childCondition == null) {
            return;
        }
        PsiStatement childThenBranch = childStatement.getThenBranch();
        if (childThenBranch == null) {
            return;
        }
        PsiExpression parentCondition = parentStatement.getCondition();
        if (parentCondition == null) {
            return;
        }
        CommentTracker ct = new CommentTracker();
        String childConditionText = ParenthesesUtils.getText(ct.markUnchanged(childCondition), 14);
        String parentConditionText = ParenthesesUtils.getText(ct.markUnchanged(parentCondition), 14);
        String statement = "if(" + parentConditionText + "&&" + childConditionText + ')' + ct.text((PsiElement)childThenBranch);
        ct.replaceAndRestoreComments((PsiElement)parentStatement, statement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/trivialif/MergeIfAndIntention", "processIntention"));
    }
}

