/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.trivialif;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.trivialif.MergeIfOrPredicate;
import org.jetbrains.annotations.NotNull;

public class MergeIfOrIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        return new MergeIfOrPredicate();
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        PsiJavaToken token;
        if (element == null) {
            MergeIfOrIntention.$$$reportNull$$$0(0);
        }
        if (MergeIfOrPredicate.isMergableExplicitIf((PsiElement)(token = (PsiJavaToken)element))) {
            MergeIfOrIntention.replaceMergeableExplicitIf(token);
        } else {
            MergeIfOrIntention.replaceMergeableImplicitIf(token);
        }
    }

    private static void replaceMergeableExplicitIf(PsiJavaToken token) {
        PsiIfStatement parentStatement = (PsiIfStatement)token.getParent();
        assert (parentStatement != null);
        PsiIfStatement childStatement = (PsiIfStatement)parentStatement.getElseBranch();
        if (childStatement == null) {
            return;
        }
        PsiExpression childCondition = childStatement.getCondition();
        if (childCondition == null) {
            return;
        }
        CommentTracker tracker = new CommentTracker();
        String childConditionText = tracker.text(childCondition, 14);
        PsiExpression condition2 = parentStatement.getCondition();
        if (condition2 == null) {
            return;
        }
        String parentConditionText = tracker.text(condition2, 14);
        PsiStatement parentThenBranch = parentStatement.getThenBranch();
        if (parentThenBranch == null) {
            return;
        }
        String parentThenBranchText = tracker.text((PsiElement)parentThenBranch);
        StringBuilder statement = new StringBuilder();
        statement.append("if(");
        statement.append(parentConditionText);
        statement.append("||");
        statement.append(childConditionText);
        statement.append(')');
        statement.append(parentThenBranchText);
        PsiStatement childElseBranch = childStatement.getElseBranch();
        if (childElseBranch != null) {
            statement.append("\nelse ");
            statement.append(tracker.text((PsiElement)childElseBranch));
        }
        PsiReplacementUtil.replaceStatement((PsiStatement)parentStatement, statement.toString(), tracker);
    }

    private static void replaceMergeableImplicitIf(PsiJavaToken token) {
        PsiIfStatement parentStatement = (PsiIfStatement)token.getParent();
        PsiIfStatement childStatement = (PsiIfStatement)PsiTreeUtil.skipWhitespacesForward((PsiElement)parentStatement);
        assert (childStatement != null);
        PsiExpression childCondition = childStatement.getCondition();
        if (childCondition == null) {
            return;
        }
        CommentTracker parentTracker = new CommentTracker();
        CommentTracker childTracker = new CommentTracker();
        String childConditionText = childTracker.text(childCondition, 14);
        PsiExpression condition2 = parentStatement.getCondition();
        if (condition2 == null) {
            return;
        }
        String parentConditionText = parentTracker.text(condition2, 14);
        PsiStatement parentThenBranch = parentStatement.getThenBranch();
        if (parentThenBranch == null) {
            return;
        }
        StringBuilder newStatement = new StringBuilder();
        newStatement.append("if(");
        newStatement.append(parentConditionText);
        newStatement.append("||");
        newStatement.append(childConditionText);
        newStatement.append(')');
        newStatement.append(parentTracker.text((PsiElement)parentThenBranch));
        PsiStatement childElseBranch = childStatement.getElseBranch();
        if (childElseBranch != null) {
            newStatement.append("\nelse ");
            newStatement.append(childTracker.text((PsiElement)childElseBranch));
        }
        PsiReplacementUtil.replaceStatement((PsiStatement)parentStatement, newStatement.toString(), parentTracker);
        childTracker.deleteAndRestoreComments((PsiElement)childStatement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/trivialif/MergeIfOrIntention", "processIntention"));
    }
}

