/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.generate.inspection;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.RegExFormatter;
import com.intellij.codeInspection.ui.RegExInputVerifier;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.ui.CheckBox;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.generate.GenerateToStringContext;
import org.jetbrains.java.generate.GenerateToStringUtils;
import org.jetbrains.java.generate.inspection.AbstractToStringInspection;

public class ClassHasNoToStringMethodInspection
extends AbstractToStringInspection {
    public String excludeClassNames = "";
    private Pattern excludeClassNamesPattern;
    public boolean excludeException = true;
    public boolean excludeDeprecated = true;
    public boolean excludeEnum;
    public boolean excludeAbstract;
    public boolean excludeTestCode;
    public boolean excludeInnerClasses;

    @NotNull
    public String getShortName() {
        return "ClassHasNoToStringMethod";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            ClassHasNoToStringMethodInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(){

            public void visitClass(PsiClass clazz) {
                PsiMethod[] superMethods;
                PsiMethod[] toStringMethods;
                PsiField[] fields;
                PsiIdentifier nameIdentifier;
                if (AbstractToStringInspection.log.isDebugEnabled()) {
                    AbstractToStringInspection.log.debug("checkClass: clazz=" + clazz);
                }
                if ((nameIdentifier = clazz.getNameIdentifier()) == null || clazz.getName() == null) {
                    return;
                }
                if (ClassHasNoToStringMethodInspection.this.excludeException && InheritanceUtil.isInheritor((PsiClass)clazz, (String)"java.lang.Throwable")) {
                    return;
                }
                if (ClassHasNoToStringMethodInspection.this.excludeDeprecated && clazz.isDeprecated()) {
                    return;
                }
                if (ClassHasNoToStringMethodInspection.this.excludeEnum && clazz.isEnum()) {
                    return;
                }
                if (ClassHasNoToStringMethodInspection.this.excludeAbstract && clazz.hasModifierProperty("abstract")) {
                    return;
                }
                if (ClassHasNoToStringMethodInspection.this.excludeTestCode && TestFrameworks.getInstance().isTestClass(clazz)) {
                    return;
                }
                if (ClassHasNoToStringMethodInspection.this.excludeInnerClasses && clazz.getContainingClass() != null) {
                    return;
                }
                if (ClassHasNoToStringMethodInspection.this.excludeClassNamesPattern != null) {
                    try {
                        String name2 = clazz.getName();
                        if (name2 != null && ClassHasNoToStringMethodInspection.this.excludeClassNamesPattern.matcher(name2).matches()) {
                            return;
                        }
                    }
                    catch (PatternSyntaxException name2) {
                        // empty catch block
                    }
                }
                if ((fields = clazz.getFields()).length == 0) {
                    return;
                }
                fields = GenerateToStringUtils.filterAvailableFields(clazz, GenerateToStringContext.getConfig().getFilterPattern());
                PsiMethod[] methods = null;
                if (GenerateToStringContext.getConfig().isEnableMethods()) {
                    methods = GenerateToStringUtils.filterAvailableMethods(clazz, GenerateToStringContext.getConfig().getFilterPattern());
                }
                if (Math.max(fields.length, methods == null ? 0 : methods.length) == 0) {
                    return;
                }
                for (PsiMethod method : toStringMethods = clazz.findMethodsByName("toString", false)) {
                    PsiParameterList parameterList = method.getParameterList();
                    if (!parameterList.isEmpty()) continue;
                    return;
                }
                for (PsiMethod method : superMethods = clazz.findMethodsByName("toString", true)) {
                    PsiParameterList parameterList = method.getParameterList();
                    if (!parameterList.isEmpty() || !method.hasModifierProperty("final")) continue;
                    return;
                }
                holder.registerProblem((PsiElement)nameIdentifier, JavaAnalysisBundle.message((String)"inspection.class.has.no.to.string.method.description", (Object[])new Object[]{clazz.getName()}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, AbstractToStringInspection.createFixes(holder));
            }
        };
    }

    public JComponent createOptionsPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        constraints.anchor = 17;
        constraints.fill = 0;
        panel2.add((Component)new JLabel(JavaAnalysisBundle.message((String)"inspection.class.has.no.to.string.method.exclude.classes.reg.exp.option", (Object[])new Object[0])), constraints);
        final JFormattedTextField excludeClassNamesField = new JFormattedTextField((JFormattedTextField.AbstractFormatter)new RegExFormatter());
        excludeClassNamesField.setValue(this.excludeClassNamesPattern);
        excludeClassNamesField.setColumns(25);
        excludeClassNamesField.setInputVerifier((InputVerifier)new RegExInputVerifier());
        excludeClassNamesField.setFocusLostBehavior(0);
        excludeClassNamesField.setMinimumSize(excludeClassNamesField.getPreferredSize());
        UIUtil.fixFormattedField((JFormattedTextField)excludeClassNamesField);
        Document document = excludeClassNamesField.getDocument();
        document.addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                try {
                    excludeClassNamesField.commitEdit();
                    ClassHasNoToStringMethodInspection.this.excludeClassNamesPattern = (Pattern)excludeClassNamesField.getValue();
                    ClassHasNoToStringMethodInspection.this.excludeClassNames = ClassHasNoToStringMethodInspection.this.excludeClassNamesPattern.pattern();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/java/generate/inspection/ClassHasNoToStringMethodInspection$2", "textChanged"));
            }
        });
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 18;
        constraints.fill = 0;
        panel2.add((Component)excludeClassNamesField, constraints);
        CheckBox excludeExceptionCheckBox = new CheckBox(JavaAnalysisBundle.message((String)"inspection.class.has.no.to.string.method.ignore.exception.classes.option", (Object[])new Object[0]), (InspectionProfileEntry)this, "excludeException");
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 2;
        constraints.fill = 2;
        panel2.add((Component)excludeExceptionCheckBox, constraints);
        CheckBox excludeDeprecatedCheckBox = new CheckBox(JavaAnalysisBundle.message((String)"inspection.class.has.no.to.string.method.ignore.deprecated.classes.option", (Object[])new Object[0]), (InspectionProfileEntry)this, "excludeDeprecated");
        constraints.gridy = 2;
        panel2.add((Component)excludeDeprecatedCheckBox, constraints);
        CheckBox excludeEnumCheckBox = new CheckBox(JavaAnalysisBundle.message((String)"inspection.class.has.no.to.string.method.ignore.enum.classes.option", (Object[])new Object[0]), (InspectionProfileEntry)this, "excludeEnum");
        constraints.gridy = 3;
        panel2.add((Component)excludeEnumCheckBox, constraints);
        CheckBox excludeAbstractCheckBox = new CheckBox(JavaAnalysisBundle.message((String)"inspection.class.has.no.to.string.method.ignore.abstract.classes.option", (Object[])new Object[0]), (InspectionProfileEntry)this, "excludeAbstract");
        constraints.gridy = 4;
        panel2.add((Component)excludeAbstractCheckBox, constraints);
        CheckBox excludeInTestCodeCheckBox = new CheckBox(JavaAnalysisBundle.message((String)"inspection.class.has.no.to.string.method.ignore.test.classes.option", (Object[])new Object[0]), (InspectionProfileEntry)this, "excludeTestCode");
        constraints.gridy = 5;
        panel2.add((Component)excludeInTestCodeCheckBox, constraints);
        CheckBox excludeInnerClasses = new CheckBox(JavaAnalysisBundle.message((String)"inspection.class.has.no.to.string.method.ignore.inner.classes.option", (Object[])new Object[0]), (InspectionProfileEntry)this, "excludeInnerClasses");
        constraints.gridy = 6;
        constraints.weighty = 1.0;
        panel2.add((Component)excludeInnerClasses, constraints);
        return panel2;
    }

    public void readSettings(@NotNull Element node) {
        if (node == null) {
            ClassHasNoToStringMethodInspection.$$$reportNull$$$0(1);
        }
        super.readSettings(node);
        try {
            this.excludeClassNamesPattern = Pattern.compile(this.excludeClassNames);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/java/generate/inspection/ClassHasNoToStringMethodInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "readSettings";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

