/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.generate.view;

import com.intellij.java.JavaBundle;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.util.LocalTimeCounter;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.java.generate.element.ClassElement;
import org.jetbrains.java.generate.element.FieldElement;
import org.jetbrains.java.generate.element.GenerationHelper;
import org.jetbrains.java.generate.template.TemplateResource;
import org.jetbrains.java.generate.template.TemplatesManager;

public class GenerateTemplateConfigurable
implements UnnamedConfigurable {
    private final TemplateResource template;
    private final Editor myEditor;
    private final List<String> availableImplicits = new ArrayList<String>();
    private String myHint;

    public GenerateTemplateConfigurable(TemplateResource template, Map<String, PsiType> contextMap, Project project) {
        this(template, contextMap, project, true);
    }

    public GenerateTemplateConfigurable(TemplateResource template, Map<String, PsiType> contextMap, Project project, boolean multipleFields) {
        this.template = template;
        EditorFactory factory = EditorFactory.getInstance();
        Document doc = factory.createDocument((CharSequence)template.getTemplate());
        FileType ftl = FileTypeManager.getInstance().findFileTypeByName("VTL");
        if (project != null && ftl != null) {
            Document document;
            PsiFile file = PsiFileFactory.getInstance((Project)project).createFileFromText(template.getFileName(), ftl, (CharSequence)template.getTemplate(), LocalTimeCounter.currentTime(), true);
            if (!template.isDefault()) {
                LinkedHashMap<String, Object> map2 = new LinkedHashMap<String, Object>();
                map2.put("java_version", PsiType.INT);
                map2.put("class", TemplatesManager.createElementType(project, ClassElement.class));
                if (multipleFields) {
                    map2.put("fields", TemplatesManager.createFieldListElementType(project));
                } else {
                    map2.put("field", TemplatesManager.createElementType(project, FieldElement.class));
                }
                map2.put("helper", TemplatesManager.createElementType(project, GenerationHelper.class));
                map2.put("settings", TemplatesManager.createElementType(project, JavaCodeStyleSettings.class));
                map2.putAll(contextMap);
                this.availableImplicits.addAll(((HashMap)map2).keySet());
                file.getViewProvider().putUserData(TemplatesManager.TEMPLATE_IMPLICITS, map2);
            }
            if ((document = PsiDocumentManager.getInstance((Project)project).getDocument(file)) != null) {
                doc = document;
            }
        }
        this.myEditor = factory.createEditor(doc, project, (FileType)(ftl != null ? ftl : FileTypes.PLAIN_TEXT), template.isDefault());
    }

    public void setHint(String hint) {
        this.myHint = hint;
    }

    public JComponent createComponent() {
        JComponent component = this.myEditor.getComponent();
        if (this.availableImplicits.isEmpty() && this.myHint == null) {
            return component;
        }
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)component, "Center");
        String availableVariables = JavaBundle.message((String)"generate.tostring.available.implicit.variables.label", (Object[])new Object[]{StringUtil.join(this.availableImplicits, (String)", ")});
        JLabel label = new JLabel(XmlStringUtil.wrapInHtml((CharSequence)((!this.availableImplicits.isEmpty() ? availableVariables + "<br/>" : "") + (this.myHint != null ? this.myHint : ""))));
        panel2.add((Component)label, "South");
        return panel2;
    }

    public boolean isModified() {
        return !Comparing.equal((String)this.myEditor.getDocument().getText(), (String)this.template.getTemplate());
    }

    public void apply() throws ConfigurationException {
        this.template.setTemplate(this.myEditor.getDocument().getText());
    }

    public void reset() {
        WriteCommandAction.writeCommandAction(null).run(() -> this.myEditor.getDocument().setText((CharSequence)this.template.getTemplate()));
    }

    public void disposeUIResources() {
        EditorFactory.getInstance().releaseEditor(this.myEditor);
    }
}

