/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.lang.manifest.highlighting;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.lang.manifest.ManifestBundle;
import org.jetbrains.lang.manifest.highlighting.AbstractManifestQuickFix;
import org.jetbrains.lang.manifest.psi.Header;
import org.jetbrains.lang.manifest.psi.ManifestFile;
import org.jetbrains.lang.manifest.psi.ManifestTokenType;
import org.jetbrains.lang.manifest.psi.Section;

public class MissingFinalNewlineInspection
extends LocalInspectionTool {
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        String text2;
        if (file == null) {
            MissingFinalNewlineInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            MissingFinalNewlineInspection.$$$reportNull$$$0(1);
        }
        if (file instanceof ManifestFile && (text2 = file.getText()) != null && text2.length() > 0 && !StringUtil.endsWith((CharSequence)text2, (CharSequence)"\n")) {
            List<Section> sections = ((ManifestFile)file).getSections();
            assert (sections.size() > 0) : text2;
            Section section = sections.get(sections.size() - 1);
            ProblemDescriptor descriptor = manager.createProblemDescriptor(section.getLastChild(), ManifestBundle.message("inspection.newline.message", new Object[0]), (LocalQuickFix)new AddNewlineQuickFix(section), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly);
            return new ProblemDescriptor[]{descriptor};
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/lang/manifest/highlighting/MissingFinalNewlineInspection";
        objectArray[2] = "checkFile";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class AddNewlineQuickFix
    extends AbstractManifestQuickFix {
        private AddNewlineQuickFix(Section section) {
            super(section);
        }

        @NotNull
        public String getText() {
            String string = ManifestBundle.message("inspection.newline.fix", new Object[0]);
            if (string == null) {
                AddNewlineQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            PsiElement lastChild;
            if (project == null) {
                AddNewlineQuickFix.$$$reportNull$$$0(1);
            }
            if (file == null) {
                AddNewlineQuickFix.$$$reportNull$$$0(2);
            }
            if (startElement == null) {
                AddNewlineQuickFix.$$$reportNull$$$0(3);
            }
            if (endElement == null) {
                AddNewlineQuickFix.$$$reportNull$$$0(4);
            }
            if ((lastChild = startElement.getLastChild()) instanceof Header) {
                lastChild.getNode().addLeaf((IElementType)ManifestTokenType.NEWLINE, (CharSequence)"\n", null);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/lang/manifest/highlighting/MissingFinalNewlineInspection$AddNewlineQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/lang/manifest/highlighting/MissingFinalNewlineInspection$AddNewlineQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

