/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.config.UserConfig;
import org.languagetool.language.English;
import org.languagetool.language.Language;
import org.languagetool.rules.Rule;
import org.languagetool.rules.en.replace.BritishReplaceRule;
import org.languagetool.rules.en.speller.MorfologikBritishSpellerRule;
import org.languagetool.rules.en.unit.UnitConversionRuleImperial;
import org.languagetool.rules.spelling.SpellingCheckRule;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J8\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u000e\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u0010H\u0016J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\t\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lorg/languagetool/language/BritishEnglish;", "Lorg/languagetool/language/English;", "()V", "countries", "", "", "getCountries", "()[Ljava/lang/String;", "[Ljava/lang/String;", "name", "getName", "()Ljava/lang/String;", "getPriorityForId", "", "id", "getRelevantRules", "", "Lorg/languagetool/rules/Rule;", "messages", "Ljava/util/ResourceBundle;", "userConfig", "Lorg/languagetool/config/UserConfig;", "motherTongue", "Lorg/languagetool/language/Language;", "altLanguages", "getSpellchecker", "Lorg/languagetool/rules/spelling/SpellingCheckRule;", "en"})
public final class BritishEnglish
extends English {
    @NotNull
    private final String[] countries = new String[]{"GB"};
    @NotNull
    private final String name = "English (GB)";

    @Override
    @NotNull
    public String[] getCountries() {
        return this.countries;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public List<Rule> getRelevantRules(@NotNull ResourceBundle messages, @NotNull UserConfig userConfig, @Nullable Language motherTongue, @NotNull List<? extends Language> altLanguages) {
        Intrinsics.checkParameterIsNotNull((Object)messages, (String)"messages");
        Intrinsics.checkParameterIsNotNull((Object)userConfig, (String)"userConfig");
        Intrinsics.checkParameterIsNotNull(altLanguages, (String)"altLanguages");
        ArrayList<Object> rules = new ArrayList<Object>((Collection)super.getRelevantRules(messages, userConfig, motherTongue, altLanguages));
        rules.add((Object)new BritishReplaceRule(messages, this));
        rules.add((Object)new UnitConversionRuleImperial(messages, this));
        return rules;
    }

    @Nullable
    public SpellingCheckRule getSpellchecker(@NotNull ResourceBundle messages, @NotNull UserConfig userConfig) {
        Intrinsics.checkParameterIsNotNull((Object)messages, (String)"messages");
        Intrinsics.checkParameterIsNotNull((Object)userConfig, (String)"userConfig");
        return (SpellingCheckRule)new MorfologikBritishSpellerRule(messages, this, userConfig, CollectionsKt.emptyList());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getPriorityForId(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        String string = id;
        switch (string.hashCode()) {
            case -1092552730: {
                if (!string.equals("OXFORD_SPELLING_ISE_VERBS")) return super.getPriorityForId(id);
                return -21;
            }
            case 1440548714: {
                if (!string.equals("OXFORD_SPELLING_IZE")) return super.getPriorityForId(id);
                return -22;
            }
            case 110126299: {
                if (!string.equals("OXFORD_SPELLING_ISATION_NOUNS")) return super.getPriorityForId(id);
                return -20;
            }
        }
        return super.getPriorityForId(id);
    }
}

