/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.languagetool.language.Language;
import org.languagetool.rules.AbstractWordCoherencyRule;
import org.languagetool.rules.Example;
import org.languagetool.rules.WordCoherencyDataLoader;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\"\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\u0018\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bH\u0014J\u001a\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000f0\u000eH\u0014\u00a8\u0006\u0011"}, d2={"Lorg/languagetool/rules/en/WordCoherencyRule;", "Lorg/languagetool/rules/AbstractWordCoherencyRule;", "messages", "Ljava/util/ResourceBundle;", "language", "Lorg/languagetool/language/Language;", "(Ljava/util/ResourceBundle;Lorg/languagetool/language/Language;)V", "getDescription", "", "getId", "getMessage", "word1", "word2", "getWordMap", "", "", "Companion", "en"})
public final class WordCoherencyRule
extends AbstractWordCoherencyRule {
    private static final Map<String, Set<String>> wordMap;
    public static final Companion Companion;

    @NotNull
    protected Map<String, Set<String>> getWordMap() {
        Map<String, Set<String>> map = wordMap;
        Intrinsics.checkExpressionValueIsNotNull(map, (String)"WordCoherencyRule.wordMap");
        return map;
    }

    @NotNull
    protected String getMessage(@NotNull String word1, @NotNull String word2) {
        Intrinsics.checkParameterIsNotNull((Object)word1, (String)"word1");
        Intrinsics.checkParameterIsNotNull((Object)word2, (String)"word2");
        return "Do not mix variants of the same word ('" + word1 + "' and '" + word2 + "') within a single text.";
    }

    @NotNull
    public String getId() {
        return "EN_WORD_COHERENCY";
    }

    @NotNull
    public String getDescription() {
        return "Coherent spelling of words with two admitted variants.";
    }

    public WordCoherencyRule(@NotNull ResourceBundle messages, @NotNull Language language) {
        Intrinsics.checkParameterIsNotNull((Object)messages, (String)"messages");
        Intrinsics.checkParameterIsNotNull((Object)language, (String)"language");
        super(messages, language);
        this.addExamplePair(Example.wrong((String)"He likes archaeology. Really? She likes <marker>archeology</marker>, too."), Example.fixed((String)"He likes archaeology. Really? She likes <marker>archaeology</marker>, too."));
    }

    static {
        Companion = new Companion(null);
        wordMap = new WordCoherencyDataLoader().loadWords("/en/coherency.txt");
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010#\n\u0002\u0010\"\n\u0002\u0010$\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0086\u0001\u0010\u0003\u001az\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012(\u0012&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\b0\u0007 \u0006*<\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012(\u0012&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\b0\u0007\u0018\u00010\t0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/languagetool/rules/en/WordCoherencyRule$Companion;", "", "()V", "wordMap", "", "", "kotlin.jvm.PlatformType", "", "", "", "en"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

