/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.repositorycrawler;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.archetype.catalog.ArchetypeCatalog;
import org.apache.maven.archetype.catalog.io.xpp3.ArchetypeCatalogXpp3Writer;
import org.apache.maven.archetype.common.ArchetypeArtifactManager;
import org.apache.maven.archetype.exception.UnknownArchetype;
import org.apache.maven.archetype.old.descriptor.ArchetypeDescriptor;
import org.apache.maven.archetype.repositorycrawler.RepositoryCrawler;
import org.apache.maven.model.Model;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class DefaultRepositoryCrawler
extends AbstractLogEnabled
implements RepositoryCrawler {
    private ArchetypeArtifactManager archetypeArtifactManager;

    public ArchetypeCatalog crawl(File repository) {
        if (repository.isDirectory()) {
            ArchetypeCatalog catalog = new ArchetypeCatalog();
            Iterator jars = FileUtils.listFiles((File)repository, (String[])new String[]{"jar"}, (boolean)true).iterator();
            while (jars.hasNext()) {
                File jar = (File)jars.next();
                this.getLogger().info("Scanning " + jar);
                if (!this.archetypeArtifactManager.isFileSetArchetype(jar) && !this.archetypeArtifactManager.isOldArchetype(jar)) continue;
                try {
                    Object descriptor;
                    Archetype archetype = new Archetype();
                    Model pom = this.archetypeArtifactManager.getArchetypePom(jar);
                    if (this.archetypeArtifactManager.isFileSetArchetype(jar)) {
                        descriptor = this.archetypeArtifactManager.getFileSetArchetypeDescriptor(jar);
                        archetype.setDescription(((org.apache.maven.archetype.metadata.ArchetypeDescriptor)descriptor).getName());
                    } else {
                        descriptor = this.archetypeArtifactManager.getOldArchetypeDescriptor(jar);
                        archetype.setDescription(((ArchetypeDescriptor)descriptor).getId());
                    }
                    if (pom != null) {
                        if (pom.getGroupId() != null) {
                            archetype.setGroupId(pom.getGroupId());
                        } else {
                            archetype.setGroupId(pom.getParent().getGroupId());
                        }
                        archetype.setArtifactId(pom.getArtifactId());
                        if (pom.getVersion() != null) {
                            archetype.setVersion(pom.getVersion());
                        } else {
                            archetype.setVersion(pom.getParent().getVersion());
                        }
                        this.getLogger().info("\tArchetype " + archetype + " found in pom");
                    } else {
                        String version = jar.getParentFile().getName();
                        String artifactId = jar.getParentFile().getParentFile().getName();
                        String groupIdSep = StringUtils.replace((String)jar.getParentFile().getParentFile().getParentFile().getPath(), (String)repository.getPath(), (String)"");
                        String groupId = groupIdSep.replace(File.separatorChar, '.');
                        groupId = groupId.startsWith(".") ? groupId.substring(1) : groupId;
                        groupId = groupId.endsWith(".") ? groupId.substring(0, groupId.length() - 1) : groupId;
                        archetype.setGroupId(groupId);
                        archetype.setArtifactId(artifactId);
                        archetype.setVersion(version);
                        this.getLogger().info("\tArchetype " + archetype + " defined by repository path");
                    }
                    catalog.addArchetype(archetype);
                }
                catch (XmlPullParserException ex) {
                    ex.printStackTrace();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                catch (UnknownArchetype ex) {
                    ex.printStackTrace();
                }
            }
            return catalog;
        }
        this.getLogger().warn("File is not a directory");
        return null;
    }

    public boolean writeCatalog(ArchetypeCatalog archetypeCatalog, File archetypeCatalogFile) {
        try {
            ArchetypeCatalogXpp3Writer catalogWriter = new ArchetypeCatalogXpp3Writer();
            catalogWriter.write(new FileWriter(archetypeCatalogFile), archetypeCatalog);
            return true;
        }
        catch (IOException ex) {
            this.getLogger().warn("Catalog can not be writen to " + archetypeCatalogFile, (Throwable)ex);
            return false;
        }
    }
}

