/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommandLineInspectionProgressReporter;
import com.intellij.codeInspection.CommandLineInspectionProjectConfigurator;
import com.intellij.openapi.externalSystem.importing.ImportSpecBuilder;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.util.io.PathKt;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/gradle/GradleCommandLineProjectConfigurator;", "Lcom/intellij/codeInspection/CommandLineInspectionProjectConfigurator;", "()V", "wasAlreadyImported", "", "configureEnvironment", "", "projectPath", "Ljava/nio/file/Path;", "logger", "Lcom/intellij/codeInspection/CommandLineInspectionProgressReporter;", "configureProject", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lcom/intellij/analysis/AnalysisScope;", "isApplicable", "intellij.gradle.common"})
public final class GradleCommandLineProjectConfigurator
implements CommandLineInspectionProjectConfigurator {
    private boolean wasAlreadyImported;

    public boolean isApplicable(@NotNull Path projectPath, @NotNull CommandLineInspectionProgressReporter logger) {
        Intrinsics.checkParameterIsNotNull((Object)projectPath, (String)"projectPath");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        return true;
    }

    public void configureEnvironment(@NotNull Path projectPath, @NotNull CommandLineInspectionProgressReporter logger) {
        Intrinsics.checkParameterIsNotNull((Object)projectPath, (String)"projectPath");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Path path = projectPath.resolve(".idea");
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"projectPath.resolve(\".idea\")");
        this.wasAlreadyImported = PathKt.exists((Path)path);
    }

    public void configureProject(@NotNull Project project, @NotNull AnalysisScope scope, @NotNull CommandLineInspectionProgressReporter logger) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        if (this.wasAlreadyImported) {
            ExternalSystemUtil.refreshProjects((ImportSpecBuilder)new ImportSpecBuilder(project, GradleConstants.SYSTEM_ID).use(ProgressExecutionMode.MODAL_SYNC));
        }
    }
}

