/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution;

import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.impl.FinishEventImpl;
import com.intellij.build.events.impl.ProgressBuildEventImpl;
import com.intellij.build.events.impl.StartEventImpl;
import com.intellij.build.events.impl.SuccessResultImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemBuildEvent;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemExecutionAware;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkException;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ui.configuration.projectRoot.SdkDownloadTracker;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Consumer;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionAware;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleBundle;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Y\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001\u0004\u0018\u0000  2\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010\tJ\u001e\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J0\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J(\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J(\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001c\u0010\u001b\u001a\u00020\u0011*\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001c\u0010\u001e\u001a\u00020\u0011*\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001c\u0010\u001f\u001a\u00020\u0011*\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u00a8\u0006!"}, d2={"Lorg/jetbrains/plugins/gradle/service/execution/GradleExecutionAware;", "Lcom/intellij/openapi/externalSystem/service/execution/ExternalSystemExecutionAware;", "()V", "createProgressIndicator", "org/jetbrains/plugins/gradle/service/execution/GradleExecutionAware$createProgressIndicator$1", "taskId", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "taskNotificationListener", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskNotificationListener;", "(Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskNotificationListener;)Lorg/jetbrains/plugins/gradle/service/execution/GradleExecutionAware$createProgressIndicator$1;", "jdkConfigurationError", "", "key", "", "cause", "", "prepareExecution", "", "externalProjectPath", "isPreviewMode", "", "project", "Lcom/intellij/openapi/project/Project;", "prepareJvmForExecution", "waitForDownloadingIfNeeded", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "submitProgressFinished", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "submitProgressStarted", "submitProgressStatus", "Companion", "intellij.gradle.common"})
public final class GradleExecutionAware
implements ExternalSystemExecutionAware {
    private static final Logger LOG;
    public static final Companion Companion;

    public void prepareExecution(@NotNull ExternalSystemTaskId taskId, @NotNull String externalProjectPath, boolean isPreviewMode, @NotNull ExternalSystemTaskNotificationListener taskNotificationListener, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)taskId, (String)"taskId");
        Intrinsics.checkParameterIsNotNull((Object)externalProjectPath, (String)"externalProjectPath");
        Intrinsics.checkParameterIsNotNull((Object)taskNotificationListener, (String)"taskNotificationListener");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (!isPreviewMode) {
            this.prepareJvmForExecution(taskId, externalProjectPath, taskNotificationListener, project);
        }
    }

    private final void prepareJvmForExecution(ExternalSystemTaskId taskId, String externalProjectPath, ExternalSystemTaskNotificationListener taskNotificationListener, Project project) {
        Sdk sdk;
        GradleSettings gradleSettings = GradleSettings.getInstance(project);
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)gradleSettings), (String)"GradleSettings.getInstance(project)");
        GradleSettings settings = gradleSettings;
        GradleProjectSettings gradleProjectSettings = (GradleProjectSettings)settings.getLinkedProjectSettings(externalProjectPath);
        if (gradleProjectSettings == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)gradleProjectSettings), (String)"settings.getLinkedProjec\u2026nalProjectPath) ?: return");
        GradleProjectSettings projectSettings = gradleProjectSettings;
        String string = projectSettings.getGradleJvm();
        if (string == null) {
            Void void_ = GradleExecutionAware.jdkConfigurationError$default(this, "gradle.jvm.is.invalid", null, 2, null);
            throw null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"projectSettings.gradleJv\u2026(\"gradle.jvm.is.invalid\")");
        String gradleJvm = string;
        try {
            Sdk sdk2 = ExternalSystemJdkUtil.getJdk((Project)project, (String)gradleJvm);
            if (sdk2 == null) {
                Void void_ = GradleExecutionAware.jdkConfigurationError$default(this, "gradle.jvm.is.invalid", null, 2, null);
                throw null;
            }
            sdk = sdk2;
        }
        catch (ExternalSystemJdkException e) {
            Void void_ = GradleExecutionAware.jdkConfigurationError$default(this, "gradle.jvm.is.invalid", null, 2, null);
            throw null;
        }
        Sdk sdk3 = sdk;
        Intrinsics.checkExpressionValueIsNotNull((Object)sdk3, (String)"try {\n      ExternalSyst\u2026le.jvm.is.invalid\")\n    }");
        Sdk sdk4 = sdk3;
        this.waitForDownloadingIfNeeded(sdk4, taskId, taskNotificationListener, project);
        if (!ExternalSystemJdkUtil.isValidJdk((Sdk)sdk4)) {
            String string2 = sdk4.getHomePath();
            if (string2 == null) {
                Void void_ = GradleExecutionAware.jdkConfigurationError$default(this, "gradle.jvm.is.invalid", null, 2, null);
                throw null;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"sdk.homePath ?: jdkConfi\u2026(\"gradle.jvm.is.invalid\")");
            String sdkHomePath = string2;
            if (JdkUtil.checkForJre((String)sdkHomePath)) {
                Void void_ = GradleExecutionAware.jdkConfigurationError$default(this, "gradle.jvm.is.jre", null, 2, null);
                throw null;
            }
            Void void_ = GradleExecutionAware.jdkConfigurationError$default(this, "gradle.jvm.is.invalid", null, 2, null);
            throw null;
        }
    }

    private final Void jdkConfigurationError(@PropertyKey(resourceBundle="messages.GradleBundle") String key, Throwable cause) {
        String errorMessage = GradleBundle.message(key, new Object[0]);
        String openSettingsMessage = GradleBundle.message("gradle.open.gradle.settings", new Object[0]);
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = errorMessage + " <a href='%s'>" + openSettingsMessage + "</a> \n";
        Object[] objectArray = new Object[]{"#open_external_system_settings"};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
        String exceptionMessage = string2;
        throw (Throwable)new ExternalSystemJdkException(exceptionMessage, cause, new String[]{"#open_external_system_settings"});
    }

    static /* synthetic */ Void jdkConfigurationError$default(GradleExecutionAware gradleExecutionAware, String string, Throwable throwable, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        return gradleExecutionAware.jdkConfigurationError(string, throwable);
    }

    private final void waitForDownloadingIfNeeded(Sdk sdk, ExternalSystemTaskId taskId, ExternalSystemTaskNotificationListener taskNotificationListener, Project project) {
        SdkDownloadTracker sdkDownloadTracker = SdkDownloadTracker.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)sdkDownloadTracker, (String)"SdkDownloadTracker.getInstance()");
        SdkDownloadTracker downloadTracker = sdkDownloadTracker;
        createProgressIndicator.1 progressIndicator = this.createProgressIndicator(taskId, taskNotificationListener);
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Disposable disposable2 = new Disposable(countDownLatch){
            final /* synthetic */ CountDownLatch $countDownLatch;

            public final void dispose() {
                this.$countDownLatch.countDown();
            }
            {
                this.$countDownLatch = countDownLatch;
            }
        };
        boolean isDownloadingInProgress2 = (Boolean)ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)((Function0)new Function0<Boolean>(downloadTracker, sdk, project, progressIndicator, disposable2){
            final /* synthetic */ SdkDownloadTracker $downloadTracker;
            final /* synthetic */ Sdk $sdk;
            final /* synthetic */ Project $project;
            final /* synthetic */ createProgressIndicator.1 $progressIndicator;
            final /* synthetic */ Disposable $disposable;

            public final boolean invoke() {
                return this.$downloadTracker.tryRegisterDownloadingListener(this.$sdk, (Disposable)this.$project, (ProgressIndicator)this.$progressIndicator, (Consumer)new Consumer<Boolean>(this){
                    final /* synthetic */ waitForDownloadingIfNeeded.isDownloadingInProgress.1 this$0;

                    public final void consume(Boolean it) {
                        Disposer.dispose((Disposable)this.this$0.$disposable);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$downloadTracker = sdkDownloadTracker;
                this.$sdk = sdk;
                this.$project = project;
                this.$progressIndicator = var4_4;
                this.$disposable = disposable2;
                super(0);
            }
        }), (int)1, null);
        if (!isDownloadingInProgress2) {
            return;
        }
        Disposer.register((Disposable)((Disposable)project), (Disposable)disposable2);
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isDispatchThread()) {
            LOG.error("Do not perform synchronous wait for sdk downloading in EDT - causes deadlock.");
            Void void_ = GradleExecutionAware.jdkConfigurationError$default(this, "gradle.jvm.is.downloading", null, 2, null);
            throw null;
        }
        this.submitProgressStarted(taskNotificationListener, taskId, (ProgressIndicator)progressIndicator);
        countDownLatch.await();
        this.submitProgressFinished(taskNotificationListener, taskId, (ProgressIndicator)progressIndicator);
    }

    private final createProgressIndicator.1 createProgressIndicator(ExternalSystemTaskId taskId, ExternalSystemTaskNotificationListener taskNotificationListener) {
        return new AbstractProgressIndicatorExBase(this, taskNotificationListener, taskId){
            final /* synthetic */ GradleExecutionAware this$0;
            final /* synthetic */ ExternalSystemTaskNotificationListener $taskNotificationListener;
            final /* synthetic */ ExternalSystemTaskId $taskId;

            public void setFraction(double fraction) {
                super.setFraction(fraction);
                GradleExecutionAware.access$submitProgressStatus(this.this$0, this.$taskNotificationListener, this.$taskId, (ProgressIndicator)this);
            }
            {
                this.this$0 = $outer;
                this.$taskNotificationListener = $captured_local_variable$1;
                this.$taskId = $captured_local_variable$2;
            }
        };
    }

    private final void submitProgressStarted(@NotNull ExternalSystemTaskNotificationListener $this$submitProgressStarted, ExternalSystemTaskId taskId, ProgressIndicator progressIndicator) {
        StartEventImpl buildEvent = new StartEventImpl((Object)progressIndicator, (Object)taskId, System.currentTimeMillis(), progressIndicator.getText());
        ExternalSystemBuildEvent notificationEvent = new ExternalSystemBuildEvent(taskId, (BuildEvent)buildEvent);
        $this$submitProgressStarted.onStatusChange((ExternalSystemTaskNotificationEvent)notificationEvent);
    }

    private final void submitProgressFinished(@NotNull ExternalSystemTaskNotificationListener $this$submitProgressFinished, ExternalSystemTaskId taskId, ProgressIndicator progressIndicator) {
        SuccessResultImpl result = new SuccessResultImpl();
        FinishEventImpl buildEvent = new FinishEventImpl((Object)progressIndicator, (Object)taskId, System.currentTimeMillis(), progressIndicator.getText(), (EventResult)result);
        ExternalSystemBuildEvent notificationEvent = new ExternalSystemBuildEvent(taskId, (BuildEvent)buildEvent);
        $this$submitProgressFinished.onStatusChange((ExternalSystemTaskNotificationEvent)notificationEvent);
    }

    private final void submitProgressStatus(@NotNull ExternalSystemTaskNotificationListener $this$submitProgressStatus, ExternalSystemTaskId taskId, ProgressIndicator progressIndicator) {
        long progress = (long)(progressIndicator.getFraction() * (double)100);
        ProgressBuildEventImpl buildEvent = new ProgressBuildEventImpl((Object)progressIndicator, (Object)taskId, System.currentTimeMillis(), progressIndicator.getText(), 100L, progress, "%");
        ExternalSystemBuildEvent notificationEvent = new ExternalSystemBuildEvent(taskId, (BuildEvent)buildEvent);
        $this$submitProgressStatus.onStatusChange((ExternalSystemTaskNotificationEvent)notificationEvent);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(GradleExecutionAware.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Gradl\u2026ecutionAware::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ void access$submitProgressStatus(GradleExecutionAware $this, ExternalSystemTaskNotificationListener $this$access_u24submitProgressStatus, ExternalSystemTaskId taskId, ProgressIndicator progressIndicator) {
        $this.submitProgressStatus($this$access_u24submitProgressStatus, taskId, progressIndicator);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/gradle/service/execution/GradleExecutionAware$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.gradle.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

