/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.editor;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.editor.TextMateEditorUtils;
import org.jetbrains.plugins.textmate.language.TextMateFileType;
import org.jetbrains.plugins.textmate.language.preferences.TextMateBracePair;

public class TextMateTypedHandler
extends TypedHandlerDelegate {
    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull FileType fileType) {
        if (project == null) {
            TextMateTypedHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            TextMateTypedHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            TextMateTypedHandler.$$$reportNull$$$0(2);
        }
        if (fileType == null) {
            TextMateTypedHandler.$$$reportNull$$$0(3);
        }
        if (fileType == TextMateFileType.INSTANCE) {
            if (c == '\'' || c == '\"' || c == '`') {
                if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_QUOTE) {
                    TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                    if (result == null) {
                        TextMateTypedHandler.$$$reportNull$$$0(4);
                    }
                    return result;
                }
            } else if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    TextMateTypedHandler.$$$reportNull$$$0(5);
                }
                return result;
            }
            int offset = editor.getCaretModel().getOffset();
            CharSequence scopeSelector = TextMateEditorUtils.getCurrentScopeSelector((EditorEx)editor);
            Document document = editor.getDocument();
            TextMateBracePair pairForRightChar = TextMateEditorUtils.getSmartTypingPairForRightChar(c, scopeSelector);
            if (pairForRightChar != null && c == pairForRightChar.rightChar && offset < document.getTextLength() && document.getCharsSequence().charAt(offset) == c) {
                EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)1);
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    TextMateTypedHandler.$$$reportNull$$$0(6);
                }
                return result;
            }
            TextMateBracePair pairForLeftChar = TextMateEditorUtils.getSmartTypingPairForLeftChar(c, scopeSelector);
            if (pairForLeftChar != null) {
                CharSequence chars = document.getCharsSequence();
                if (pairForLeftChar.leftChar == pairForLeftChar.rightChar) {
                    char nextChar;
                    char prevChar = offset > 0 ? (char)document.getCharsSequence().charAt(offset - 1) : (char)' ';
                    char c2 = nextChar = offset < document.getTextLength() ? (char)document.getCharsSequence().charAt(offset) : (char)' ';
                    if (!Character.isLetterOrDigit(prevChar) && prevChar != pairForLeftChar.leftChar && !Character.isLetterOrDigit(nextChar) && nextChar != pairForLeftChar.rightChar) {
                        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)StringUtil.repeatSymbol((char)pairForLeftChar.leftChar, (int)2), (boolean)true, (int)1);
                        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                        if (result == null) {
                            TextMateTypedHandler.$$$reportNull$$$0(7);
                        }
                        return result;
                    }
                } else {
                    if (TextMateTypedHandler.alreadyHasEnding(chars, c, pairForLeftChar.rightChar, offset)) {
                        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                        if (result == null) {
                            TextMateTypedHandler.$$$reportNull$$$0(8);
                        }
                        return result;
                    }
                    EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)String.valueOf(new char[]{pairForLeftChar.leftChar, pairForLeftChar.rightChar}), (boolean)true, (int)1);
                    TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                    if (result == null) {
                        TextMateTypedHandler.$$$reportNull$$$0(9);
                    }
                    return result;
                }
            }
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            TextMateTypedHandler.$$$reportNull$$$0(10);
        }
        return result;
    }

    private static boolean alreadyHasEnding(@NotNull CharSequence chars, char startChar, char endChar, int offset) {
        int i;
        if (chars == null) {
            TextMateTypedHandler.$$$reportNull$$$0(11);
        }
        for (i = offset; i < chars.length() && chars.charAt(i) != startChar && chars.charAt(i) != endChar && chars.charAt(i) != '\n'; ++i) {
        }
        return i < chars.length() && chars.charAt(i) == endChar;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/textmate/editor/TextMateTypedHandler";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/textmate/editor/TextMateTypedHandler";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeCharTyped";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeCharTyped";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "alreadyHasEnding";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

