/*
 * Decompiled with CFR 0.152.
 */
package git4idea.light;

import com.intellij.diff.DiffContentFactoryImpl;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.commands.Git;
import git4idea.commands.GitBinaryHandler;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitExecutableManager;
import git4idea.util.GitFileUtils;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\u001a\"\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u0002\u001a&\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005\u001a(\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\u0005\u001a\u0016\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u000f"}, d2={"createRevParseHandler", "Lgit4idea/commands/GitLineHandler;", "directory", "Lcom/intellij/openapi/vfs/VirtualFile;", "executable", "", "abbrev", "", "getFileContent", "", "repositoryPath", "revisionOrBranch", "getFileContentAsString", "file", "getLocation", "intellij.vcs.git"})
public final class LightGitUtilKt {
    @NotNull
    public static final String getLocation(@NotNull VirtualFile directory, @NotNull String executable) throws VcsException {
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        Intrinsics.checkParameterIsNotNull((Object)executable, (String)"executable");
        String string = Git.getInstance().runCommand(LightGitUtilKt.createRevParseHandler$default(directory, executable, false, 4, null)).getOutputOrThrow(new int[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Git.getInstance().runCom\u2026able)).getOutputOrThrow()");
        String name = string;
        if (Intrinsics.areEqual((Object)name, (Object)"HEAD") ^ true) {
            return name;
        }
        String string2 = Git.getInstance().runCommand(LightGitUtilKt.createRevParseHandler(directory, executable, false)).getOutputOrThrow(new int[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Git.getInstance().runCom\u2026alse)).getOutputOrThrow()");
        String hash = string2;
        if (VcsLogUtil.HASH_REGEX.matcher(hash).matches()) {
            String string3 = VcsLogUtil.getShortHash((String)hash);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"VcsLogUtil.getShortHash(hash)");
            return string3;
        }
        throw (Throwable)new VcsException("Could not find current revision for " + directory.getPath());
    }

    private static final GitLineHandler createRevParseHandler(VirtualFile directory, String executable, boolean abbrev) {
        GitLineHandler handler = new GitLineHandler(null, VfsUtilCore.virtualToIoFile((VirtualFile)directory), executable, GitCommand.REV_PARSE, CollectionsKt.emptyList());
        if (abbrev) {
            handler.addParameters("--abbrev-ref");
        }
        handler.addParameters("HEAD");
        handler.setSilent(true);
        return handler;
    }

    static /* synthetic */ GitLineHandler createRevParseHandler$default(VirtualFile virtualFile, String string, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return LightGitUtilKt.createRevParseHandler(virtualFile, string, bl);
    }

    @NotNull
    public static final byte[] getFileContent(@NotNull VirtualFile directory, @NotNull String repositoryPath, @NotNull String executable, @NotNull String revisionOrBranch) throws VcsException {
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        Intrinsics.checkParameterIsNotNull((Object)repositoryPath, (String)"repositoryPath");
        Intrinsics.checkParameterIsNotNull((Object)executable, (String)"executable");
        Intrinsics.checkParameterIsNotNull((Object)revisionOrBranch, (String)"revisionOrBranch");
        GitBinaryHandler h = new GitBinaryHandler(VfsUtilCore.virtualToIoFile((VirtualFile)directory), executable, GitCommand.CAT_FILE);
        GitFileUtils.addTextConvParameters(GitExecutableManager.getInstance().getVersion(executable), h, true);
        h.addParameters(revisionOrBranch + ':' + repositoryPath);
        byte[] byArray = h.run();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"h.run()");
        return byArray;
    }

    @NotNull
    public static final String getFileContentAsString(@NotNull VirtualFile file, @NotNull String repositoryPath, @NotNull String executable, @NotNull String revisionOrBranch) throws VcsException {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)repositoryPath, (String)"repositoryPath");
        Intrinsics.checkParameterIsNotNull((Object)executable, (String)"executable");
        Intrinsics.checkParameterIsNotNull((Object)revisionOrBranch, (String)"revisionOrBranch");
        VirtualFile virtualFile = file.getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"file.parent");
        byte[] vcsContent = LightGitUtilKt.getFileContent(virtualFile, repositoryPath, executable, revisionOrBranch);
        Charset charset = DiffContentFactoryImpl.guessCharset((byte[])vcsContent, (FilePath)VcsUtil.getFilePath((VirtualFile)file));
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"DiffContentFactoryImpl.g\u2026csUtil.getFilePath(file))");
        Charset charset2 = charset;
        String string = CharsetToolkit.decodeString((byte[])vcsContent, (Charset)charset2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"CharsetToolkit.decodeString(vcsContent, charset)");
        return string;
    }

    public static /* synthetic */ String getFileContentAsString$default(VirtualFile virtualFile, String string, String string2, String string3, int n, Object object) throws VcsException {
        if ((n & 8) != 0) {
            string3 = "HEAD";
        }
        return LightGitUtilKt.getFileContentAsString(virtualFile, string, string2, string3);
    }
}

