/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.codeInsight.highlighting.TooltipLinkHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.log.GitShowCommitInLogAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitCommitTooltipLinkHandler
extends TooltipLinkHandler {
    private static final Logger LOG = Logger.getInstance(GitCommitTooltipLinkHandler.class);

    public boolean handleLink(@NotNull String refSuffix, @NotNull Editor editor) {
        Project project;
        if (refSuffix == null) {
            GitCommitTooltipLinkHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            GitCommitTooltipLinkHandler.$$$reportNull$$$0(1);
        }
        if ((project = editor.getProject()) == null) {
            return false;
        }
        Hash hash = GitCommitTooltipLinkHandler.tryCreateHash(refSuffix);
        if (hash == null) {
            LOG.warn("Bad revision: " + refSuffix);
            return false;
        }
        GitShowCommitInLogAction.jumpToRevision(project, hash);
        return true;
    }

    @Nullable
    public static String createLink(@NotNull String text, @NotNull VcsRevisionNumber revisionNumber) {
        Hash hash;
        if (text == null) {
            GitCommitTooltipLinkHandler.$$$reportNull$$$0(2);
        }
        if (revisionNumber == null) {
            GitCommitTooltipLinkHandler.$$$reportNull$$$0(3);
        }
        if ((hash = GitCommitTooltipLinkHandler.tryCreateHash(revisionNumber.asString())) == null) {
            return null;
        }
        return "<a href=\"#git_commit/" + hash.asString() + "\">" + XmlStringUtil.escapeString((String)text) + "</a>";
    }

    @Nullable
    private static Hash tryCreateHash(@NotNull String revision) {
        if (revision == null) {
            GitCommitTooltipLinkHandler.$$$reportNull$$$0(4);
        }
        try {
            return HashImpl.build((String)revision);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refSuffix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revisionNumber";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
        }
        objectArray2[1] = "git4idea/log/GitCommitTooltipLinkHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "handleLink";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createLink";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "tryCreateHash";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

