/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.WindowWrapper;
import com.intellij.openapi.ui.WindowWrapperBuilder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.impl.VcsLogContentUtil;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogTabsProperties;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogPanel;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.config.GitExecutableManager;
import git4idea.i18n.GitBundle;
import git4idea.log.GitExternalLogTabsProperties;
import git4idea.repo.GitRepositoryImpl;
import git4idea.repo.GitRepositoryManager;
import java.awt.BorderLayout;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class GitShowExternalLogAction
extends DumbAwareAction {
    private static final String EXTERNAL = "EXTERNAL";

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            GitShowExternalLogAction.$$$reportNull$$$0(0);
        }
        super.update(e);
        e.getPresentation().setEnabledAndVisible(e.getProject() != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            GitShowExternalLogAction.$$$reportNull$$$0(1);
        }
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        GitVcs vcs = GitVcs.getInstance(project);
        List<VirtualFile> roots = GitShowExternalLogAction.getGitRootsFromUser(project);
        if (roots.isEmpty()) {
            return;
        }
        ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow("Version Control");
        if (project.isDefault() || !ProjectLevelVcsManager.getInstance((Project)project).hasActiveVcss() || window == null) {
            ProgressManager.getInstance().run((Task)new ShowLogInDialogTask(project, roots, vcs));
            return;
        }
        Runnable showContent = () -> {
            ContentManager cm = window.getContentManager();
            if (GitShowExternalLogAction.checkIfProjectLogMatches(project, vcs, cm, roots) || GitShowExternalLogAction.checkIfAlreadyOpened(cm, roots)) {
                return;
            }
            String tabName = GitShowExternalLogAction.calcTabName(cm, roots);
            MyContentComponent component = GitShowExternalLogAction.createManagerAndContent(project, vcs, roots, true);
            Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)component, tabName, false);
            content.setDisposer(component.myDisposable);
            content.setDescription(GitBundle.message("git.log.external.tab.description", StringUtil.join((Collection)roots, VirtualFile::getPath, (String)"\n")));
            content.setCloseable(true);
            cm.addContent(content);
            cm.setSelectedContent(content);
        };
        if (!window.isVisible()) {
            window.activate(showContent, true);
        } else {
            showContent.run();
        }
    }

    @NotNull
    private static MyContentComponent createManagerAndContent(@NotNull Project project, @NotNull GitVcs vcs, @NotNull List<VirtualFile> roots, boolean isToolWindowTab) {
        if (project == null) {
            GitShowExternalLogAction.$$$reportNull$$$0(2);
        }
        if (vcs == null) {
            GitShowExternalLogAction.$$$reportNull$$$0(3);
        }
        if (roots == null) {
            GitShowExternalLogAction.$$$reportNull$$$0(4);
        }
        Disposable disposable = Disposer.newDisposable();
        GitRepositoryManager repositoryManager = GitRepositoryManager.getInstance(project);
        for (VirtualFile root2 : roots) {
            repositoryManager.addExternalRepository(root2, GitRepositoryImpl.createInstance(root2, project, disposable, true));
        }
        VcsLogManager manager = new VcsLogManager(project, (VcsLogTabsProperties)ServiceManager.getService(GitExternalLogTabsProperties.class), (Collection)ContainerUtil.map(roots, root -> new VcsRoot((AbstractVcs)vcs, root)));
        Disposer.register((Disposable)disposable, () -> manager.dispose(() -> {
            for (VirtualFile root : roots) {
                repositoryManager.removeExternalRepository(root);
            }
        }));
        MainVcsLogUi ui = manager.createLogUi(GitShowExternalLogAction.calcLogId(roots), isToolWindowTab ? VcsLogManager.LogWindowKind.TOOL_WINDOW : VcsLogManager.LogWindowKind.STANDALONE, true);
        Disposer.register((Disposable)disposable, (Disposable)ui);
        return new MyContentComponent((JComponent)new VcsLogPanel(manager, (VcsLogUiEx)ui), roots, disposable);
    }

    @NotNull
    private static String calcLogId(@NotNull List<? extends VirtualFile> roots) {
        if (roots == null) {
            GitShowExternalLogAction.$$$reportNull$$$0(5);
        }
        String string = "EXTERNAL " + StringUtil.join(roots, VirtualFile::getPath, (String)File.pathSeparator);
        if (string == null) {
            GitShowExternalLogAction.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    private static String calcTabName(@NotNull ContentManager cm, @NotNull List<? extends VirtualFile> roots) {
        if (cm == null) {
            GitShowExternalLogAction.$$$reportNull$$$0(7);
        }
        if (roots == null) {
            GitShowExternalLogAction.$$$reportNull$$$0(8);
        }
        String name = VcsLogBundle.message((String)"vcs.log.tab.name", (Object[])new Object[0]) + " (" + roots.get(0).getName();
        if (roots.size() > 1) {
            name = name + "+";
        }
        String candidate = name = name + ")";
        int cnt = 1;
        while (GitShowExternalLogAction.hasContentsWithName(cm, candidate)) {
            candidate = name + "-" + cnt;
            ++cnt;
        }
        String string = candidate;
        if (string == null) {
            GitShowExternalLogAction.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static boolean hasContentsWithName(@NotNull ContentManager cm, @NotNull String candidate) {
        if (cm == null) {
            GitShowExternalLogAction.$$$reportNull$$$0(10);
        }
        if (candidate == null) {
            GitShowExternalLogAction.$$$reportNull$$$0(11);
        }
        return ContainerUtil.exists((Object[])cm.getContents(), content -> content.getDisplayName().equals(candidate));
    }

    @NotNull
    private static List<VirtualFile> getGitRootsFromUser(@NotNull Project project) {
        FileChooserDescriptor descriptor;
        VirtualFile[] virtualFiles;
        if (project == null) {
            GitShowExternalLogAction.$$$reportNull$$$0(12);
        }
        if ((virtualFiles = FileChooser.chooseFiles((FileChooserDescriptor)(descriptor = new FileChooserDescriptor(false, true, false, true, false, true)), (Project)project, null)).length == 0) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                GitShowExternalLogAction.$$$reportNull$$$0(13);
            }
            return list;
        }
        ArrayList<VirtualFile> correctRoots = new ArrayList<VirtualFile>();
        for (VirtualFile vf : virtualFiles) {
            if (!GitUtil.isGitRoot(new File(vf.getPath()))) continue;
            correctRoots.add(vf);
        }
        ArrayList<VirtualFile> arrayList = correctRoots;
        if (arrayList == null) {
            GitShowExternalLogAction.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    private static boolean checkIfProjectLogMatches(@NotNull Project project, @NotNull GitVcs vcs, @NotNull ContentManager cm, @NotNull List<VirtualFile> requestedRoots) {
        List<VirtualFile> projectRoots;
        if (project == null) {
            GitShowExternalLogAction.$$$reportNull$$$0(15);
        }
        if (vcs == null) {
            GitShowExternalLogAction.$$$reportNull$$$0(16);
        }
        if (cm == null) {
            GitShowExternalLogAction.$$$reportNull$$$0(17);
        }
        if (requestedRoots == null) {
            GitShowExternalLogAction.$$$reportNull$$$0(18);
        }
        if ((projectRoots = Arrays.asList(ProjectLevelVcsManager.getInstance((Project)project).getRootsUnderVcs((AbstractVcs)vcs))).containsAll(requestedRoots)) {
            if (requestedRoots.containsAll(projectRoots)) {
                return VcsLogContentUtil.selectMainLog((ContentManager)cm);
            }
            VcsLogFilterCollection filters = VcsLogFilterObject.collection((VcsLogFilter[])new VcsLogFilter[]{VcsLogFilterObject.fromRoots(requestedRoots)});
            return VcsProjectLog.getInstance((Project)project).openLogTab(filters) != null;
        }
        return false;
    }

    private static boolean checkIfAlreadyOpened(@NotNull ContentManager cm, @NotNull Collection<VirtualFile> roots) {
        if (cm == null) {
            GitShowExternalLogAction.$$$reportNull$$$0(19);
        }
        if (roots == null) {
            GitShowExternalLogAction.$$$reportNull$$$0(20);
        }
        for (Content content : cm.getContents()) {
            JComponent component = content.getComponent();
            if (!(component instanceof MyContentComponent) || !Comparing.haveEqualElements(roots, (Collection)((MyContentComponent)component).myRoots)) continue;
            cm.setSelectedContent(content);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 6: 
            case 9: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/log/GitShowExternalLogAction";
                break;
            }
            case 7: 
            case 10: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cm";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestedRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/log/GitShowExternalLogAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "calcLogId";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "calcTabName";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getGitRootsFromUser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createManagerAndContent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "calcLogId";
                break;
            }
            case 6: 
            case 9: 
            case 13: 
            case 14: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "calcTabName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasContentsWithName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getGitRootsFromUser";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "checkIfProjectLogMatches";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "checkIfAlreadyOpened";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 9: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ShowLogInDialogTask
    extends Task.Backgroundable {
        @NotNull
        private final Project myProject;
        @NotNull
        private final List<VirtualFile> myRoots;
        @NotNull
        private final GitVcs myVcs;

        private ShowLogInDialogTask(@NotNull Project project, @NotNull List<VirtualFile> roots, @NotNull GitVcs vcs) {
            if (project == null) {
                ShowLogInDialogTask.$$$reportNull$$$0(0);
            }
            if (roots == null) {
                ShowLogInDialogTask.$$$reportNull$$$0(1);
            }
            if (vcs == null) {
                ShowLogInDialogTask.$$$reportNull$$$0(2);
            }
            super(project, GitBundle.message("git.log.external.loading.process", new Object[0]), true);
            this.myProject = project;
            this.myRoots = roots;
            this.myVcs = vcs;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                ShowLogInDialogTask.$$$reportNull$$$0(3);
            }
            if (!GitExecutableManager.getInstance().testGitExecutableVersionValid(this.myProject)) {
                throw new ProcessCanceledException();
            }
        }

        public void onSuccess() {
            if (!this.myProject.isDisposed()) {
                MyContentComponent content = GitShowExternalLogAction.createManagerAndContent(this.myProject, this.myVcs, this.myRoots, false);
                WindowWrapper window = new WindowWrapperBuilder(WindowWrapper.Mode.FRAME, (JComponent)content).setProject(this.myProject).setTitle(GitBundle.message("git.log.external.window.title", new Object[0])).setPreferredFocusedComponent((JComponent)content).setDimensionServiceKey(GitShowExternalLogAction.class.getName()).build();
                Disposer.register((Disposable)window, (Disposable)content.myDisposable);
                window.show();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "vcs";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            objectArray2[1] = "git4idea/log/GitShowExternalLogAction$ShowLogInDialogTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyContentComponent
    extends JPanel {
        @NotNull
        private final Collection<VirtualFile> myRoots;
        @NotNull
        private final Disposable myDisposable;

        MyContentComponent(@NotNull JComponent actualComponent, @NotNull Collection<VirtualFile> roots, @NotNull Disposable disposable) {
            if (actualComponent == null) {
                MyContentComponent.$$$reportNull$$$0(0);
            }
            if (roots == null) {
                MyContentComponent.$$$reportNull$$$0(1);
            }
            if (disposable == null) {
                MyContentComponent.$$$reportNull$$$0(2);
            }
            super(new BorderLayout());
            this.myDisposable = disposable;
            this.myRoots = roots;
            this.add(actualComponent);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "actualComponent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "roots";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "disposable";
                    break;
                }
            }
            objectArray[1] = "git4idea/log/GitShowExternalLogAction$MyContentComponent";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

