/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase.interactive.dialog;

import com.intellij.icons.AllIcons;
import com.intellij.ui.SimpleColoredRenderer;
import git4idea.rebase.interactive.dialog.CommitIconRenderer$WhenMappings;
import git4idea.rebase.interactive.dialog.GitRebaseCommitsTableView;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\b\u0002\u0018\u0000 #2\u00020\u0001:\u0002#$B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014JP\u0010\r\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bJ0\u0010\u0015\u001a\u00020\n*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\b2\b\b\u0002\u0010\u0019\u001a\u00020\b2\b\b\u0002\u0010\u001a\u001a\u00020\u001bH\u0002J\f\u0010\u001c\u001a\u00020\n*\u00020\u0016H\u0002J\f\u0010\u001d\u001a\u00020\n*\u00020\u0016H\u0002J\u001c\u0010\u001e\u001a\u00020\n*\u00020\u00162\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u0004H\u0002J\f\u0010!\u001a\u00020\n*\u00020\u0016H\u0002J\f\u0010\"\u001a\u00020\n*\u00020\u0016H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lgit4idea/rebase/interactive/dialog/CommitIconRenderer;", "Lcom/intellij/ui/SimpleColoredRenderer;", "()V", "isHead", "", "nodeType", "Lgit4idea/rebase/interactive/dialog/CommitIconRenderer$NodeType;", "rowHeight", "", "paintComponent", "", "g", "Ljava/awt/Graphics;", "update", "table", "Ljavax/swing/JTable;", "isSelected", "hasFocus", "row", "column", "editing", "drawCircle", "Ljava/awt/Graphics2D;", "x0", "y0", "circleRadius", "circleColor", "Ljava/awt/Color;", "drawCommitIcon", "drawDoubleNode", "drawEdge", "tableRowHeight", "isDownEdge", "drawEditNode", "drawNode", "Companion", "NodeType", "intellij.vcs.git"})
final class CommitIconRenderer
extends SimpleColoredRenderer {
    private boolean isHead;
    private NodeType nodeType = NodeType.SIMPLE_NODE;
    private int rowHeight;
    private static final int NODE_WIDTH = 8;
    private static final int NODE_CENTER_X = 8;
    private static final int NODE_CENTER_Y = 11;
    public static final Companion Companion = new Companion(null);

    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkParameterIsNotNull((Object)g, (String)"g");
        super.paintComponent(g);
        this.drawCommitIcon((Graphics2D)g);
    }

    public final void update(@Nullable JTable table, boolean isSelected, boolean hasFocus, int row, int column, boolean isHead, @NotNull NodeType nodeType, boolean editing, int rowHeight) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)nodeType), (String)"nodeType");
        this.clear();
        this.setPaintFocusBorder(false);
        this.acquireState(table, isSelected && !editing, hasFocus && !editing, row, column);
        this.getCellState().updateRenderer((JComponent)((Object)this));
        this.setBorder(null);
        this.isHead = isHead;
        this.nodeType = nodeType;
        this.rowHeight = rowHeight;
    }

    private final void drawCommitIcon(@NotNull Graphics2D $this$drawCommitIcon) {
        int tableRowHeight = this.rowHeight;
        $this$drawCommitIcon.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        switch (CommitIconRenderer$WhenMappings.$EnumSwitchMapping$0[this.nodeType.ordinal()]) {
            case 1: {
                this.drawNode($this$drawCommitIcon);
                break;
            }
            case 2: {
                this.drawDoubleNode($this$drawCommitIcon);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.drawEditNode($this$drawCommitIcon);
                break;
            }
        }
        if (this.nodeType != NodeType.EDIT) {
            this.drawEdge($this$drawCommitIcon, tableRowHeight, false);
            if (!this.isHead) {
                this.drawEdge($this$drawCommitIcon, tableRowHeight, true);
            }
        }
    }

    private final void drawDoubleNode(@NotNull Graphics2D $this$drawDoubleNode) {
        int circleRadius = 4;
        int backgroundCircleRadius = circleRadius + 1;
        int leftCircleX0 = 8;
        int y0 = 11;
        int rightCircleX0 = leftCircleX0 + circleRadius;
        CommitIconRenderer.drawCircle$default(this, $this$drawDoubleNode, rightCircleX0, y0, 0, null, 12, null);
        Color color = this.getBackground();
        Intrinsics.checkExpressionValueIsNotNull((Object)color, (String)"this@CommitIconRenderer.background");
        this.drawCircle($this$drawDoubleNode, leftCircleX0, y0, backgroundCircleRadius, color);
        CommitIconRenderer.drawCircle$default(this, $this$drawDoubleNode, leftCircleX0, y0, 0, null, 12, null);
    }

    private final void drawEditNode(@NotNull Graphics2D $this$drawEditNode) {
        Icon icon = AllIcons.Actions.Pause;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"AllIcons.Actions.Pause");
        Icon icon2 = icon;
        icon2.paintIcon(null, $this$drawEditNode, 8 - icon2.getIconWidth() / 2, 11 - icon2.getIconHeight() / 2);
    }

    private final void drawNode(@NotNull Graphics2D $this$drawNode) {
        CommitIconRenderer.drawCircle$default(this, $this$drawNode, 8, 11, 0, null, 12, null);
    }

    private final void drawCircle(@NotNull Graphics2D $this$drawCircle, int x0, int y0, int circleRadius, Color circleColor) {
        Ellipse2D.Double circle = new Ellipse2D.Double((double)(x0 - circleRadius) + 0.5, (double)(y0 - circleRadius) + 0.5, 2.0 * (double)circleRadius, 2.0 * (double)circleRadius);
        $this$drawCircle.setColor(circleColor);
        $this$drawCircle.fill(circle);
    }

    static /* synthetic */ void drawCircle$default(CommitIconRenderer commitIconRenderer, Graphics2D graphics2D, int n, int n2, int n3, Color color, int n4, Object object) {
        if ((n4 & 4) != 0) {
            n3 = 4;
        }
        if ((n4 & 8) != 0) {
            color = (Color)GitRebaseCommitsTableView.Companion.getGRAPH_COLOR();
        }
        commitIconRenderer.drawCircle(graphics2D, n, n2, n3, color);
    }

    private final void drawEdge(@NotNull Graphics2D $this$drawEdge, int tableRowHeight, boolean isDownEdge) {
        int y1 = 11;
        int y2 = isDownEdge ? tableRowHeight : 0;
        int x = 8;
        $this$drawEdge.setColor((Color)GitRebaseCommitsTableView.Companion.getGRAPH_COLOR());
        $this$drawEdge.setStroke(new BasicStroke(1.5f, 1, 2));
        $this$drawEdge.drawLine(x, y1, x, y2);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lgit4idea/rebase/interactive/dialog/CommitIconRenderer$NodeType;", "", "(Ljava/lang/String;I)V", "NO_NODE", "SIMPLE_NODE", "DOUBLE_NODE", "EDIT", "intellij.vcs.git"})
    public static final class NodeType
    extends Enum<NodeType> {
        public static final /* enum */ NodeType NO_NODE;
        public static final /* enum */ NodeType SIMPLE_NODE;
        public static final /* enum */ NodeType DOUBLE_NODE;
        public static final /* enum */ NodeType EDIT;
        private static final /* synthetic */ NodeType[] $VALUES;

        static {
            NodeType[] nodeTypeArray = new NodeType[4];
            NodeType[] nodeTypeArray2 = nodeTypeArray;
            nodeTypeArray[0] = NO_NODE = new NodeType();
            nodeTypeArray[1] = SIMPLE_NODE = new NodeType();
            nodeTypeArray[2] = DOUBLE_NODE = new NodeType();
            nodeTypeArray[3] = EDIT = new NodeType();
            $VALUES = nodeTypeArray;
        }

        public static NodeType[] values() {
            return (NodeType[])$VALUES.clone();
        }

        public static NodeType valueOf(String string) {
            return Enum.valueOf(NodeType.class, string);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lgit4idea/rebase/interactive/dialog/CommitIconRenderer$Companion;", "", "()V", "NODE_CENTER_X", "", "NODE_CENTER_Y", "NODE_WIDTH", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

