/*
 * Decompiled with CFR 0.152.
 */
package git4idea.util;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jetbrains.annotations.NotNull;

@Service
public final class GitVcsConsoleWriter {
    private static final int MAX_CONSOLE_OUTPUT_SIZE = 10000;
    private final Project myProject;

    @NotNull
    public static GitVcsConsoleWriter getInstance(@NotNull Project project) {
        if (project == null) {
            GitVcsConsoleWriter.$$$reportNull$$$0(0);
        }
        GitVcsConsoleWriter gitVcsConsoleWriter = (GitVcsConsoleWriter)project.getService(GitVcsConsoleWriter.class);
        if (gitVcsConsoleWriter == null) {
            GitVcsConsoleWriter.$$$reportNull$$$0(1);
        }
        return gitVcsConsoleWriter;
    }

    public GitVcsConsoleWriter(@NotNull Project project) {
        if (project == null) {
            GitVcsConsoleWriter.$$$reportNull$$$0(2);
        }
        this.myProject = project;
    }

    public void showMessage(@NotNull String message) {
        if (message == null) {
            GitVcsConsoleWriter.$$$reportNull$$$0(3);
        }
        this.showMessage(message, ConsoleViewContentType.NORMAL_OUTPUT);
    }

    public void showErrorMessage(@NotNull String line) {
        if (line == null) {
            GitVcsConsoleWriter.$$$reportNull$$$0(4);
        }
        this.showMessage(line, ConsoleViewContentType.ERROR_OUTPUT);
    }

    public void showCommandLine(@NotNull String cmdLine) {
        if (cmdLine == null) {
            GitVcsConsoleWriter.$$$reportNull$$$0(5);
        }
        SimpleDateFormat f = new SimpleDateFormat("HH:mm:ss.SSS");
        this.showMessage(f.format(new Date()) + ": " + cmdLine, ConsoleViewContentType.SYSTEM_OUTPUT);
    }

    private void showMessage(@NotNull String message, @NotNull ConsoleViewContentType contentType) {
        if (message == null) {
            GitVcsConsoleWriter.$$$reportNull$$$0(6);
        }
        if (contentType == null) {
            GitVcsConsoleWriter.$$$reportNull$$$0(7);
        }
        if (message.length() == 0) {
            return;
        }
        ProjectLevelVcsManager.getInstance((Project)this.myProject).addMessageToConsoleWindow(StringUtil.shortenPathWithEllipsis((String)message, (int)10000), contentType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/util/GitVcsConsoleWriter";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdLine";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/util/GitVcsConsoleWriter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "showMessage";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "showErrorMessage";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showCommandLine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

