/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.groovy.compiler.rt;

import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyResourceLoader;
import groovy.lang.GroovyShell;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.codehaus.groovy.tools.javac.JavaAwareCompilationUnit;
import org.codehaus.groovy.tools.javac.JavaCompiler;
import org.codehaus.groovy.tools.javac.JavaCompilerFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.groovy.compiler.rt.AstAwareResourceLoader;
import org.jetbrains.groovy.compiler.rt.ClassDependencyLoader;
import org.jetbrains.groovy.compiler.rt.CompilationUnitPatcher;
import org.jetbrains.groovy.compiler.rt.CompilerMessage;
import org.jetbrains.groovy.compiler.rt.GroovyCompilerWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependentGroovycRunner {
    public static final String TEMP_RESOURCE_SUFFIX = "___" + new Random().nextInt() + "_neverHappen";
    public static final String[] RESOURCES_TO_MASK = new String[]{"META-INF/services/org.codehaus.groovy.transform.ASTTransformation", "META-INF/services/org.codehaus.groovy.runtime.ExtensionModule"};
    private static final String STUB_DIR = "stubDir";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean runGroovyc(boolean forStubs, String argsPath, @Nullable String configScript, @Nullable String targetBytecode, @Nullable Queue<? super Object> mailbox, @NotNull PrintStream out, @NotNull PrintStream err) {
        List<GroovyCompilerWrapper.OutputItem> compiledFiles;
        if (out == null) {
            DependentGroovycRunner.$$$reportNull$$$0(0);
        }
        if (err == null) {
            DependentGroovycRunner.$$$reportNull$$$0(1);
        }
        File argsFile = new File(argsPath);
        CompilerConfiguration config = DependentGroovycRunner.createCompilerConfiguration(targetBytecode);
        config.setClasspath("");
        config.setOutput(new PrintWriter(err));
        config.setWarningLevel(3);
        ArrayList compilerMessages = new ArrayList();
        ArrayList patchers = new ArrayList();
        ArrayList<File> srcFiles = new ArrayList<File>();
        HashMap<String, File> class2File = new HashMap<String, File>();
        String[] finalOutputRef = new String[1];
        DependentGroovycRunner.fillFromArgsFile(argsFile, config, patchers, compilerMessages, srcFiles, class2File, finalOutputRef, err);
        if (srcFiles.isEmpty()) {
            return true;
        }
        String[] finalOutputs = finalOutputRef[0].split(File.pathSeparator);
        if (forStubs) {
            HashMap<String, Comparable<File>> options = new HashMap<String, Comparable<File>>();
            options.put(STUB_DIR, config.getTargetDirectory());
            options.put("keepStubs", Boolean.TRUE);
            config.setJointCompilationOptions(options);
            if (mailbox != null) {
                config.setTargetDirectory(finalOutputs[0]);
            }
        }
        try {
            boolean asm = !"false".equals(System.getProperty("groovyc.asm.resolving.only"));
            config.getOptimizationOptions().put("asmResolving", asm);
            config.getOptimizationOptions().put("classLoaderResolving", !asm);
        }
        catch (NoSuchMethodError asm) {
            // empty catch block
        }
        if (configScript != null && configScript.length() > 0) {
            try {
                DependentGroovycRunner.applyConfigurationScript(new File(configScript), config, err);
            }
            catch (LinkageError asm) {
                // empty catch block
            }
        }
        out.println("@#$%@# Presentable:Groovyc: loading sources...");
        DependentGroovycRunner.renameResources(finalOutputs, "", TEMP_RESOURCE_SUFFIX);
        try {
            final AstAwareResourceLoader resourceLoader = new AstAwareResourceLoader(class2File);
            GroovyCompilerWrapper wrapper = new GroovyCompilerWrapper(compilerMessages, forStubs);
            CompilationUnit unit = DependentGroovycRunner.createCompilationUnit(forStubs, config, DependentGroovycRunner.buildClassLoaderFor(config, resourceLoader), mailbox, wrapper, out, err);
            unit.addPhaseOperation(new CompilationUnit.SourceUnitOperation(){

                public void call(SourceUnit source) throws CompilationFailedException {
                    File file = new File(source.getName());
                    for (ClassNode aClass : source.getAST().getClasses()) {
                        resourceLoader.myClass2File.put(aClass.getName(), file);
                    }
                }
            }, 3);
            DependentGroovycRunner.addSources(forStubs, srcFiles, unit);
            DependentGroovycRunner.runPatchers(patchers, compilerMessages, unit, resourceLoader, srcFiles);
            out.println("@#$%@# Presentable:Groovyc: compiling...");
            compiledFiles = wrapper.compile(unit, forStubs && mailbox == null ? 3 : 9);
        }
        finally {
            DependentGroovycRunner.renameResources(finalOutputs, TEMP_RESOURCE_SUFFIX, "");
            out.println("$@#$%^ CLEAR_PRESENTABLE");
        }
        out.println();
        DependentGroovycRunner.reportCompiledItems(out, compiledFiles);
        int errorCount = 0;
        for (CompilerMessage message : compilerMessages) {
            if (message.getCategory() == "error") {
                if (errorCount > 100) continue;
                ++errorCount;
            }
            DependentGroovycRunner.printMessage(out, message);
        }
        return false;
    }

    private static CompilerConfiguration createCompilerConfiguration(@Nullable String targetBytecode) {
        CompilerConfiguration config = new CompilerConfiguration();
        if (targetBytecode != null) {
            config.setTargetBytecode(targetBytecode);
        }
        if (config.getTargetBytecode() == null) {
            System.clearProperty("groovy.target.bytecode");
            config = new CompilerConfiguration();
            if (config.getTargetBytecode() == null) {
                throw new AssertionError((Object)"Cannot determine bytecode target");
            }
        }
        return config;
    }

    private static void applyConfigurationScript(File configScript, CompilerConfiguration configuration, PrintStream err) {
        Binding binding = new Binding();
        binding.setVariable("configuration", (Object)configuration);
        CompilerConfiguration configuratorConfig = new CompilerConfiguration();
        ImportCustomizer customizer = new ImportCustomizer();
        customizer.addStaticStars(new String[]{"org.codehaus.groovy.control.customizers.builder.CompilerCustomizationBuilder"});
        configuratorConfig.addCompilationCustomizers(new CompilationCustomizer[]{customizer});
        try {
            new GroovyShell(binding, configuratorConfig).evaluate(configScript);
        }
        catch (Exception e) {
            e.printStackTrace(err);
        }
    }

    private static void renameResources(String[] finalOutputs, String removeSuffix, String addSuffix) {
        for (String output : finalOutputs) {
            for (String res : RESOURCES_TO_MASK) {
                File file = new File(output, res + removeSuffix);
                if (!file.exists()) continue;
                file.renameTo(new File(output, res + addSuffix));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void fillFromArgsFile(File argsFile, CompilerConfiguration compilerConfiguration, List<? super CompilationUnitPatcher> patchers, List<? super CompilerMessage> compilerMessages, List<? super File> srcFiles, Map<String, File> class2File, String[] finalOutputs, PrintStream err) {
        String line;
        BufferedReader reader = null;
        try {
            FileInputStream stream = new FileInputStream(argsFile);
            reader = new BufferedReader(new InputStreamReader((InputStream)stream, Charset.forName("UTF-8")));
            reader.readLine();
            while ((line = reader.readLine()) != null && "src_file".equals(line)) {
                File file = new File(reader.readLine());
                srcFiles.add(file);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace(err);
            return;
        }
        catch (IOException e) {
            e.printStackTrace(err);
            return;
        }
        while (line != null) {
            block35: {
                String s;
                block36: {
                    block38: {
                        block37: {
                            block34: {
                                if (!line.equals("class2src")) break block34;
                                while (!"end".equals(line = reader.readLine())) {
                                    class2File.put(line, new File(reader.readLine()));
                                }
                                break block35;
                            }
                            if (line.startsWith("patchers")) break block36;
                            if (!line.startsWith("encoding")) break block37;
                            compilerConfiguration.setSourceEncoding(reader.readLine());
                            break block35;
                        }
                        if (!line.startsWith("outputpath")) break block38;
                        compilerConfiguration.setTargetDirectory(reader.readLine());
                        break block35;
                    }
                    if (line.startsWith("final_outputpath")) {
                        finalOutputs[0] = reader.readLine();
                    }
                    break block35;
                }
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                while (!"end".equals(s = reader.readLine())) {
                    try {
                        Class<?> patcherClass = classLoader.loadClass(s);
                        CompilationUnitPatcher patcher = (CompilationUnitPatcher)patcherClass.newInstance();
                        patchers.add(patcher);
                    }
                    catch (InstantiationException e) {
                        DependentGroovycRunner.addExceptionInfo(compilerMessages, e, "Couldn't instantiate " + s);
                    }
                    catch (IllegalAccessException e) {
                        DependentGroovycRunner.addExceptionInfo(compilerMessages, e, "Couldn't instantiate " + s);
                    }
                    catch (ClassNotFoundException e) {
                        DependentGroovycRunner.addExceptionInfo(compilerMessages, e, "Couldn't instantiate " + s);
                    }
                }
            }
            line = reader.readLine();
        }
        return;
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace(err);
            }
            finally {
                argsFile.delete();
            }
        }
    }

    private static void addSources(boolean forStubs, List<? extends File> srcFiles, CompilationUnit unit) {
        for (File file : srcFiles) {
            if (forStubs && file.getName().endsWith(".java")) continue;
            unit.addSource(new SourceUnit(file, unit.getConfiguration(), unit.getClassLoader(), unit.getErrorCollector()));
        }
    }

    private static void runPatchers(List<? extends CompilationUnitPatcher> patchers, List<? super CompilerMessage> compilerMessages, CompilationUnit unit, AstAwareResourceLoader loader, List<File> srcFiles) {
        if (!patchers.isEmpty()) {
            for (CompilationUnitPatcher compilationUnitPatcher : patchers) {
                try {
                    compilationUnitPatcher.patchCompilationUnit(unit, loader, srcFiles.toArray(new File[0]));
                }
                catch (LinkageError e) {
                    DependentGroovycRunner.addExceptionInfo(compilerMessages, e, "Couldn't run " + compilationUnitPatcher.getClass().getName());
                }
            }
        }
    }

    private static void reportCompiledItems(@NotNull PrintStream out, @NotNull List<? extends GroovyCompilerWrapper.OutputItem> compiledFiles) {
        if (out == null) {
            DependentGroovycRunner.$$$reportNull$$$0(2);
        }
        if (compiledFiles == null) {
            DependentGroovycRunner.$$$reportNull$$$0(3);
        }
        for (GroovyCompilerWrapper.OutputItem outputItem : compiledFiles) {
            out.print("%%c");
            out.print(outputItem.getOutputPath());
            out.print("#%%#%%%#%%%%%%%%%#");
            out.print(outputItem.getSourceFile());
            out.print("/%c");
            out.println();
        }
    }

    private static void printMessage(@NotNull PrintStream out, @NotNull CompilerMessage message) {
        if (out == null) {
            DependentGroovycRunner.$$$reportNull$$$0(4);
        }
        if (message == null) {
            DependentGroovycRunner.$$$reportNull$$$0(5);
        }
        out.print("%%m");
        out.print(message.getCategory());
        out.print("#%%#%%%#%%%%%%%%%#");
        out.print(message.getMessage());
        out.print("#%%#%%%#%%%%%%%%%#");
        out.print(message.getUrl());
        out.print("#%%#%%%#%%%%%%%%%#");
        out.print(message.getLineNum());
        out.print("#%%#%%%#%%%%%%%%%#");
        out.print(message.getColumnNum());
        out.print("#%%#%%%#%%%%%%%%%#");
        out.print("/%m");
        out.println();
    }

    private static void addExceptionInfo(List<? super CompilerMessage> compilerMessages, Throwable e, String message) {
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        compilerMessages.add(new CompilerMessage("warning", message + ":\n" + writer, "<exception>", -1, -1));
    }

    private static CompilationUnit createCompilationUnit(boolean forStubs, CompilerConfiguration config, GroovyClassLoader classLoader, Queue<? super Object> mailbox, GroovyCompilerWrapper wrapper, final PrintStream out, PrintStream err) {
        CompilationUnit unit;
        GroovyClassLoader transformLoader = new GroovyClassLoader(classLoader);
        try {
            if (forStubs) {
                return DependentGroovycRunner.createStubGenerator(config, classLoader, transformLoader, mailbox, wrapper, out, err);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            unit = new CompilationUnit(config, null, classLoader, transformLoader){

                public void gotoPhase(int phase) throws CompilationFailedException {
                    super.gotoPhase(phase);
                    if (phase <= 9) {
                        out.println("@#$%@# Presentable:Groovyc: " + this.getPhaseDescription());
                    }
                }
            };
        }
        catch (NoSuchMethodError e) {
            unit = new CompilationUnit(config, null, classLoader){

                public void gotoPhase(int phase) throws CompilationFailedException {
                    super.gotoPhase(phase);
                    if (phase <= 9) {
                        out.println("@#$%@# Presentable:Groovyc: " + this.getPhaseDescription());
                    }
                }
            };
        }
        return unit;
    }

    private static CompilationUnit createStubGenerator(CompilerConfiguration config, GroovyClassLoader classLoader, final GroovyClassLoader transformLoader, final Queue<? super Object> mailbox, final GroovyCompilerWrapper wrapper, final PrintStream out, final PrintStream err) {
        final JavaAwareCompilationUnit unit = new JavaAwareCompilationUnit(config, classLoader){
            private boolean annoRemovedAdded;

            public GroovyClassLoader getTransformLoader() {
                return transformLoader;
            }

            public void addPhaseOperation(CompilationUnit.PrimaryClassNodeOperation op, int phase) {
                if (!this.annoRemovedAdded && mailbox == null && phase == 3 && "true".equals(System.getProperty("groovyc.remove.annotations.for.stub.generation")) && op.getClass().getName().startsWith("org.codehaus.groovy.tools.javac.JavaAwareCompilationUnit$")) {
                    this.annoRemovedAdded = true;
                    super.addPhaseOperation(new CompilationUnit.PrimaryClassNodeOperation(){

                        public void call(final SourceUnit source, GeneratorContext context, ClassNode classNode) throws CompilationFailedException {
                            ClassCodeVisitorSupport annoRemover = new ClassCodeVisitorSupport(){

                                protected SourceUnit getSourceUnit() {
                                    return source;
                                }

                                public void visitClass(ClassNode node) {
                                    if (node.isEnum()) {
                                        node.setModifiers(node.getModifiers() & 0xFFFFFFEF);
                                    }
                                    super.visitClass(node);
                                }

                                public void visitField(FieldNode fieldNode) {
                                    Expression valueExpr = fieldNode.getInitialValueExpression();
                                    if (valueExpr instanceof ConstantExpression && ClassHelper.STRING_TYPE.equals((Object)valueExpr.getType())) {
                                        fieldNode.setInitialValueExpression((Expression)new MethodCallExpression(valueExpr, "toString", (Expression)new ListExpression()));
                                    }
                                    super.visitField(fieldNode);
                                }

                                public void visitAnnotations(AnnotatedNode node) {
                                    List annotations = node.getAnnotations();
                                    if (!annotations.isEmpty()) {
                                        annotations.clear();
                                    }
                                    super.visitAnnotations(node);
                                }
                            };
                            try {
                                annoRemover.visitClass(classNode);
                            }
                            catch (LinkageError linkageError) {
                                // empty catch block
                            }
                        }
                    }, phase);
                }
                super.addPhaseOperation(op, phase);
            }

            public void gotoPhase(int phase) throws CompilationFailedException {
                if (phase < 4) {
                    out.println("@#$%@# Presentable:Groovy stub generator: " + this.getPhaseDescription());
                } else if (phase <= 9) {
                    out.println("@#$%@# Presentable:Groovyc: " + this.getPhaseDescription());
                }
                super.gotoPhase(phase);
            }
        };
        unit.setCompilerFactory(new JavaCompilerFactory(){

            public JavaCompiler createCompiler(final CompilerConfiguration config) {
                return new JavaCompiler(){

                    public void compile(List<String> files, CompilationUnit cu) {
                        if (mailbox != null) {
                            DependentGroovycRunner.reportCompiledItems(out, GroovyCompilerWrapper.getStubOutputItems((CompilationUnit)unit, (File)config.getJointCompilationOptions().get(DependentGroovycRunner.STUB_DIR)));
                            out.flush();
                            err.flush();
                            DependentGroovycRunner.pauseAndWaitForJavac(mailbox);
                            wrapper.onContinuation();
                        }
                    }
                };
            }
        });
        unit.addSources(new String[]{"SomeClass.java"});
        return unit;
    }

    private static void pauseAndWaitForJavac(Queue<? super Object> mailbox) {
        LinkedBlockingQueue fromJps = new LinkedBlockingQueue();
        mailbox.offer(fromJps);
        try {
            Object response;
            do {
                if ("Build aborted".equals(response = fromJps.poll(1L, TimeUnit.MINUTES))) {
                    throw new RuntimeException("Build aborted");
                }
                if (!"Javac completed".equals(response)) continue;
                return;
            } while (response == null);
            throw new RuntimeException("Unknown response: " + response);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    static GroovyClassLoader buildClassLoaderFor(final CompilerConfiguration compilerConfiguration, final AstAwareResourceLoader resourceLoader) {
        final ClassDependencyLoader checkWellFormed = new ClassDependencyLoader(){

            protected void loadClassDependencies(Class aClass) throws ClassNotFoundException {
                if (resourceLoader.getSourceFile(aClass.getName()) == null) {
                    return;
                }
                super.loadClassDependencies(aClass);
            }
        };
        GroovyClassLoader classLoader = AccessController.doPrivileged(new PrivilegedAction<GroovyClassLoader>(){

            @Override
            public GroovyClassLoader run() {
                return new GroovyClassLoader(Thread.currentThread().getContextClassLoader(), compilerConfiguration){

                    public Class<?> loadClass(String name, boolean lookupScriptFiles, boolean preferClassOverScript) throws ClassNotFoundException, CompilationFailedException {
                        Class aClass;
                        try {
                            aClass = super.loadClass(name, lookupScriptFiles, preferClassOverScript);
                        }
                        catch (NoClassDefFoundError e) {
                            throw new ClassNotFoundException(name);
                        }
                        catch (LinkageError e) {
                            throw new RuntimeException("Problem loading class " + name, e);
                        }
                        return checkWellFormed.loadDependencies(aClass);
                    }
                };
            }
        });
        classLoader.setResourceLoader((GroovyResourceLoader)resourceLoader);
        return classLoader;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "err";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compiledFiles";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/groovy/compiler/rt/DependentGroovycRunner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runGroovyc";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "reportCompiledItems";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "printMessage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

