/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.Location;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.junit.JUnitConfigurationType;
import com.intellij.execution.junit.JUnitExternalLibraryDescriptor;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.icons.AllIcons;
import com.intellij.ide.fileTemplates.FileTemplateDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiUtil;
import com.intellij.testIntegration.JavaTestFramework;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JUnit3Framework
extends JavaTestFramework {
    @NotNull
    public String getName() {
        return "JUnit3";
    }

    public char getMnemonic() {
        return '3';
    }

    public FileTemplateDescriptor getTestClassFileTemplateDescriptor() {
        return new FileTemplateDescriptor("JUnit3 Test Class.java");
    }

    public boolean isSingleConfig() {
        return true;
    }

    public boolean isSuiteClass(PsiClass psiClass) {
        return JUnitUtil.findSuiteMethod((PsiClass)psiClass) != null;
    }

    public boolean isTestMethod(PsiMethod method, PsiClass myClass) {
        return JUnitUtil.isTestMethod((Location)MethodLocation.elementInClass((PsiMethod)method, (PsiClass)myClass));
    }

    public boolean isMyConfigurationType(ConfigurationType type) {
        return type instanceof JUnitConfigurationType;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.RunConfigurations.Junit;
        if (icon == null) {
            JUnit3Framework.$$$reportNull$$$0(0);
        }
        return icon;
    }

    protected String getMarkerClassFQName() {
        return "junit.framework.TestCase";
    }

    @Nullable
    public ExternalLibraryDescriptor getFrameworkLibraryDescriptor() {
        return JUnitExternalLibraryDescriptor.JUNIT3;
    }

    @Nullable
    public String getDefaultSuperClass() {
        return "junit.framework.TestCase";
    }

    public boolean isTestClass(PsiClass clazz, boolean canBePotential) {
        if (JUnitUtil.isJUnit3TestClass((PsiClass)clazz)) {
            return true;
        }
        return JUnitUtil.findSuiteMethod((PsiClass)clazz) != null;
    }

    @Nullable
    protected PsiMethod findSetUpMethod(@NotNull PsiClass clazz) {
        if (clazz == null) {
            JUnit3Framework.$$$reportNull$$$0(1);
        }
        if (!JUnitUtil.isJUnit3TestClass((PsiClass)clazz)) {
            return null;
        }
        for (PsiMethod each : clazz.getMethods()) {
            if (!each.getName().equals("setUp")) continue;
            return each;
        }
        return null;
    }

    @Nullable
    protected PsiMethod findTearDownMethod(@NotNull PsiClass clazz) {
        if (clazz == null) {
            JUnit3Framework.$$$reportNull$$$0(2);
        }
        if (!JUnitUtil.isJUnit3TestClass((PsiClass)clazz)) {
            return null;
        }
        for (PsiMethod each : clazz.getMethods()) {
            if (!each.getName().equals("tearDown")) continue;
            return each;
        }
        return null;
    }

    @Nullable
    protected PsiMethod findOrCreateSetUpMethod(PsiClass clazz) throws IncorrectOperationException {
        PsiMethod inClass;
        PsiMethod baseMethod;
        PsiManager manager = clazz.getManager();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        PsiMethod patternMethod = this.createSetUpPatternMethod((JVMElementFactory)factory);
        PsiClass baseClass = clazz.getSuperClass();
        if (baseClass != null && (baseMethod = baseClass.findMethodBySignature(patternMethod, false)) != null && baseMethod.hasModifierProperty("public")) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)patternMethod, (String)"protected", (boolean)false);
            PsiUtil.setModifierProperty((PsiModifierListOwner)patternMethod, (String)"public", (boolean)true);
        }
        if ((inClass = clazz.findMethodBySignature(patternMethod, false)) == null) {
            PsiMethod testMethod = JUnitUtil.findFirstTestMethod((PsiClass)clazz);
            if (testMethod != null) {
                return (PsiMethod)clazz.addBefore((PsiElement)patternMethod, (PsiElement)testMethod);
            }
            return (PsiMethod)clazz.add((PsiElement)patternMethod);
        }
        if (inClass.getBody() == null) {
            return (PsiMethod)inClass.replace((PsiElement)patternMethod);
        }
        return inClass;
    }

    public FileTemplateDescriptor getSetUpMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("JUnit3 SetUp Method.java");
    }

    public FileTemplateDescriptor getTearDownMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("JUnit3 TearDown Method.java");
    }

    @NotNull
    public FileTemplateDescriptor getTestMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("JUnit3 Test Method.java");
    }

    public boolean isTestMethod(PsiElement element, boolean checkAbstract) {
        return element instanceof PsiMethod && JUnitUtil.getTestMethod((PsiElement)element, (boolean)checkAbstract) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/junit/JUnit3Framework";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/junit/JUnit3Framework";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findSetUpMethod";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findTearDownMethod";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

