/*
 * Decompiled with CFR 0.152.
 */
package org.fest.util;

import java.io.File;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.util.Arrays;
import org.fest.util.Collections;
import org.fest.util.Maps;
import org.fest.util.Preconditions;
import org.fest.util.Strings;

public final class ToString {
    private ToString() {
    }

    @Nullable
    public static String toStringOf(@Nullable Object o) {
        if (Arrays.isArray(o)) {
            return Arrays.format(o);
        }
        if (o instanceof Calendar) {
            return ToString.toStringOf(o);
        }
        if (o instanceof Class) {
            return ToString.toStringOf((Class)o);
        }
        if (o instanceof Collection) {
            return ToString.toStringOf((Collection)o);
        }
        if (o instanceof Date) {
            return ToString.toStringOf(o);
        }
        if (o instanceof Float) {
            return ToString.toStringOf((Float)o);
        }
        if (o instanceof Long) {
            return ToString.toStringOf((Long)o);
        }
        if (o instanceof File) {
            return ToString.toStringOf((File)o);
        }
        if (o instanceof Map) {
            return ToString.toStringOf((Map)o);
        }
        if (o instanceof String) {
            return Strings.quote((String)o);
        }
        if (o instanceof Comparator) {
            return ToString.toStringOf((Comparator)o);
        }
        return o == null ? null : o.toString();
    }

    @Nonnull
    private static String toStringOf(@Nonnull Comparator<?> comparator) {
        String typeName = comparator.getClass().getSimpleName();
        String toString = Strings.quote(!typeName.isEmpty() ? typeName : "Anonymous Comparator class");
        return Preconditions.checkNotNull(toString);
    }

    @Nonnull
    private static String toStringOf(@Nonnull Class<?> c) {
        return c.getCanonicalName();
    }

    @Nonnull
    private static String toStringOf(@Nonnull Collection<?> c) {
        return Preconditions.checkNotNull(Collections.format(c));
    }

    @Nonnull
    private static String toStringOf(@Nonnull Float f) {
        if (f.isNaN()) {
            return "NaN";
        }
        return String.format("%sf", f);
    }

    @Nonnull
    private static String toStringOf(@Nonnull Long l) {
        return String.format("%sL", l);
    }

    @Nullable
    private static String toStringOf(@Nonnull File f) {
        return f.getAbsolutePath();
    }

    @Nonnull
    private static String toStringOf(@Nonnull Map<?, ?> m) {
        return Preconditions.checkNotNull(Maps.format(m));
    }
}

