/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.problemsView;

import com.intellij.analysis.problemsView.AnalysisProblem;
import com.intellij.analysis.problemsView.AnalysisProblemsPresentationHelper;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnalysisProblemsTableModel
extends ListTableModel<AnalysisProblem> {
    private static final TableCellRenderer MESSAGE_RENDERER = new DefaultTableCellRenderer(){

        @Override
        public JLabel getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label2 = (JLabel)super.getTableCellRendererComponent(table, value2, isSelected, false, row, column);
            AnalysisProblem problem = (AnalysisProblem)value2;
            this.setText(problem.getErrorMessage().replaceAll("(\n)+", " "));
            this.setToolTipText(problem.getTooltip());
            String severity = problem.getSeverity();
            this.setIcon("ERROR".equals(severity) ? AllIcons.General.Error : ("WARNING".equals(severity) ? AllIcons.General.Warning : AllIcons.General.Information));
            return label2;
        }
    };
    private static final TableCellRenderer LOCATION_RENDERER = new DefaultTableCellRenderer(){

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
            return super.getTableCellRendererComponent(table, value2, isSelected, false, row, column);
        }
    };
    @NotNull
    private final AnalysisProblemsPresentationHelper myPresentationHelper;
    private final List<AnalysisProblem> myItems;
    private RowSorter.SortKey mySortKey;
    protected int myErrorCount;
    protected int myWarningCount;
    protected int myHintCount;
    private int myErrorCountAfterFilter;
    private int myWarningCountAfterFilter;
    private int myHintCountAfterFilter;
    private final Comparator<AnalysisProblem> myDescriptionComparator;
    private final Comparator<AnalysisProblem> myLocationComparator;

    public AnalysisProblemsTableModel(@NotNull AnalysisProblemsPresentationHelper presentationHelper) {
        if (presentationHelper == null) {
            AnalysisProblemsTableModel.$$$reportNull$$$0(0);
        }
        super(new ColumnInfo[0]);
        this.myItems = new ArrayList<AnalysisProblem>();
        this.mySortKey = new RowSorter.SortKey(1, SortOrder.ASCENDING);
        this.myDescriptionComparator = new ProblemComparator(0);
        this.myLocationComparator = new ProblemComparator(1);
        this.myPresentationHelper = presentationHelper;
        this.setColumnInfos(new ColumnInfo[]{this.createDescriptionColumn(), this.createLocationColumn()});
        this.setItems(this.myItems);
        this.setSortable(true);
    }

    @NotNull
    private ColumnInfo<AnalysisProblem, AnalysisProblem> createDescriptionColumn() {
        return new ColumnInfo<AnalysisProblem, AnalysisProblem>("Description"){

            @Nullable
            public Comparator<AnalysisProblem> getComparator() {
                return AnalysisProblemsTableModel.this.myDescriptionComparator;
            }

            @Nullable
            public TableCellRenderer getRenderer(@NotNull AnalysisProblem problem) {
                if (problem == null) {
                    3.$$$reportNull$$$0(0);
                }
                return MESSAGE_RENDERER;
            }

            @NotNull
            public AnalysisProblem valueOf(@NotNull AnalysisProblem problem) {
                if (problem == null) {
                    3.$$$reportNull$$$0(1);
                }
                AnalysisProblem analysisProblem = problem;
                if (analysisProblem == null) {
                    3.$$$reportNull$$$0(2);
                }
                return analysisProblem;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "problem";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/analysis/problemsView/AnalysisProblemsTableModel$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/analysis/problemsView/AnalysisProblemsTableModel$3";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "valueOf";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getRenderer";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "valueOf";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @NotNull
    private ColumnInfo<AnalysisProblem, String> createLocationColumn() {
        return new ColumnInfo<AnalysisProblem, String>("Location"){

            @Nullable
            public Comparator<AnalysisProblem> getComparator() {
                return AnalysisProblemsTableModel.this.myLocationComparator;
            }

            @Nullable
            public TableCellRenderer getRenderer(AnalysisProblem problem) {
                return LOCATION_RENDERER;
            }

            @NotNull
            public String valueOf(@NotNull AnalysisProblem problem) {
                if (problem == null) {
                    4.$$$reportNull$$$0(0);
                }
                String string = problem.getPresentableLocation();
                if (string == null) {
                    4.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "problem";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/analysis/problemsView/AnalysisProblemsTableModel$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/analysis/problemsView/AnalysisProblemsTableModel$4";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "valueOf";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "valueOf";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    public RowSorter.SortKey getDefaultSortKey() {
        return this.mySortKey;
    }

    public boolean canExchangeRows(int oldIndex, int newIndex) {
        return false;
    }

    public void exchangeRows(int idx1, int idx2) {
        throw new IllegalStateException();
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    protected void removeRows(int firstRow, int lastRow) {
        assert (lastRow >= firstRow);
        for (int i = lastRow; i >= firstRow; --i) {
            AnalysisProblem removed = this.myItems.remove(i);
            if ("ERROR".equals(removed.getSeverity())) {
                --this.myErrorCount;
            }
            if ("WARNING".equals(removed.getSeverity())) {
                --this.myWarningCount;
            }
            if ("INFO".equals(removed.getSeverity())) {
                --this.myHintCount;
            }
            this.updateProblemsCountAfterFilter(removed, -1);
        }
        this.fireTableRowsDeleted(firstRow, lastRow);
    }

    public void removeRows(@NotNull Predicate<? super AnalysisProblem> predicate) {
        if (predicate == null) {
            AnalysisProblemsTableModel.$$$reportNull$$$0(1);
        }
        int firstRow = this.getRowCount();
        int lastRow = -1;
        for (int i = this.getRowCount() - 1; i >= 0; --i) {
            AnalysisProblem problem = this.myItems.get(i);
            if (!predicate.test(problem)) continue;
            this.myItems.remove(i);
            if ("ERROR".equals(problem.getSeverity())) {
                --this.myErrorCount;
            }
            if ("WARNING".equals(problem.getSeverity())) {
                --this.myWarningCount;
            }
            if ("INFO".equals(problem.getSeverity())) {
                --this.myHintCount;
            }
            this.updateProblemsCountAfterFilter(problem, -1);
            firstRow = Math.min(firstRow, i);
            lastRow = Math.max(lastRow, i);
        }
        if (firstRow <= lastRow) {
            this.fireTableRowsDeleted(firstRow, lastRow);
        }
    }

    public void removeAll() {
        int rowCount = this.getRowCount();
        if (rowCount > 0) {
            this.myItems.clear();
            this.fireTableRowsDeleted(0, rowCount - 1);
        }
        this.myErrorCount = 0;
        this.myWarningCount = 0;
        this.myHintCount = 0;
        this.myErrorCountAfterFilter = 0;
        this.myWarningCountAfterFilter = 0;
        this.myHintCountAfterFilter = 0;
    }

    @Nullable
    public AnalysisProblem addProblemsAndReturnReplacementForSelection(@NotNull List<? extends AnalysisProblem> problems, @Nullable AnalysisProblem oldSelectedProblem) {
        if (problems == null) {
            AnalysisProblemsTableModel.$$$reportNull$$$0(2);
        }
        AnalysisProblem newSelectedProblem = null;
        if (!problems.isEmpty()) {
            for (AnalysisProblem analysisProblem : problems) {
                if (oldSelectedProblem != null && AnalysisProblemsTableModel.lookSimilar(analysisProblem, oldSelectedProblem) && (newSelectedProblem == null || Math.abs(oldSelectedProblem.getLineNumber() - newSelectedProblem.getLineNumber()) >= Math.abs(oldSelectedProblem.getLineNumber() - analysisProblem.getLineNumber()))) {
                    newSelectedProblem = analysisProblem;
                }
                if ("ERROR".equals(analysisProblem.getSeverity())) {
                    ++this.myErrorCount;
                }
                if ("WARNING".equals(analysisProblem.getSeverity())) {
                    ++this.myWarningCount;
                }
                if ("INFO".equals(analysisProblem.getSeverity())) {
                    ++this.myHintCount;
                }
                this.updateProblemsCountAfterFilter(analysisProblem, 1);
            }
            this.addRows(problems);
        }
        return newSelectedProblem;
    }

    protected static boolean lookSimilar(@NotNull AnalysisProblem problem1, @NotNull AnalysisProblem problem2) {
        if (problem1 == null) {
            AnalysisProblemsTableModel.$$$reportNull$$$0(3);
        }
        if (problem2 == null) {
            AnalysisProblemsTableModel.$$$reportNull$$$0(4);
        }
        return problem1.getSeverity().equals(problem2.getSeverity()) && problem1.getErrorMessage().equals(problem2.getErrorMessage()) && problem1.getSystemIndependentPath().equals(problem2.getSystemIndependentPath());
    }

    protected void updateProblemsCountAfterFilter(@NotNull AnalysisProblem problem, int delta) {
        if (problem == null) {
            AnalysisProblemsTableModel.$$$reportNull$$$0(5);
        }
        if (this.myPresentationHelper.shouldShowProblem(problem)) {
            if ("ERROR".equals(problem.getSeverity())) {
                this.myErrorCountAfterFilter += delta;
            }
            if ("WARNING".equals(problem.getSeverity())) {
                this.myWarningCountAfterFilter += delta;
            }
            if ("INFO".equals(problem.getSeverity())) {
                this.myHintCountAfterFilter += delta;
            }
        }
    }

    void setSortKey(@NotNull RowSorter.SortKey sortKey) {
        if (sortKey == null) {
            AnalysisProblemsTableModel.$$$reportNull$$$0(6);
        }
        this.mySortKey = sortKey;
    }

    void onFilterChanged() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myPresentationHelper.areFiltersApplied()) {
            this.myErrorCountAfterFilter = 0;
            this.myWarningCountAfterFilter = 0;
            this.myHintCountAfterFilter = 0;
            for (AnalysisProblem problem : this.myItems) {
                this.updateProblemsCountAfterFilter(problem, 1);
            }
        } else {
            this.myErrorCountAfterFilter = this.myErrorCount;
            this.myWarningCountAfterFilter = this.myWarningCount;
            this.myHintCountAfterFilter = this.myHintCount;
        }
    }

    public boolean hasErrors() {
        return this.myErrorCount > 0;
    }

    public boolean hasWarnings() {
        return this.myWarningCount > 0;
    }

    @NotNull
    public String getStatusText() {
        ArrayList<String> summary = new ArrayList<String>();
        if (this.myPresentationHelper.isShowErrors() && this.myErrorCountAfterFilter > 0) {
            summary.add(this.myErrorCountAfterFilter + " " + StringUtil.pluralize((String)"error", (int)this.myErrorCountAfterFilter));
        }
        if (this.myPresentationHelper.isShowWarnings() && this.myWarningCountAfterFilter > 0) {
            summary.add(this.myWarningCountAfterFilter + " " + StringUtil.pluralize((String)"warning", (int)this.myWarningCountAfterFilter));
        }
        if (this.myPresentationHelper.isShowHints() && this.myHintCountAfterFilter > 0) {
            summary.add(this.myHintCountAfterFilter + " " + StringUtil.pluralize((String)"hint", (int)this.myHintCountAfterFilter));
        }
        if (summary.isEmpty()) {
            return this.myPresentationHelper.areFiltersApplied() ? this.myPresentationHelper.getFilterTypeText() : "";
        }
        StringBuilder b = new StringBuilder();
        if (summary.size() == 2) {
            b.append(StringUtil.join(summary, (String)" and "));
        } else {
            b.append(StringUtil.join(summary, (String)", "));
        }
        if (this.myPresentationHelper.areFiltersApplied()) {
            b.append(" (");
            b.append(this.myPresentationHelper.getFilterTypeText());
            b.append(")");
        }
        String string = b.toString();
        if (string == null) {
            AnalysisProblemsTableModel.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentationHelper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problems";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problem1";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problem2";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problem";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sortKey";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/analysis/problemsView/AnalysisProblemsTableModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/analysis/problemsView/AnalysisProblemsTableModel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "removeRows";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addProblemsAndReturnReplacementForSelection";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "lookSimilar";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateProblemsCountAfterFilter";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setSortKey";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ProblemComparator
    implements Comparator<AnalysisProblem> {
        private static final int MESSAGE_COLUMN_ID = 0;
        private static final int LOCATION_COLUMN_ID = 1;
        private final int myColumn;

        ProblemComparator(int column) {
            this.myColumn = column;
        }

        @Override
        public int compare(@NotNull AnalysisProblem problem1, @NotNull AnalysisProblem problem2) {
            int s2;
            int s1;
            if (problem1 == null) {
                ProblemComparator.$$$reportNull$$$0(0);
            }
            if (problem2 == null) {
                ProblemComparator.$$$reportNull$$$0(1);
            }
            if (AnalysisProblemsTableModel.this.myPresentationHelper.isGroupBySeverity() && (s1 = this.getSeverityIndex(problem1)) != (s2 = this.getSeverityIndex(problem2))) {
                return AnalysisProblemsTableModel.this.mySortKey.getSortOrder() == SortOrder.ASCENDING ? s1 - s2 : s2 - s1;
            }
            if (this.myColumn == 0) {
                return StringUtil.compare((String)problem1.getErrorMessage(), (String)problem2.getErrorMessage(), (boolean)false);
            }
            if (this.myColumn == 1) {
                int result2 = StringUtil.compare((String)problem1.getPresentableLocationWithoutLineNumber(), (String)problem2.getPresentableLocationWithoutLineNumber(), (boolean)false);
                if (result2 != 0) {
                    return result2;
                }
                return AnalysisProblemsTableModel.this.mySortKey.getSortOrder() == SortOrder.ASCENDING ? problem1.getLineNumber() - problem2.getLineNumber() : problem2.getLineNumber() - problem1.getLineNumber();
            }
            return 0;
        }

        private int getSeverityIndex(@NotNull AnalysisProblem problem) {
            String severity;
            if (problem == null) {
                ProblemComparator.$$$reportNull$$$0(2);
            }
            if ("ERROR".equals(severity = problem.getSeverity())) {
                return 0;
            }
            if ("WARNING".equals(severity)) {
                return 1;
            }
            return 2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "problem1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "problem2";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "problem";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/analysis/problemsView/AnalysisProblemsTableModel$ProblemComparator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compare";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getSeverityIndex";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

