/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.CodeStyleSchemesConfigurable;
import com.intellij.application.options.OptionsContainingConfigurable;
import com.intellij.application.options.codeStyle.CodeStyleMainPanel;
import com.intellij.application.options.codeStyle.CodeStyleSettingsPanelFactory;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleConfigurableWrapper
implements SearchableConfigurable,
Configurable.NoMargin,
Configurable.NoScroll,
OptionsContainingConfigurable {
    private boolean myInitialResetInvoked;
    protected CodeStyleMainPanel myPanel;
    private final CodeStyleSettingsProvider myProvider;
    private final CodeStyleSettingsPanelFactory myFactory;
    private final CodeStyleSchemesConfigurable myOwner;

    public CodeStyleConfigurableWrapper(@NotNull CodeStyleSettingsProvider provider, @NotNull CodeStyleSettingsPanelFactory factory, CodeStyleSchemesConfigurable owner) {
        if (provider == null) {
            CodeStyleConfigurableWrapper.$$$reportNull$$$0(0);
        }
        if (factory == null) {
            CodeStyleConfigurableWrapper.$$$reportNull$$$0(1);
        }
        this.myProvider = provider;
        this.myFactory = factory;
        this.myOwner = owner;
        this.myInitialResetInvoked = false;
    }

    @Nls
    public String getDisplayName() {
        String displayName = this.myProvider.getConfigurableDisplayName();
        if (displayName != null) {
            return displayName;
        }
        return this.myPanel != null ? this.myPanel.getDisplayName() : null;
    }

    public String getHelpTopic() {
        return this.myPanel != null ? this.myPanel.getHelpTopic() : null;
    }

    public JComponent createComponent() {
        if (this.myPanel == null) {
            this.myPanel = new CodeStyleMainPanel(this.myOwner.getModel(), this.myFactory, this.canBeShared());
        }
        return this.myPanel;
    }

    protected boolean canBeShared() {
        return true;
    }

    public boolean isModified() {
        if (this.myPanel != null) {
            boolean someSchemeModified = this.myPanel.isModified();
            if (someSchemeModified) {
                this.myOwner.resetCompleted();
            }
            return someSchemeModified;
        }
        return false;
    }

    public void apply() throws ConfigurationException {
        this.myOwner.apply();
    }

    public void resetPanel() {
        if (this.myPanel != null) {
            this.myPanel.reset();
        }
    }

    public String toString() {
        return this.myProvider.getClass().getName();
    }

    public void reset() {
        if (!this.myInitialResetInvoked) {
            try {
                this.myOwner.resetFromChild();
            }
            finally {
                this.myInitialResetInvoked = true;
            }
        } else {
            this.myOwner.revert();
        }
    }

    @NotNull
    public String getId() {
        return CodeStyleConfigurableWrapper.getConfigurableId(this.getDisplayName());
    }

    @NotNull
    public Class<?> getOriginalClass() {
        Class<?> clazz = this.myProvider.getClass();
        if (clazz == null) {
            CodeStyleConfigurableWrapper.$$$reportNull$$$0(2);
        }
        return clazz;
    }

    public void disposeUIResources() {
        if (this.myPanel != null) {
            this.myPanel.disposeUIResources();
        }
    }

    public boolean isPanelModified() {
        return this.myPanel != null && this.myPanel.isModified();
    }

    public void applyPanel() throws ConfigurationException {
        if (this.myPanel != null) {
            this.myPanel.apply();
        }
    }

    @Override
    @NotNull
    public Set<String> processListOptions() {
        Set<String> set = this.getOptionIndexer().processListOptions();
        if (set == null) {
            CodeStyleConfigurableWrapper.$$$reportNull$$$0(3);
        }
        return set;
    }

    @Override
    public Map<String, Set<String>> processListOptionsWithPaths() {
        return this.getOptionIndexer().processListOptionsWithPaths();
    }

    @NotNull
    private OptionsContainingConfigurable getOptionIndexer() {
        if (this.myPanel == null) {
            this.myPanel = new CodeStyleMainPanel(this.myOwner.getModel(), this.myFactory, this.canBeShared());
        }
        OptionsContainingConfigurable optionsContainingConfigurable = this.myPanel.getOptionIndexer();
        if (optionsContainingConfigurable == null) {
            CodeStyleConfigurableWrapper.$$$reportNull$$$0(4);
        }
        return optionsContainingConfigurable;
    }

    public void selectTab(@NotNull String tab) {
        if (tab == null) {
            CodeStyleConfigurableWrapper.$$$reportNull$$$0(5);
        }
        this.createComponent();
        this.myPanel.showTabOnCurrentPanel(tab);
    }

    @NotNull
    public static String getConfigurableId(String configurableDisplayName) {
        String string = "preferences.sourceCode." + configurableDisplayName;
        if (string == null) {
            CodeStyleConfigurableWrapper.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public Runnable enableSearch(String option2) {
        return this.myPanel != null ? () -> this.myPanel.highlightOptions(option2) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/CodeStyleConfigurableWrapper";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tab";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/CodeStyleConfigurableWrapper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalClass";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "processListOptions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionIndexer";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurableId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "selectTab";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

