/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.LoadedModuleDescription;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleDescription;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.module.impl.LoadedModuleDescriptionImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.SortedComboBoxModel;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.ComboBoxModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModuleDescriptionsComboBox
extends ComboBox<ModuleDescription> {
    private final SortedComboBoxModel<ModuleDescription> myModel = new SortedComboBoxModel(Comparator.comparing(description -> description != null ? description.getName() : "", String.CASE_INSENSITIVE_ORDER));
    private boolean myAllowEmptySelection;

    public ModuleDescriptionsComboBox() {
        this.setModel((ComboBoxModel)this.myModel);
        this.setSwingPopup(false);
        this.setRenderer((ListCellRenderer)((Object)new ModuleDescriptionListCellRenderer()));
    }

    public void allowEmptySelection(@NotNull String emptySelectionText) {
        if (emptySelectionText == null) {
            ModuleDescriptionsComboBox.$$$reportNull$$$0(0);
        }
        this.myAllowEmptySelection = true;
        this.myModel.add(null);
        this.setRenderer((ListCellRenderer)((Object)new ModuleDescriptionListCellRenderer(emptySelectionText)));
    }

    public void setModules(@NotNull Collection<? extends Module> modules) {
        if (modules == null) {
            ModuleDescriptionsComboBox.$$$reportNull$$$0(1);
        }
        this.myModel.clear();
        for (Module module : modules) {
            this.myModel.add((Object)new LoadedModuleDescriptionImpl(module));
        }
        if (this.myAllowEmptySelection) {
            this.myModel.add(null);
        }
    }

    public void setAllModulesFromProject(@NotNull Project project) {
        if (project == null) {
            ModuleDescriptionsComboBox.$$$reportNull$$$0(2);
        }
        this.setModules(Arrays.asList(ModuleManager.getInstance((Project)project).getModules()));
    }

    public void setSelectedModule(@Nullable Module module) {
        this.myModel.setSelectedItem((Object)(module != null ? new LoadedModuleDescriptionImpl(module) : null));
    }

    public void setSelectedModule(@NotNull Project project, @NotNull String moduleName) {
        Module module;
        if (project == null) {
            ModuleDescriptionsComboBox.$$$reportNull$$$0(3);
        }
        if (moduleName == null) {
            ModuleDescriptionsComboBox.$$$reportNull$$$0(4);
        }
        if ((module = ModuleManager.getInstance((Project)project).findModuleByName(moduleName)) != null) {
            this.setSelectedModule(module);
        } else {
            UnloadedModuleDescription description = ModuleManager.getInstance((Project)project).getUnloadedModuleDescription(moduleName);
            if (description != null) {
                if (this.myModel.indexOf((Object)description) < 0) {
                    this.myModel.add((Object)description);
                }
                this.myModel.setSelectedItem((Object)description);
            } else {
                this.myModel.setSelectedItem(null);
            }
        }
    }

    @Nullable
    public Module getSelectedModule() {
        ModuleDescription selected2 = (ModuleDescription)this.myModel.getSelectedItem();
        if (selected2 instanceof LoadedModuleDescription) {
            return ((LoadedModuleDescription)selected2).getModule();
        }
        return null;
    }

    @Nullable
    public String getSelectedModuleName() {
        ModuleDescription selected2 = (ModuleDescription)this.myModel.getSelectedItem();
        return selected2 != null ? selected2.getName() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptySelectionText";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/application/options/ModuleDescriptionsComboBox";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "allowEmptySelection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setModules";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setAllModulesFromProject";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setSelectedModule";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ModuleDescriptionListCellRenderer
    extends SimpleListCellRenderer<ModuleDescription> {
        private final String myEmptySelectionText;

        ModuleDescriptionListCellRenderer() {
            this("[none]");
        }

        ModuleDescriptionListCellRenderer(@NotNull String emptySelectionText) {
            if (emptySelectionText == null) {
                ModuleDescriptionListCellRenderer.$$$reportNull$$$0(0);
            }
            this.myEmptySelectionText = emptySelectionText;
        }

        public void customize(@NotNull JList<? extends ModuleDescription> list2, ModuleDescription value2, int index, boolean selected2, boolean hasFocus) {
            if (list2 == null) {
                ModuleDescriptionListCellRenderer.$$$reportNull$$$0(1);
            }
            this.setText(value2 == null ? this.myEmptySelectionText : value2.getName());
            this.setIcon(value2 instanceof LoadedModuleDescription ? ModuleType.get((Module)((LoadedModuleDescription)value2).getModule()).getIcon() : (value2 != null ? AllIcons.Modules.UnloadedModule : null));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "emptySelectionText";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/application/options/ModuleDescriptionsComboBox$ModuleDescriptionListCellRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "customize";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

