/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation.render;

import com.intellij.codeHighlighting.EditorBoundHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.documentation.render.DocRenderItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocRenderPassFactory
implements TextEditorHighlightingPassFactoryRegistrar,
TextEditorHighlightingPassFactory {
    private static final Logger LOG = Logger.getInstance(DocRenderPassFactory.class);
    private static final Key<Long> MODIFICATION_STAMP = Key.create((String)"doc.render.modification.stamp");

    @Override
    public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project) {
        if (registrar == null) {
            DocRenderPassFactory.$$$reportNull$$$0(0);
        }
        if (project == null) {
            DocRenderPassFactory.$$$reportNull$$$0(1);
        }
        registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, TextEditorHighlightingPassRegistrar.Anchor.AFTER, 1, false, false);
    }

    @Override
    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor) {
        if (file2 == null) {
            DocRenderPassFactory.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            DocRenderPassFactory.$$$reportNull$$$0(3);
        }
        long current2 = PsiModificationTracker.SERVICE.getInstance((Project)file2.getProject()).getModificationCount();
        Long existing = (Long)editor.getUserData(MODIFICATION_STAMP);
        return editor.getProject() == null || existing != null && existing == current2 ? null : new DocRenderPass(editor, file2);
    }

    @NotNull
    public static Items calculateItemsToRender(@NotNull Document document, @NotNull PsiFile psiFile) {
        if (document == null) {
            DocRenderPassFactory.$$$reportNull$$$0(4);
        }
        if (psiFile == null) {
            DocRenderPassFactory.$$$reportNull$$$0(5);
        }
        boolean enabled = EditorSettingsExternalizable.getInstance().isDocCommentRenderingEnabled();
        Items items = new Items();
        DocumentationManager.getProviderFromElement((PsiElement)psiFile).collectDocComments(psiFile, comment -> {
            TextRange range2 = comment.getTextRange();
            if (range2 != null && DocRenderItem.isValidRange(document, range2)) {
                String textToRender = enabled ? DocRenderPassFactory.calcText(comment) : null;
                items.addItem(new Item(range2, textToRender));
            }
        });
        Items items2 = items;
        if (items2 == null) {
            DocRenderPassFactory.$$$reportNull$$$0(6);
        }
        return items2;
    }

    @NotNull
    static String calcText(@Nullable PsiDocCommentBase comment) {
        String string;
        try {
            PsiElement owner;
            String text2 = null;
            if (comment != null && (owner = comment.getOwner()) != null) {
                text2 = DocumentationManager.getProviderFromElement(owner).generateRenderedDoc(owner);
            }
            string = text2 == null ? CodeInsightBundle.message((String)"doc.render.not.available.text", (Object[])new Object[0]) : text2;
        }
        catch (IndexNotReadyException e) {
            LOG.warn((Throwable)e);
            String string2 = CodeInsightBundle.message((String)"doc.render.dumb.mode.text", (Object[])new Object[0]);
            if (string2 == null) {
                DocRenderPassFactory.$$$reportNull$$$0(8);
            }
            return string2;
        }
        if (string == null) {
            DocRenderPassFactory.$$$reportNull$$$0(7);
        }
        return string;
    }

    public static void applyItemsToRender(@NotNull Editor editor, @NotNull Project project, @NotNull Items items, boolean collapseNewRegions) {
        if (editor == null) {
            DocRenderPassFactory.$$$reportNull$$$0(9);
        }
        if (project == null) {
            DocRenderPassFactory.$$$reportNull$$$0(10);
        }
        if (items == null) {
            DocRenderPassFactory.$$$reportNull$$$0(11);
        }
        editor.putUserData(MODIFICATION_STAMP, (Object)PsiModificationTracker.SERVICE.getInstance((Project)project).getModificationCount());
        DocRenderItem.setItemsToEditor(editor, items, collapseNewRegions);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/documentation/render/DocRenderPassFactory";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/documentation/render/DocRenderPassFactory";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateItemsToRender";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "calcText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerHighlightingPassFactory";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createHighlightingPass";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "calculateItemsToRender";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "applyItemsToRender";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class Item {
        final TextRange textRange;
        final String textToRender;

        private Item(@NotNull TextRange textRange, @Nullable String textToRender) {
            if (textRange == null) {
                Item.$$$reportNull$$$0(0);
            }
            this.textRange = textRange;
            this.textToRender = textToRender;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/codeInsight/documentation/render/DocRenderPassFactory$Item", "<init>"));
        }
    }

    public static class Items
    implements Iterable<Item> {
        private final Map<TextRange, Item> myItems = new LinkedHashMap<TextRange, Item>();

        boolean isEmpty() {
            return this.myItems.isEmpty();
        }

        private void addItem(@NotNull Item item) {
            if (item == null) {
                Items.$$$reportNull$$$0(0);
            }
            this.myItems.put(item.textRange, item);
        }

        @Nullable
        Item removeItem(@NotNull Segment textRange) {
            if (textRange == null) {
                Items.$$$reportNull$$$0(1);
            }
            return this.myItems.remove(TextRange.create((Segment)textRange));
        }

        @Override
        @NotNull
        public Iterator<Item> iterator() {
            Iterator<Item> iterator2 = this.myItems.values().iterator();
            if (iterator2 == null) {
                Items.$$$reportNull$$$0(2);
            }
            return iterator2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textRange";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/documentation/render/DocRenderPassFactory$Items";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/documentation/render/DocRenderPassFactory$Items";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "iterator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addItem";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "removeItem";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class DocRenderPass
    extends EditorBoundHighlightingPass {
        private Items items;

        DocRenderPass(@NotNull Editor editor, @NotNull PsiFile psiFile) {
            if (editor == null) {
                DocRenderPass.$$$reportNull$$$0(0);
            }
            if (psiFile == null) {
                DocRenderPass.$$$reportNull$$$0(1);
            }
            super(editor, psiFile, false);
        }

        @Override
        public void doCollectInformation(@NotNull ProgressIndicator progress2) {
            if (progress2 == null) {
                DocRenderPass.$$$reportNull$$$0(2);
            }
            this.items = DocRenderPassFactory.calculateItemsToRender(Objects.requireNonNull(this.myDocument), this.myFile);
        }

        @Override
        public void doApplyInformationToEditor() {
            DocRenderPassFactory.applyItemsToRender(this.myEditor, this.myProject, this.items, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progress";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/documentation/render/DocRenderPassFactory$DocRenderPass";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doCollectInformation";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

